/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v2Ww
 */

// forked from o8que's the rotating rectangle
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    
    [SWF(width="465",height="465",frameRate="60",backgroundColor="0xFFFFFF")]
    public class Main extends Sprite {
        
        public function Main() {
            const CX:int     = stage.stageWidth / 2;
            const CY:int     = stage.stageHeight / 2;
            const PI2:Number = Math.PI / 180;
            const LT:Number  = 10;
            const VR:Number  = 40;
            const HR:Number  = (CX < CY ? CX : CY) * 0.75 - (VR + LT);
            
            var px:Number = Math.cos(0) * HR + CX;
            var py:Number = -Math.sin(0) * HR + CY;
            var t:Number  = 0;
            
            var veil:Sprite = new Sprite();
            var bar:Sprite;
            
            veil.graphics.beginFill(0x0040C0);
            
            for (var i:int = 0; i < 4; i++) {
                veil.graphics.drawCircle(px, py, VR + LT);
                
                bar = new Sprite();
                bar.graphics.lineStyle(LT, 0xC04000);
                bar.graphics.moveTo(px, py);
                
                px = Math.cos((i + 1) * 90 * PI2) * HR + CX;
                py = -Math.sin((i + 1) * 90 * PI2) * HR + CY;
                
                bar.graphics.lineTo(px, py);
                bar.addEventListener(Event.ENTER_FRAME,
                    (function():Function {
                        var self:Sprite = bar;
                        var dt:Number = i * 180;
                        return function():void {
                            self.x = Math.cos((t + dt) * PI2) * VR;
                            self.y = -Math.sin((t + dt) * PI2) * VR;
                        }
                    })()
                );
                addChild(bar);
            }
            
            veil.graphics.endFill();
            veil.buttonMode = true;
            addChild(veil);
            
            veil.addEventListener(MouseEvent.MOUSE_DOWN,
                function(event:MouseEvent):void { event.target.startDrag(); }
            );
            veil.addEventListener(MouseEvent.MOUSE_UP,
                function(event:MouseEvent):void { event.target.stopDrag(); }
            );
            addEventListener(Event.ENTER_FRAME,
                function(event:Event):void { t += 2; }
            );
            addEventListener(KeyboardEvent.KEY_DOWN,
                function(event:KeyboardEvent):void { if (event.keyCode == 32) veil.x = veil.y = 0; }
            );
        }
    }
}