/**
 * Copyright aont ( http://wonderfl.net/user/aont )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v1l9
 */

package {
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.events.Event;
    import flash.text.TextFieldAutoSize;
    
    [SWF(backgroundColor="#000000",width="276",height="390",frameRate = "30")]
    public class IsingFlash extends Sprite
    {
        private var ising:IsingModel;
        //private var myTimer:Timer;
        private var running:Boolean = true;
        
        private var Temp_tb:TextField;
        private var Bound_tb:TextField;
        private var Times_tb:TextField;
        //private var Interval_tb:TextField;

        private var start_stop_button:TextField;
        public function IsingFlash()
        {
            this.ising = new IsingModel(256,256);
            var bmp:Bitmap = new Bitmap(this.ising.Canvas);
            bmp.x=10;
            bmp.y=10;
            this.addChild(bmp);
            
            this.CreateLabel(10,276,"Tempereture");
            this.Temp_tb = CreateNumField(106,274,"");
            
            this.CreateLabel(10,304,"Bond");
            this.Bound_tb = CreateNumField(106,302,"");
            
            this.CreateLabel(10,332,"Times");
            this.Times_tb = CreateNumField(106,330,"");
            
            //this.CreateLabel(10,360,"Interval");
            //this.Interval_tb = CreateNumField(106,358,"");
            
            var set_button:TextField = CreateButton(221,358,"Set");
            set_button.addEventListener(MouseEvent.CLICK,this.Set_Click);
            
            var reset_button:TextField = CreateButton(154,358,"Reset");
            reset_button.addEventListener(MouseEvent.CLICK,this.Reset_Click);
            
            var init_button:TextField = CreateButton(99,358,"Init");
            init_button.addEventListener(MouseEvent.CLICK,this.isingRandomize);
            
            this.start_stop_button = CreateButton(10,358,"Pause");
            this.start_stop_button.addEventListener(MouseEvent.CLICK,this.start_stop);

            
            //this.myTimer = new Timer(1,0);
            //this.myTimer.addEventListener(TimerEvent.TIMER,Advance);
            this.Reset_Click(null);
            //this.myTimer.start();
            this.addEventListener(Event.ENTER_FRAME,enterframe );
            
        }
        
        private function CreateNumField(x:int,y:int,def:String):TextField
        {
            var tf:TextField = new TextField();
            tf.x=x;
            tf.y=y;
            tf.height = 22;
            tf.width=80;
            
            tf.text=def;
            tf.type = TextFieldType.INPUT;
            tf.background=true;
            tf.backgroundColor=0xffffff;
            tf.border=true;
            tf.borderColor=0x808080;
            this.addChild(tf);
            return tf;
        }
        private function CreateLabel(x:int,y:int,def:String):TextField
        {
            var tf:TextField = new TextField();
            tf.selectable=false;
            tf.textColor = 0xffffff;
            tf.x=x;
            tf.y=y;
            tf.text=def;
            this.addChild(tf);
            return tf;
        }
        private function CreateButton(x:int,y:int,def:String):TextField
        {
            var tf:TextField = new TextField();
            tf.x=x;
            tf.y=y;
            tf.height = 22;
            tf.width=40;
            tf.text=def;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.selectable=false;
            tf.background=true;
            tf.backgroundColor=0xf0f0f0;
            tf.border=true;
            tf.borderColor=0x808080;
            this.addChild(tf);
            return tf;
        }
        
        private function enterframe(event:Event):void
        {
            if(running)
            {            
                //this.myTimer.stop();
                this.ising.Advance();
                //this.myTimer.start();    
            }                
        }
        private function Reset_Click(e:MouseEvent):void
        {            
            this.Temp_tb.text = this.ising.Tempereture.toString();
            this.Bound_tb.text = this.ising.Bound.toString();
            this.Times_tb.text = this.ising.Times.toString();
            //this.Interval_tb.text = this.myTimer.delay.toString();
        }
        private function Set_Click(e:MouseEvent):void
        {                        
             this.ising.Tempereture=Number(this.Temp_tb.text);
             this.ising.Bound=Number(this.Bound_tb.text);
             this.ising.Times=Number(this.Times_tb.text);
             //this.myTimer.delay=Number(this.Interval_tb.text);
        }
        private function isingRandomize(e:MouseEvent):void
        {                        
            this.ising.Randomize();
        }
        
        
        private function start_stop(e:MouseEvent):void
        {
            if(this.running = !this.running)
            {
                //this.myTimer.start();
                this.start_stop_button.text = "Pause";
            }
            else
            {
                //this.myTimer.stop();
                this.start_stop_button.text = "Start";
            }
        }
    }
}
    import flash.display.BitmapData;
    class IsingModel
    {
        public var Width:int;
        public var Height:int;
        public var Canvas:BitmapData;
        //[ArrayElementType("Number")]
        public var States:Vector.<Number>;
        public function IsingModel(Width:int, Height:int)
        {
            this.Bound = 1e-20;
            this.Tempereture=300;
            this.Width=Width;
            this.Height=Height;
            this.Canvas=new BitmapData(Width,Height,false);
            //[ArrayElementType("Number")]
            this.States = new Vector.<Number>(Width*Height);
            Randomize();
        }
        public function Randomize():void
        {            
            var States:Vector.<Number> = this.States;
            for(var w:int=0;w<Width;w++)
            {
                for(var h:int=0;h<Height;h++)
                {
                    var s:int = Math.floor(Math.random()*2)*2-1;
                    States[w+h*Width] = s;
                    if(s==1)
                        this.Canvas.setPixel(w,h,0xffffff);
                    else if(s==-1)
                        this.Canvas.setPixel(w,h,0x000000);                    
                }
            }
        }
        
        public var Bound:Number;
        public var Tempereture:Number;
        public const k_b:Number=1;
        public var Times:int=4048;
        public function Advance():void
        {
            this.Canvas.lock();
            for(var t:int=0;t<this.Times;t++)
            {
                this.AdvanceOnce();
            }
            this.Canvas.unlock();
        }
        
        private function AdvanceOnce():void
        {
            var x:int = Math.floor(Math.random()*this.Width);
            var y:int = Math.floor(Math.random()*this.Height);
            //[ArrayElementType("Number")]
            var States:Vector.<Number> = this.States;
            
            var deltaEnergy:Number = 
                States[(x+1)%this.Width+y*this.Width] + 
                States[(x+this.Width-1)%this.Width+y*this.Width] + 
                States[x+((y+1)%this.Height)*this.Width] + 
                States[x+((y+this.Height-1)%this.Height)*this.Width] ;
            
            deltaEnergy *= 2 * this.Bound * States[x+y*this.Width] ;
            if(deltaEnergy<0)
                Flip(x,y);
            else
            {
                var P:Number=Math.exp(-deltaEnergy/(this.k_b*this.Tempereture));
                if(P>Math.random())
                    Flip(x,y);
            }
        }
        private function Flip(x:int,y:int):void
        {
            var s:int= (this.States[x+y*this.Width] *=-1);
            if(s==1)
                this.Canvas.setPixel(x,y,0xffffff);
            else if(s==-1)
                this.Canvas.setPixel(x,y,0x000000);            
        }
    }