/**
 * Copyright spanvega ( http://wonderfl.net/user/spanvega )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v1UG
 */

package
{
    import flash.geom.*;
    import flash.events.*;
    import flash.display.*;
    import com.bit101.components.*;

    /**  @author SPANVEGA // CHRISTIAN  **/

    [ SWF (width = '465', height = '465', backgroundColor = '0x000000', frameRate = '50')]

    public class MELTING extends Sprite
    {
        private var w : uint = 465, h : uint = 465;
        private var r : Rectangle = new Rectangle (0, 0, w, h);
        private var b : BitmapData = new BitmapData (w, h, true, 0);

        private var d : BitmapData = new BitmapData (size << 1, size << 1, true, 0);
        private var l : BitmapData  = d.clone ();
        private var m : Matrix = new Matrix ();

        private var pool : POOL, p : POINT;

        private var mode : Boolean = false;
        private var quantity : uint = 50;
        private var size : uint = 75;
        private var i : int;

        //

        private var color : uint = 0xFFFFFF;
        private var shape : BitmapData;
        private var blend : String;

        private var halo : HALO;


        public function MELTING ()
        {
            stage ? init () : addEventListener ('addedToStage', init);
        }

        private function init (e : Event = null) : void
        {
            if (hasEventListener ('addedToStage'))
            {removeEventListener ('addedToStage', init);}

            Wonderfl.disable_capture ();
            stage.scaleMode = 'noScale';
            stage.quality = 'low';

            addChild (new Bitmap (b));

            halo = new HALO (w, h);
            halo.mid = 0xA0;

            addChild (new Bitmap (halo));

            draw (l, color, 0x000000);
            draw (d, 0x000000, color);

            change ();

            gui ();

            //

            pool = new POOL (0, 0, w, h);

            for (i = 0; i < quantity; i++)
            {
                pool.add (point ());
            }

            //

            render (); stage.addEventListener ('enterFrame', render);
        }

        private function point () : POINT
        {
            p = new POINT ();
            p.px = Math.random () * pool.width;
            p.py = Math.random () * pool.height;
            p.vx = -2.5 + Math.random () * 5;
            p.vy = -2.5 + Math.random () * 5;
            return p;
        }

        private function render (e : Event = null) : void
        {
            b.fillRect (r, 0);

            pool.update ();

            i = pool.len;
            while (--i > -1)
            {
                p = pool.num (i);
                m.tx = -size + p.px;
                m.ty = -size + p.py;

                b.draw (shape, m, null, blend);
            }
        }

        private function draw (src : BitmapData, a : uint, b : uint) : void
        {
            m.createGradientBox (size << 1, size << 1, 0, 0, 0);

            var g : Shape = new Shape ();
            g.graphics.beginGradientFill
            (
                'radial',
                [a, b],
                [1, 1],
                [0, 0xFF],
                m, 'pad', 'rgb', 0
            );
            g.graphics.drawCircle (size, size, size);
            g.x -= size >> 1;
            g.y -= size >> 1;

            m.identity ();

            src.draw (g);
        }

        private function change () : void
        {
            if (mode)
            {
                background (color);    blend = 'darken';  shape = d; halo.color = color;    halo.render ();
            }
            else
            {
                background (0x000000); blend = 'lighten'; shape = l; halo.color = 0x000000; halo.render ();
            }
        }

        private function background (c : uint) : void
        {
            with (graphics) { clear (); beginFill (c); drawRect  (0, 0, w, h); }
        }

        //

        private function gui () : void
        {
            with (Style) { BACKGROUND = LABEL_TEXT = 0xFFFFFF; DROPSHADOW = BUTTON_FACE = 0x000000; }

            with (addChild (new Sprite ()))
            { graphics.beginFill (0x404040, 0.5); graphics.drawRect (0, 440, 465, 25); }
    
            var s : HUISlider = new HUISlider (this, 10, 445, 'SIZE', _size);
            s.setSliderParams (25, 100, size); s.width = 160; s.labelPrecision = 0; s.tick = 1;

            var q : HUISlider = new HUISlider (this, 155, 445, 'QUANTITY', _quantity);
            q.setSliderParams (10, 100, quantity); q.width = 160; q.labelPrecision = 0; q.tick = 1;

            var c : ColorChooser = new ColorChooser (this, 300, 445, color, _color);
            c.usePopup = true; c.popupAlign = 'top';

            new CheckBox (this, 388, 449, 'ALTERNATE', _mode);
        }

        //

        private function _size (e : Event) : void
        {
            size = e.target.value;

            d = new BitmapData (size << 1, size << 1, true, 0);
            l = d.clone ();

            draw (l, color, 0x000000); 
            draw (d, 0x000000, color);

            shape = mode ? d : l;
        }

        private function _quantity (e : Event) : void
        {
            var num : int;

            quantity = e.target.value;

            if (quantity > pool.len)
            {
                num = quantity - pool.len;

                for (i = 0; i < num; i++)
                {
                    pool.add (point ());
                }
            }
            if (quantity < pool.len)
            {
                num = pool.len - quantity;

                for (i = 0; i < num; i++)
                {
                    pool.del (pool.len-1);
                }
            }
        }

        private function _color (e : Event) : void
        {
            color = e.target.value;

            draw (l, color, 0x000000);
            draw (d, 0x000000, color);

            change ();
        }

        private function _mode (e : Event) : void
        {
            mode = e.target.selected;

            change ();
        }
    }
}

//

import flash.geom.Rectangle;

final class POOL extends Rectangle
{
    private var points : Vector.<POINT>;

    private var p : POINT;


    public function POOL (x : Number, y : Number, width : Number, height : Number)
    {
        super (x, y, width, height);

        points = new <POINT> [];
    }

    public function update () : void
    {
        var i : int = len;
        while (--i > -1)
        {
            p = points [i];

            p.px += p.vx;
            p.py += p.vy;

            if (p.px < x) { p.px = x; p.vx = -p.vx; }
            if (p.py < y) { p.py = y; p.vy = -p.vy; }
            if (p.px > x + width)  { p.px = width  + x; p.vx = -p.vx; }
            if (p.py > y + height) { p.py = height + y; p.vy = -p.vy; }
        }
    }

    public function add (p : POINT) : void
    {
        points.push (p);
    }

    public function del (index : uint) : void
    {
        points.splice (index, 1);
    }

    public function mod (index : uint, p : POINT) : void
    {
        points [index] = p;
    }

    public function num (index : uint) : POINT
    {
        return points [index];
    }

    public function get len () : uint
    {
        return points.length;
    }
}

final class POINT
{
    public var px : Number, py : Number;
    public var vx : Number, vy : Number;
}

//

import flash.display.*;
import flash.geom.Matrix;

internal class HALO extends BitmapData
{
    private var s : Shape = new Shape ();
    private var m : Matrix = new Matrix ();

    public function HALO (w : uint, h : uint) : void
    {
        super (w, h, true, 0);

        m.createGradientBox (w, h);
    }

    public function render () : void
    {   
        if (mid >= 0xFF) mid = 0xFE;

        s.graphics.clear ();
        s.graphics.beginGradientFill
        (
            'radial', [color, color, color], [low / 0xFF, low / 0xFF, high / 0xFF], [0, mid, 0xFF], m, 'pad', 'rgb'
        );
        s.graphics.drawRect (0, 0, width, height);

        fillRect (rect, 0);
        draw (s);
    }

    public var color : uint = 0x000000;

    public var high : uint = 0xFF;

    public var mid : uint = 0x80;

    public var low : uint = 0x00;
}