/**
 * Copyright Hakuhin ( http://wonderfl.net/user/Hakuhin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uzoV
 */

// -------------------------------------------------
//
// トーンフィルタ
// 
// 明度をＸ段階に丸め、
// 用意したＸ段階のトーンテクスチャを明度に応じてタイリング描画します。
//
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.ui.*;
	import flash.media.*;

    public class Main extends Sprite {
        public function Main() {



// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// フレームレート
stage.frameRate = 60;

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// スプライトを作成
var sprite:Sprite = new Sprite();
addChild(sprite);


// 画像のURL
var graphic_url:Array = [
	"http://assets.wonderfl.net/images/related_images/f/f6/f672/f6722295b5bb22b829c936e0b8e72dfdf6d62e55",
];

// リソース読み込み開始
load(load_complete_func,graphic_url);

// 読み込み終了
function load_complete_func():void{
	// 初期化へ
	init();
}

// リソースを格納する入れ物
var bitmap_container : Array = new Array();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load(complete_func:Function,url_array:Array):void{

	// URLを取り出す
	var url : String = url_array.shift();

	// URLが無くなればコールバック関数を呼び出して終了
	if(!url){
		// 読み込み終了
		complete_func();
		return;
	}

	// ローダー
	var loader_obj : Loader = new Loader();

	// 読み込み開始
	loader_obj.load(new URLRequest(url));

	// 読み込み終了
	var info : LoaderInfo = loader_obj.contentLoaderInfo;
	info.addEventListener (Event.INIT,LoaderInfoInitFunc);
	function LoaderInfoInitFunc (event : Event):void {

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.COMPLETE,LoaderInfoCompleteFunc);
		function LoaderInfoCompleteFunc (event : Event):void {

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			stage.addChild(loader_memory);
			bmp.draw(stage);
			stage.removeChild(loader_memory);
	
			// コンテナに格納
			bitmap_container.push(bmp);
  
			// 再帰読み込み
			load(complete_func,url_array);
		}
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	}
}



// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// 動画のURL
	var movie_url:String = "http://actionscript.web.officelive.com/wonderfl/movie000.mp4";

	// ステージサイズ
	var w:uint;
	var h:uint;

	// ビデオを配置
	var video_obj : Video = new Video();
	addChild(video_obj);

	// ストリーム
	var connection:NetConnection = new NetConnection();
	connection.connect(null);	
	var netStream:NetStream = new NetStream(connection);

	// サウンドをOFF
	var trans : SoundTransform = netStream.soundTransform;
	trans.volume = 0.0;
	netStream.soundTransform = trans;

	// ビデオとストリームを関連付け
	video_obj.attachNetStream(netStream);

	// メタデータ取得
	var obj:Object = new Object();
	obj.onMetaData = function(param:Object):void{
	}
	netStream.client = obj;

	// ムービーの読み込み開始
	load_movie(movie_url);

	// リザルト作成
	var result : Sprite = new Sprite();
	addChild(result);
	result.x = 0;

	// ボタン作成
	var button:Button = new Button(stage);
	button.y = 30;
	button.setSize(60,20);
	button.setLabel("開く");
	result.addChild(button);

	// ボタンが押された
	button.addEventListener(MouseEvent.CLICK,function(e:MouseEvent):void{
		load_movie(text.text);
	});
	
	function load_movie(url:String):void{

		// 再生開始
		netStream.play(url);
	}


	// テキストフィールド作成
	var ft_result:TextField = new TextField();
	ft_result.x = 10;
	ft_result.y = 10;
	ft_result.width = 300;
	ft_result.height = 20;
	ft_result.selectable = false;

	// 書式
	var format_result:TextFormat = new TextFormat();
	format_result.font = "ＭＳ ゴシック";	// フォント名
	ft_result.defaultTextFormat = format_result;

	// テキスト表示
	result.addChild(ft_result);

	// 読み込み状況
	addEventListener (Event.ENTER_FRAME,EnterFrameFunc);
	function EnterFrameFunc (event : Event) :void{
		ft_result.text = "読込:" + netStream.bytesLoaded + " / 全体:" + netStream.bytesTotal;
	}

	// テキストフィールド作成
	var text:TextField = new TextField();
	text.x = 10;
	text.y = 30;
	text.height = 20;
	text.type = TextFieldType.INPUT;
	text.border = true;

	// 書式
	var format:TextFormat = new TextFormat();
	format.font = "ＭＳ ゴシック";	// フォント名
	text.defaultTextFormat = format;

	// テキスト表示
	text.text = movie_url;
	result.addChild(text);
	
	// リサイズ時にフィット
	stage.addEventListener(Event.RESIZE,ResizeFunc);
	function ResizeFunc(e:Event):void{
		w = stage.stageWidth;
		h = stage.stageHeight;
		video_obj.width = w;
		video_obj.height = h - 60;
		result.y = h - 60;
	
		// テキストフィールド位置
		text.width = w - 10 - 10 - button.width - 10;
	
		// ボタン位置
		button.x = w - button.width - 10;
	}
	ResizeFunc(null);

	// シェーダバイトコード
	var binary : ByteArray = CustomFilterGetByteArray();
	
	// シェーダ作成
	var shader:Shader = new Shader();
	shader.byteCode = binary;
	var filter:ShaderFilter = new ShaderFilter(shader); 

	// パラメータアクセス用
	var data : ShaderData  = shader.data;
	var param : ShaderParameter;
	var input : ShaderInput;

	// パラメータ
	var width:Number = 64;		// トーンの幅
	var height:Number = 64;		// トーンの高さ
	var bits_per_pixel:Number = 8;	// 色深度
	
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{

		// トーン画像ソース
		input = data.tone;
		input.input = bitmap_container[0];
		
		// トーンの幅
		param = data.width;
		param.value = [width];
		
		// トーンの高さ
		param = data.height;
		param.value = [height];
		
		// 色深度
		param = data.bits_per_pixel;
		param.value = [bits_per_pixel];
		
		//  テクスチャ位置
//		param = data.position;
//		param.value = [mouseX , mouseY];
		
		// 適応
		video_obj.filters = [filter];
	});
}


// -------------------------------------------------
// Youtube から 動画URL取り出し
// -------------------------------------------------
function YoutubeGetURLMovie(url:String,func:Function):void{

	var url_loader : URLLoader = new URLLoader();
	
	// 読み込み完了時に呼び出されるイベント
	url_loader.addEventListener (Event.COMPLETE,function (event : Event):void{
		var str : String = url_loader.data;
	
		// URLデコード
		str = unescape(str);
		
		// 文字位置
		var head : uint = str.search("\"fmt_url_map\"");
		head += 13;
	
		// 総文字数
		var length : uint = str.length;
		
		var code:String;
	
		// | まで進める
		while(true){
			if(length <= head){
				func(null);
				return;
			}
			code = str.charAt(head);
			head ++;
			if(code == '|')		break;
		}
		
		// URL開始
		var begin : uint = head;
		
		// 終了まで進める
		while(true){
			if(length <= head){
				func(null);
				return;
			}
			head ++;
			code = str.charAt(head);
			if(code == ',')		break;
			if(code == '\'')	break;
			if(code == '\"')	break;
		}	
		
		// URL取り出し
		func(str.slice(begin,head));
	});
	
	// HTMLをテキストとして読み込み
	url_loader.load(new URLRequest(url));
}


// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

	var a:ByteArray = new ByteArray();
	var f:Function;

	f = a.writeUnsignedInt;
	f(0xa5010000); f(0x00a40a00); f(0x546f6e65); f(0x46696c74); 
	f(0x6572a00c); f(0x6e616d65); f(0x73706163); f(0x6500746f); 
	f(0x6e6500a0); f(0x0c76656e); f(0x646f7200); f(0x48616b75); 
	f(0x68696e00); f(0xa0087665); f(0x7273696f); f(0x6e000100); 
	f(0xa00c6465); f(0x73637269); f(0x7074696f); f(0x6e008367); 
	f(0x815b8393); f(0x83748342); f(0x838b835e); f(0x00a10102); 
	f(0x00000c5f); f(0x4f757443); f(0x6f6f7264); f(0x00a30004); 
	f(0x73726300); f(0xa3010474); f(0x6f6e6500); f(0xa1020401); 
	f(0x000f6473); f(0x7400a101); f(0x01000002); f(0x77696474); 
	f(0x6800a201); f(0x6d696e56); f(0x616c7565); f(0x003f8000); 
	f(0x00a20164); f(0x65666175); f(0x6c745661); f(0x6c756500); 
	f(0x42800000); f(0xa2016d61); f(0x7856616c); f(0x75650043); 
	f(0x800000a2); f(0x0c646573); f(0x63726970); f(0x74696f6e); 
	f(0x00836781); f(0x5b839382); f(0xcc959d00); f(0xa1010100); 
	f(0x00016865); f(0x69676874); f(0x00a2016d); f(0x696e5661); 
	f(0x6c756500); f(0x3f800000); f(0xa2016465); f(0x6661756c); 
	f(0x7456616c); f(0x75650042); f(0x800000a2); f(0x016d6178); 
	f(0x56616c75); f(0x65004380); f(0x0000a20c); f(0x64657363); 
	f(0x72697074); f(0x696f6e00); f(0x8367815b); f(0x839382cc); 
	f(0x8d8282b3); f(0x00a10101); f(0x02000862); f(0x6974735f); 
	f(0x7065725f); f(0x70697865); f(0x6c00a201); f(0x6d696e56); 
	f(0x616c7565); f(0x003f8000); f(0x00a2016d); f(0x61785661); 
	f(0x6c756500); f(0x43800000); f(0xa2016465); f(0x6661756c); 
	f(0x7456616c); f(0x75650041); f(0x000000a2); f(0x0c646573); 
	f(0x63726970); f(0x74696f6e); f(0x00904690); f(0x5b937881); 
	f(0x69836781); f(0x5b839382); f(0xcc909481); f(0x6a00a101); 
	f(0x02020006); f(0x706f7369); f(0x74696f6e); f(0x00a20264); 
	f(0x65666175); f(0x6c745661); f(0x6c756500); f(0x00000000); 
	f(0x00000000); f(0xa20c6465); f(0x73637269); f(0x7074696f); 
	f(0x6e008365); f(0x834e8358); f(0x83608383); f(0x82cc8dc0); 
	f(0x9557001d); f(0x0300c100); f(0x00100030); f(0x0400f103); 
	f(0x0010001d); f(0x0500f304); f(0x001b0032); f(0x02001000); 
	f(0x0000001d); f(0x03002005); f(0x00000001); f(0x03002005); 
	f(0x0040001d); f(0x03001003); f(0x00800001); f(0x03001005); 
	f(0x00800032); f(0x03002040); f(0x40000004); f(0x04008003); 
	f(0x00800003); f(0x04008003); f(0x00c0001d); f(0x02001004); 
	f(0x0000001d); f(0x03002002); f(0x00c00003); f(0x03002002); 
	f(0x0000001a); f(0x03001003); f(0x0080001d); f(0x03002003); 
	f(0x00c00032); f(0x0300103f); f(0x8000001d); f(0x04008002); 
	f(0x00000002); f(0x04008003); f(0x00c0002a); f(0x04008003); 
	f(0x0080001d); f(0x01808000); f(0x80000034); f(0x00000001); 
	f(0x80000032); f(0x0300103f); f(0x8000001d); f(0x04008002); 
	f(0x00000002); f(0x04008003); f(0x00c0001d); f(0x03002004); 
	f(0x00000036); f(0x00000000); f(0x00000001); f(0x03008002); 
	f(0x00400001); f(0x03004002); f(0x0080001d); f(0x03001003); 
	f(0x00000008); f(0x03001000); f(0x0080001d); f(0x03008003); 
	f(0x00c0001d); f(0x03001003); f(0x00400008); f(0x03001000); 
	f(0x00c0001d); f(0x04008000); f(0x00c00003); f(0x04008003); 
	f(0x0080001d); f(0x04004003); f(0x00c00001); f(0x04004004); 
	f(0x0000001d); f(0x03004004); f(0x00400030); f(0x0400f103); 
	f(0x0010011d); f(0x0100f304); 

	f = a.writeShort;
	f(0x001b); 

	f = a.writeByte;
	f(0x00); 

	return a;
}


        }
	}
}




// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
	パラメータ
    tone            トーンのイメージ
	width           トーンの幅
	height          トーンの高さ
	bits_per_pixel  色深度（トーンの数）
	position        テクスチャの座標
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel ToneFilter<
	namespace : "tone";
	vendor : "Hakuhin";
	version : 1;
	description : "トーンフィルタ";
>{
	input image4 src;	// 入力イメージ
    input image4 tone;  // トーンテクスチャ
	output pixel4 dst;	// 出力ピクセル


	// -------------------------------------
	// パラメータ
	// -------------------------------------
	parameter float width<
		minValue:float(1.0);
		defaultValue:float(64.0);
		maxValue:float(256);
		description : "トーンの幅";
	>;
	parameter float height<
		minValue:float(1.0);
		defaultValue:float(64.0);
		maxValue:float(256);
		description : "トーンの高さ";
	>;
	parameter float bits_per_pixel<
		minValue:float(1);
		maxValue:float(256);
		defaultValue:float(8);
		description : "色深度（トーンの数）";
	>;
	parameter float2 position<
		defaultValue:float2(0.0 , 0.0);
		description : "テクスチャの座標";
	>;

	// -------------------------------------
	// ピクセルごとに実行される関数
	// -------------------------------------
	void evaluatePixel(){

		// ピクセルの位置を取得
		float2 pos = outCoord();
       
        // 色を取得
        pixel4 color = sampleNearest(src,pos); 
        
        // 明度を計算
        float lightness = 0.0;
        lightness  = (color[0] + color[1] + color[2]) / 3.0;
        
        // 明度から段階に変更
        float id = floor(lightness*bits_per_pixel);
        if(id > bits_per_pixel - 1.0) id = bits_per_pixel - 1.0;
 
        // オフセット
        pos.x += position.x;
        pos.y += position.y;
        
        // テクスチャのカラーを取得
        pos.x = mod(pos.x , width);
        pos.y = mod(pos.y , height) + height * id;
        dst = sampleNearest(tone,pos);

	}
}
*/



import flash.events.*;
import flash.display.*;
import flash.text.*;
import flash.geom.*;

// -------------------------------------------------
// ボタン
// -------------------------------------------------
internal class Button extends Sprite {

	private var _width:Number;
	private var _height:Number;
	
	private var _text:TextField;
	private var _background:Sprite;
	

	public function Button(stage:Stage) {
		var slider:Button = this;

		// 背景用スプライト作成
		_background = new Sprite();
		addChild(_background);

		// テキストフィールド
		_text = new TextField();
		addChild(_text);
	
		_text.x = 0;
		_text.y = 0;
		_text.selectable = false;

		// 書式
		var format:TextFormat = new TextFormat();
		format.align = TextFormatAlign.CENTER;	// 整列
		format.font = "ＭＳ ゴシック";	// フォント名
		format.size = 14;				// 文字のポイントサイズ
		format.color = 0x202020;		// 文字の色
		_text.defaultTextFormat = format;
	
		// マウスオーバーで少し明るく
		addEventListener(MouseEvent.MOUSE_OVER,function(e:MouseEvent):void{
			var color : ColorTransform = new ColorTransform(1,1,1,1,8,8,8,0);
			transform.colorTransform = color;
		});

		// マウスアウトで元に戻す
		addEventListener(MouseEvent.MOUSE_OUT,function(e:MouseEvent):void{
			var color : ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);
			transform.colorTransform = color;														   
		});

		// デフォルト値
		setSize(100,100);
		update();
	}
	// リサイズ
	public function setSize(w:Number,h:Number):void{
		// 背景リサイズ
		_width = w;
		_height = h;
		update();
	}
	// ラベルセット
	public function setLabel(str:String):void{
		_text.text = str;
		update();
	}
	// 描画更新
	private function update():void{
		// 背景描画
		var g:Graphics = _background.graphics;
		
		// 角丸矩形描画
		g.clear();
		g.lineStyle ( 0 , 0x808080 , 1.0,false,LineScaleMode.NONE,CapsStyle.ROUND,JointStyle.ROUND);
		g.beginFill ( 0xF0F0F0 , 1.0 );
		g.drawRoundRect ( 0 , 0 , _width , _height , 5 , 5 );
		g.endFill();
		
		// テキスト位置修正
		_text.width  = _width;
		_text.height = _height;
	}
}



// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

	// キャプチャタイミング
	Wonderfl.capture_delay( time );

	
	// スプライト作成
	var sprite : Sprite = new Sprite();

	// ステージ最前面に配置
	stage.addChildAt(sprite,stage.numChildren);
	
	// ローダー
	var loader_obj : Loader = new Loader();
	loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			sprite.addChild(loader_memory);
			bmp.draw(sprite);
			sprite.removeChild(loader_memory);
			loader_memory.unload();
			loader_obj.unload();
			loader_memory = null;
			loader_obj = null;
			
			
			// 画像を配置
			var bmp_obj : Bitmap = new Bitmap(bmp);
			bmp_obj .width = stage.stageWidth;
			bmp_obj .height = stage.stageHeight;
			stage.addChild(bmp_obj );
			
		});
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	});
	
	// 読み込み開始
	loader_obj.load(new URLRequest(url));
}