/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uzm2
 */

package
{
	import fl.controls.ButtonLabelPlacement;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(framerate="30",width="480",height="480",backgroundColor="0x000000")]
	public class Practice08 extends Sprite
	{
		private var zoomFlag:int;
		
		public function Practice08() {
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
			stage.addEventListener(Event.ENTER_FRAME,update);
		}
		
		private function update(e:Event):void {
			if (this.numChildren < 100) {
				var sp:Sphere = new Sphere(10 * Math.random());
				sp.x = (1000 * Math.random()-500);
				sp.y = (1000 * Math.random()-500);
				addChild(sp);
			}
			if (zoomFlag == 1) {
				this.z += 10;
			}else if (zoomFlag == 2) {
				this.z = Math.max(0,this.z-10);
			}
			this.x = 240;
			this.y = 240;
			this.rotation += 1;
		}
		
		private function onMouseMove(e:MouseEvent):void {
			if (zoomFlag != 0) {
				if (e.stageX < 240){
					zoomFlag = 1;
				}else{
					zoomFlag = 2;
				}
			}
		}
		
		private function onMouseDown(e:MouseEvent):void {
			if (e.stageX < 240) {
				zoomFlag = 1;
			}else{
				zoomFlag = 2;
			}
		}
		
		private function onMouseUp(e:MouseEvent):void {
			zoomFlag = 0;
		}
	}

}
import flash.display.MovieClip;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.InterpolationMethod;
import flash.display.MovieClip;
import flash.display.SpreadMethod;

class Sphere extends MovieClip {
	private static const alphas:Array = [100, 100];
	private static const ratios:Array = [20, 255];
	private var radius:Number;
	
	public function Sphere(r:Number):void {
		radius = r;
		var matrix:Matrix = new Matrix(); 
		matrix.createGradientBox(radius * 2, radius * 2, Math.PI / 2, 0, 0);
		var colors:Array = [0xffff00,0xffffff*Math.random()];
		graphics.beginGradientFill(GradientType.RADIAL, colors,alphas,ratios,matrix,
			SpreadMethod.REFLECT, InterpolationMethod.LINEAR_RGB, 0);
		graphics.drawCircle(x, y, radius);
		graphics.endFill();
	}
	
}