/**
 * Copyright momolab ( http://wonderfl.net/user/momolab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uzaN
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    
    import flash.display.Sprite;
    import flash.text.TextFormat;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    import flash.text.engine.FontPosture;
    import flash.text.engine.FontWeight;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextElement;
    import flash.text.engine.TextLine;
    
    public class TestDaumTextEngine extends Sprite {
        private var fontDescription:FontDescription;
        private var elementFormat:ElementFormat;
        private var textEngineLayer:Sprite;
        private var _textField:TextField;
        
        public function TestDaumTextEngine() {
            // Test Text Engine
            var format:TextFormat = new TextFormat();
            format.font = "Malgun Gothic";
            format.size = 20;
            format.color = 0x333333;
            format.bold = false;
            format.italic = false;
            
            createTextField(format);
            
            fontDescription = new FontDescription();
            elementFormat = new ElementFormat();
            textLinesDefaultFormat(format);
            
            textEngineLayer = new Sprite();
            addChild(textEngineLayer);
        }
        
        private function createTextField(format:TextFormat):void {
            _textField = new TextField();
            _textField.type = TextFieldType.INPUT;
            _textField.autoSize = TextFieldAutoSize.LEFT;
            _textField.multiline = true;
            _textField.border = true;
            _textField.borderColor = 0;
            addChild(_textField);
            
            _textField.defaultTextFormat = format;
            
            _textField.addEventListener(Event.CHANGE, textFieldChangeHandler);
        }
        
        private function textFieldChangeHandler(event:Event):void {
            createTextLines(event.target.text);
            
            textEngineLayer.y = _textField.y + _textField.height;
        }
        
        private function createTextLines(value:String):void {
            var textBlock:TextBlock;
            var textElement:TextElement;
            var textLine:TextLine = null;
            
            removeAllTextLine();
            
            textElement = new TextElement(value, elementFormat);
            textBlock = new TextBlock();
            textBlock.content = textElement;
            
            while(textLine = textBlock.createTextLine(textLine)) {
                textEngineLayer.addChild(textLine);
                textLine.y = textEngineLayer.height;
            }
        }
        
        private function textLinesDefaultFormat(format:TextFormat):void {
            fontDescription = fontDescription.clone();
            elementFormat = elementFormat.clone();
            
            fontDescription.fontName = (format.font) ? format.font : fontDescription.fontName;
            elementFormat.fontSize = (format.size) ? Number(format.size) : elementFormat.fontSize;
            elementFormat.color = (format.color) ? uint(format.color) : elementFormat.color;
            fontDescription.fontWeight = (format.bold) ? FontWeight.BOLD : fontDescription.fontWeight;
            fontDescription.fontPosture = (format.italic) ? FontPosture.ITALIC : fontDescription.fontPosture;
            
            elementFormat.fontDescription = fontDescription;
        }
        
        private function removeAllTextLine():void {
            while(textEngineLayer.numChildren) {
                textEngineLayer.removeChildAt(0);
            }
        }
    }
}