/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uzVv
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public var obj:Sprite;
        
        public function FlashTest() {
            
            obj = new Sprite();
            obj.graphics.clear();
            obj.graphics.lineStyle(2,0);
            obj.graphics.drawRect(-32,-32,64,64);
            addChild(obj);
            obj.x = 200;
            obj.y = 200;
            obj.buttonMode = true;
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);
            stage.addEventListener(MouseEvent.MOUSE_UP, mup);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mmove);
        }//ctor
        
        public function kdown(e:KeyboardEvent):void
        {
            if (e.keyCode == Keyboard.PAGE_UP)
            { cmode = 0; }
            
            if (e.keyCode == Keyboard.PAGE_DOWN)
            { cmode = 1; }
            
        }//kdown
        
        public function mmove(e:MouseEvent):void
        {
            pmx = mx;
            pmy = my;
            mx = mouseX;
            my = mouseY;
        }//mmove
        
        public var pmx:Number = 0;
        public var pmy:Number = 0;
        public var mx:Number = 0;
        public var my:Number = 0;
        
        public var cmode:int = 0;
        public var ox:Number = 0;
        public var oy:Number = 0;
        public var mDown:Boolean = false;
        public var pick:Sprite = null;
        
        public function mdown(e:MouseEvent):void
        {
            mDown = true;
            pick = null;
            
            if (obj.hitTestPoint(mouseX,mouseY,false))
            { 
                pick = obj;
                ox = mouseX - pick.x;
                oy = mouseY - pick.y; 
            }
            
        }//mdown
        
        public function mup(e:MouseEvent):void
        {
            mDown = false;
            pick = null;
        }//mup
        
        public function onEnter(e:Event):void
        {
            if (pick)
            {
                if (cmode <= 0)
                {
                    pick.x = mouseX - ox;
                    pick.y = mouseY - oy;
                }
                
                if (cmode == 1)
                {
                    pick.rotation +=  (pmy - my)*-5; 
                    
                }//endif
                
            }//endif
            
            pmx = mx;
            pmy = my;
        }//onenter
        
    }//classend
}