/**
 * Copyright tananuka13 ( http://wonderfl.net/user/tananuka13 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uzVq
 */

package 
{
    import flash.geom.Point;
    import flash.display.BitmapData;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Stage;
    import flash.display.Sprite;
    
    import net.hires.debug.Stats;
    
    [SWF(width="400", height="400", backgroundColor="0xFFFFFF", frameRate="60")]
    public class Main extends Sprite 
    {
        
        private var boxRect:Rectangle
        private var boxMap:BitmapData
        
        public function Main() 
        {
            // render
            Render.init(this)
            // fps
            addChild( new Stats() );
            // init
            createBoxs()
            // update frame
            addEventListener(Event.ENTER_FRAME, update)
        }
        
        private function createBoxs():void
        {
            boxRect = new Rectangle( 50, 150, 100, 100 )
            boxMap = new BitmapData(100,100, false, 0x996633)
            boxMap.fillRect(new Rectangle(0,0,100,1), 0x000000)
        }

        
        public function update(e:Event = null):void
        {
            // fade box
            if (boxRect.height >= 0)
            {
                boxRect.y++
                boxRect.height--
                Render.bm_render.fillRect(boxRect, 0x336699)
                boxMap.scroll(0,1)
                Render.bm_render.copyPixels(boxMap, boxMap.rect, new Point(250,150) )
            }
            else
            {
               createBoxs()
            }

        
            // render
            Render.update()
        }
    }

}



import flash.display.BlendMode;
import flash.geom.ColorTransform;
import flash.filters.BlurFilter;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.display.Sprite;
import flash.display.BitmapData;
import flash.events.Event;
import flash.display.Bitmap;


class Render extends Sprite
{
    private static const ZERO:Point = new Point()
    private static const BLUR:BlurFilter = new BlurFilter(10, 10)
    private static var rect:Rectangle
    public static var bm_render:BitmapData
    private static var bm_black:BitmapData
    private static var main:Sprite
    
    public static function init(main_:Sprite):void
    {
       main = main_
       //main.stage.frameRate = 60
       bm_black = new BitmapData(main.stage.stageWidth, main.stage.stageHeight, false, 0x000000)
       //bm_paint = bm_black.clone()
       bm_render = bm_black.clone()
       //bm_effect = bm_black.clone()
       rect = bm_render.rect
       main.addChildAt( new Bitmap(bm_render), 0 )
       
    }
    
    public static function update(e:Event = null):void
    {
        // render
        bm_render.lock()
        bm_render.draw(bm_render) 
        bm_render.applyFilter( bm_render, rect, ZERO, BLUR)
        bm_render.unlock()
    }

}
