/**
 * Copyright j2e ( http://wonderfl.net/user/j2e )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uys7
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Video;
    
    public class FrameDiff extends Sprite
    {
        private var cam:Camera = Camera.getCamera();
        private var sw:Number = 640;
        private var sh:Number = 480;
        private var pnt:Point = new Point(0,0);
        private var rect:Rectangle = new Rectangle(0,0,sw,sh);
        private var video:Video = new Video(sw, sh);

        private var canvas:BitmapData = new BitmapData(sw, sh, false, 0x000000);
        private var buffer:BitmapData = new BitmapData(sw, sh, false, 0x000000);
        private var feed  :BitmapData = new BitmapData(sw, sh, false, 0x000000);
        private var prev  :BitmapData = new BitmapData(sw, sh, false, 0x000000);

        private var frame:Bitmap = new Bitmap(canvas, "auto", true);
        
        private var _bmdNew:BitmapData;        // bitmapdata from the current pass of the video
        private var _bmdOld:BitmapData;        // bitmapdata from the previous pass of the video
        
        private var _point:Point;            // point used for various filters
        private var _pos:Point                // point used to keep track of general motion
        
        private var _matrix:Matrix;            // matrix used to flip the source video


        public function FrameDiff() 
        {
            addChild(frame);

            cam.setMode(sw, sh, 30);
            video.attachCamera(cam);

            cam.addEventListener(ActivityEvent.ACTIVITY, onActivityStart);
        }

        private function onActivityStart(evt:ActivityEvent):void
        {
            addEventListener(Event.ENTER_FRAME, VideoTracker);
            cam.removeEventListener(ActivityEvent.ACTIVITY, onActivityStart);
        }

        private function onRun(evt:Event):void
        {
            buffer.draw(video);
            //feed.copyPixels(buffer, rect, pnt);
            buffer.draw(prev, null, null, BlendMode.DIFFERENCE);
            //prev.draw(video);
            canvas.copyPixels(buffer, rect, pnt);
        }
        
        
       
        private function VideoTracker(src:Video): void
       {
            // setup default settings
            video   = src;
            _point    = new Point();
            _pos    = new Point();
            _bmdNew    = new BitmapData(src.width, src.height, false, 0);
            _bmdOld    = new BitmapData(src.width, src.height, false, 0);
            //_blur    = new BlurFilter(5, 5);
            
            // add the new bitmap data to the display in case we want to view it to see whats going on
            addChild(frame);
            
            // flip the video input
            setupFlipMatrix();
            canvas.copyPixels(_bmdNew, rect, pnt);
        }
        
        // track the video
        public function track():void
        {
            _bmdNew.draw(video, _matrix);                                // draw the source video and flip the input with the matrix we setup
            _bmdNew.draw(_bmdOld, null, null, BlendMode.DIFFERENCE);    // draw the old frames video on top with a difference blend mode
            //_bmdNew.applyFilter(_bmdNew, _bmdNew.rect, _point, _blur);    // apply a blur filter to soften the areas we are checking
            
            // we now run a threashold over the current bitmapdata so that we can isolate all areas of interest
            // anything over dark grey will be turned to white so we can track it later on
            //_bmdNew.threshold(_bmdNew, _bmdNew.rect, _point, '>', 0xFF333333, 0xFFFFFFFF);
            
            // update the old bitmpadata
            _bmdOld.draw(video, _matrix);
            
            // using the bitmapdata method getColorBoundsRect command we can get the rectangle bounds of
            // a certain colour we are after tracking, in this instance its the white from the threashold
            //var bounds:Rectangle    = _bmdNew.getColorBoundsRect(0xFFFFFFFF, 0xFFFFFFFF, true);
            
            // update the position of the general movement, do this by centering it around the
            // middle of the bounds rectangle
            //var x:Number    = bounds.x + bounds.width*.5;
            //var y:Number    = bounds.y + bounds.height*.5;
            
            // check for zero values, if we get some then dont update the position
            //if (x > 0 && y > 0)
            //{
             //   _pos.x = x;
              //  _pos.y = y;
            //}
        }
        
        // setup matrix to flip the source video so that what we track is relative to
        // the users movement to the screen
        private function setupFlipMatrix():void
        {
            _matrix = new Matrix();                // new matrix
            _matrix.translate(-video.width, 0);        // move left by the width of the source video
            _matrix.scale(-1, 1);                    // flip the scaleX
        }
        
        // return a copy of the position point
        public function get pos():Point        { return _pos.clone(); }


    }
}