/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uyOs
 */

package  
{
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	/**
	 * ...
	 * @author sliz http://game-develop.net/
	 */
	public class TestUnProjectVector extends Sprite
	{
		
		public function TestUnProjectVector() 
		{
			var pp:PerspectiveProjection = new PerspectiveProjection();
			var pm:Matrix3D = pp.toMatrix3D();
			var v3d:Vector3D = new Vector3D(100, 100, 100);
			var v2d:Vector3D = Utils3D.projectVector(pm, v3d);
			trace(v3d);
			trace(v2d);
			trace(unProjectVectorX(pm, v2d, v3d.x));
			trace(unProjectVectorY(pm, v2d, v3d.y));
			trace(unProjectVectorZ(pm, v2d, v3d.z));
		}
		
		private function unProjectVectorX(m:Matrix3D, v2d:Vector3D, x:Number):Vector3D {
			var v3d:Vector3D = new Vector3D();
			v3d.x = x;
			var focalLength:Number = m.rawData[0];
			var fz:Number = v2d.x / x;
			v3d.z = focalLength / fz;
			v3d.y = v2d.y / fz;
			return v3d;
		}
		private function unProjectVectorY(m:Matrix3D, v2d:Vector3D, y:Number):Vector3D {
			var v3d:Vector3D = new Vector3D();
			v3d.y = y;
			var focalLength:Number = m.rawData[0];
			var fz:Number = v2d.y / y;
			v3d.z = focalLength / fz;
			v3d.x = v2d.x / fz;
			return v3d;
		}
		private function unProjectVectorZ(m:Matrix3D, v2d:Vector3D, z:Number):Vector3D {
			var v3d:Vector3D = new Vector3D();
			v3d.z = z;
			var focalLength:Number = m.rawData[0];
			var fz:Number = focalLength / z;
			v3d.x = v2d.x / fz;
			v3d.y = v2d.y / fz;
			return v3d;
		}
		
		private function projectVector(m:Matrix3D, v:Vector3D):Vector3D {
			var rv:Vector3D = new Vector3D();
			var focalLength:Number = m.rawData[0];
			rv.z = focalLength / v.z;
			rv.x = rv.z * v.x;
			rv.y = rv.z * v.y;
			rv.w = 1 / v.z;
			return rv;
		}
	}

}