/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uyMR
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 1024, height = 768)]
    public class Main extends Sprite
    {
        internal var gridNode :Array = [];
        internal var gridList :Number = 0;
        
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            if (stage) {_init()}
            else       {stage.addEventListener(Event.ADDED_TO_STAGE, addedToStage)}
        }
        
        public function addedToStage($e:Event) :void
        {
            _init();
        }
        
        public function _init() :void
        {
            for(var $y:Number = 0; $y < 48; $y++)
            {
                for(var $x:Number = 0; $x < 64; $x++)
                {
                    gridList++;
                    gridNode[gridList] = new Node($x, $y, gridList);
                    addChild(gridNode[gridList]);
                }
            }
            
            gridNode[multiToSingle(4, 4)].color = 0xFF0000;
            
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.75);
            graphics.drawRect  (0, 0, 1023, 767);
        }
        
        public function multiToSingle($x:Number, $y:Number) :Number
        { return($x + (($y * 64) - 64)) }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

class Node extends Sprite
{
    protected var _c:Number;
    protected var _a:Number;
    protected var _gridX:Number;
    protected var _gridY:Number;
    protected var _index:Number;

    public function Node($gridX:Number, $gridY:Number, $index:Number, $c:Number = 0, $a:Number = 0.5)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _c = $c;
        _a = $a;
        _gridX = $gridX;
        _gridY = $gridY;
        _index = $index;
    }
    
    public function addedToStage($e:Event) :void
    {
        _init();
    }
    
    public function _init() :void
    {
       graphics.clear     ();
       graphics.beginFill (_c, _a);
       graphics.drawRect  (_gridX * 16, _gridY * 16, 15, 15);
       graphics.endFill   ();
    }
    
    public function get index() :Number
    { return _index }
    
    public function get color() :Number
    { return _c }
    
    public override function get alpha() :Number
    { return _a }
    
    public function set color($value:Number) :void
    { _c = $value; _init(); }
    
    public override function set alpha($value:Number) :void
    { _a = $value; _init(); }
}
