/**
 * Copyright dwenomo ( http://wonderfl.net/user/dwenomo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uwzv
 */

// forked from sazzzzz's forked from: ビリビリ（Lightning Effect）
// forked from mousepancyo's ビリビリ（Lightning Effect）
/*
比較的簡単に実装できそうな方法で
稲妻というか放電風のビリビリを作ってみました。

マウスクリックでビリビリの出現点が変化します。

編集後に同じネタが上がっているのに気づく…
*/

package {    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.filters.GlowFilter;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="30")]
    
    public class Main extends Sprite{
        private const W:Number = 465;
        private const H:Number = 465;
        private const RANGE:int = 31; // 1,3,5,15,31,93,155,465
        private var _p:Point;
        private var _sp:Sprite;
        private var _ctf:ColorTransform;
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        
        private var _rad:Number = 0.0;

        public function Main() {
            init();
            addEventListener(Event.ENTER_FRAME, update)    ;
            stage.addEventListener(MouseEvent.CLICK, onDown);
        }
        
        private function init():void{
            _p = new Point(W / 2, H / 2);
            _sp = new Sprite();
            _sp.filters = [new GlowFilter(0xC9E6FC, 1, 10, 10, 4, 3, false, false)];
            _ctf = new ColorTransform(0.9, 0.96, 1, 0.9);
            _canvas = new BitmapData(W,H,false,0);
            
            var bm:Bitmap = new Bitmap(_canvas, "auto", true);
            _glow = new BitmapData(W / RANGE, H / RANGE, false, 0);
            
            var glowBm:Bitmap = new Bitmap(_glow, "never", true);
            glowBm.blendMode = "add";
            glowBm.scaleX = RANGE;
            glowBm.scaleY = RANGE;
            
            addChild(bm);
            addChild(glowBm);
        }
        
        private function onDown(e:MouseEvent):void{
            _p = new Point(mouseX, mouseY);
        }
                
        private function update(e:Event):void{
            var p:Point = new Point();
            var num:int = Math.random() * 5;
            p.x = _p.x;
            p.y = _p.y;
            //p.x = mouseX;
            //p.y = mouseY;
            _sp.graphics.clear();
            _sp.graphics.lineStyle(num, 0xFFFFFF, 1-(num / 10));
            _sp.graphics.moveTo(p.x, p.y);
            
            _rad += ( Math.random() * 90.0) * Math.PI / 180.0 * (Math.random() * 2.0 - 1.0);
            var rad:Number = _rad;
            var max:Number = 20.0;
            var speed:int;
            var noise:int;
            
            while( 0 <= p.x && p.x <= W && 0 <= p.y && p.y <= H ){
                speed = Math.random() * 10;
                rad += Math.random() * max * Math.PI / 180.0 * (Math.random() * 2.0 - 1.0);
                noise = Math.random() * 8 - 4;
                p.x += Math.cos(rad) * speed + noise;
                p.y += Math.sin(rad) * speed + noise;
                _sp.graphics.lineTo(p.x, p.y);
                wait(2000);
            }
            
            _canvas.colorTransform(_canvas.rect, _ctf);
            _canvas.draw(_sp);
            _glow.draw(_canvas, new Matrix(1 / RANGE, 0, 0, 1 / RANGE));
        }
    }
      public function wait(count:uint ):void{
    var start:uint = getTimer();
    while(getTimer() - start < count){
    }
 }
}