/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uwyY
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flupie.textanim.*;
	import net.wonderfl.utils.FontLoader;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Sine;
	import org.libspark.betweenas3.tweens.ITween;

	[SWF(width=465, height=465, frameRate=30, backgroundColor=0xffeedd)]
	public class TextAnimation extends Sprite 
	{
		private var anim:TextAnim;
		private var tf:TextField;

		public function TextAnimation():void 
		{
Wonderfl.capture_delay(10);
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			var f:FontLoader = new FontLoader();
			f.load("Aqua");
			f.addEventListener(Event.COMPLETE, onLoad);
		}

		private function onLoad(e:Event):void 
		{
			tf = new TextField();
			const Wid:int = 310;
			var format:TextFormat = new TextFormat("Aqua", 16, 0x777733);
			format.indent = 20;
			tf.defaultTextFormat = format;
			tf.width = Wid;
			tf.wordWrap = true;
			tf.embedFonts = true;
			tf.text = "Down the Rabbit-Hole \n\n\n Alice was beginning to get very tired of sitting by her sister on the bank, and of having nothing to do: once or twice she had peeped into the book her sister was reading, but it had no pictures or conversations in it, ‘and what is the use of a book,’ thought Alice ‘without pictures or conversation?’"
			+ "\n So she was considering in her own mind (as well as she could, for the hot day made her feel very sleepy and stupid), whether the pleasure of making a daisy-chain would be worth the trouble of getting up and picking the daisies, when suddenly a White Rabbit with pink eyes ran close by her.";

			tf.x = (465-Wid)/2;
			tf.y = 50;
			addChild(tf);
			tf.autoSize = TextFieldAutoSize.LEFT;
			stage.addEventListener(MouseEvent.CLICK, onClick);
			createTextAnim(1100);
		}
		private function createTextAnim(delay:int = 0):void
		{
			if (anim != null) {
				anim.dispose();
				addChild(tf);
			}
			anim = new TextAnim(tf);
			anim.mode = TextAnimMode.FIRST_LAST;
			anim.blocksVisible = false;
			anim.effects = myEffect;
			anim.interval = 20;
			anim.start(delay);
		}
		private function myEffect(block:TextAnimBlock):void
		{
			var bez:ITween = BetweenAS3.bezier(block, { }, { x:mouseX-tf.x ,y:mouseY-tf.y}, { x:-200, y:block.y-90}, 1.3, Sine.easeOut);
			bez.play();
		}
		private function onClick(e:MouseEvent):void 
		{
			createTextAnim(20);
		}		
	}	
}