/**
 * Copyright rfkrocktk ( http://wonderfl.net/user/rfkrocktk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uvlX
 */

package {
    import flash.utils.getTimer;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class RegExpTest extends Sprite {
        
        private var textfield:TextField;
        
        public function RegExpTest() {
            this.textfield = new TextField();
            this.textfield.x = this.textfield.y = 10;
            this.textfield.width = stage.stageWidth - 20;
            this.textfield.height = stage.stageHeight - 20;
            this.textfield.defaultTextFormat = new TextFormat("Courier New");
            
            this.addChild(textfield);
            
            this.runtests();
        }
        
        private function runtests():void {
            output("Running Tests");
            output("-------------------------------");
            test("test1", 50000);
            test("test2", 50000);
            test("test3", 50000);
            test("test4", 50000);
            test("test5", 50000);
            test("test6", 50000);
        }
        
        private function test(methodName:String, iterations:int = 100):void {
            output("Testing method: " + methodName + ", " + iterations + " iterations...");    
            
            var wholeTimeStart:Number = getTimer();
            var iterationTimes:Array = [];
            
            for (var i:uint = 0; i < iterations; i++) {
                var iterationTimeStart:Number = getTimer();
                
                var tester:RegExpTester = new RegExpTester();
                // run method.
                (tester[methodName] as Function).apply();
                
                var iterationTimeEnd:Number = getTimer(); 
                iterationTimes.push(iterationTimeEnd - iterationTimeStart);
            }

            var wholeTimeEnd:Number = getTimer();
            
            var wholeTime:Number = wholeTimeEnd - wholeTimeStart;
            
            var average:Number = 0;
            var longest:Number = 0;
            var shortest:Number = int.MAX_VALUE;
            
            for each (var iteration:int in iterationTimes) {
                average += iteration;
                
                if (iteration > longest)
                    longest = iteration;
                    
                if (iteration < shortest)
                    shortest = iteration;
            }

            average /= iterationTimes.length;
            
            output("Test Complete.");
            output("\tAverage Iteration Time: " + average + "ms");
            output("\tLongest Iteration Time: " + longest + "ms");
            output("\tShortest Iteration Time: " + shortest + "ms");
            output("\tTotal Test Time: " + wholeTime + "ms");
            output("-------------------------------");
        }

        
        private function output(message:String):void {
            this.textfield.appendText(message + "\n");
        }

    }
}

class RegExpTester {
    
    private static const expression4:RegExp = /.*a$/;
    
    private static const expression3:RegExp = new RegExp(".*a$");
    
    private var value:String = "There is a wonderful man which is quite smelly.";
    
    private var expression1:RegExp = new RegExp(".*a$");
    
    private var expression2:RegExp = /.*a$/;
    
    public function RegExpTester() {
        
    }

    public function test1():void {
        var result:Array = value.split(expression1);
    }
        
    public function test2():void {
        var result:Array = value.split(expression2);
    }
    
    public function test3():void {
        var result:Array = value.split(new RegExp(".*a$"));
    }
    
    public function test4():void {
        var result:Array = value.split(/.*a$/);
    }
    
    public function test5():void {
        var result:Array = value.split(expression3);
    }

    public function test6():void {
        var result:Array = value.split(expression4);
    }

}
