/**
 * Copyright ken880guchi ( http://wonderfl.net/user/ken880guchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uvbB
 */

package {
  import flash.display.Sprite;
  import flash.events.KeyboardEvent;
  import flash.ui.Keyboard;
  import net.user1.reactor.*;
  import net.user1.logger.Logger;
  
  // メインクラス
  public class UnionRamen extends Sprite {
    // Union用オブジェクト
    protected var reactor:Reactor;
    protected var ramenRoom:Room;
    // Viewオブジェクト
    protected var ramenBowl:Sprite;
    
    // コンストラクタ
    public function UnionRamen () {
      // View作成
      buildUI();
      // 接続用のReactorオブジェクトを作成
      reactor = new Reactor();
      // 接続完了したら readyListener() を起動
      reactor.addEventListener(ReactorEvent.READY, 
                               readyListener);
      // Unionに接続。
      // "tryunion.com:9100"は自由に使えるUnionテスト用の公開サーバーです
      reactor.connect("tryunion.com", 9100);
      reactor.getLog().setLevel(Logger.DEBUG);
    }
    
    // 接続完了時に起動されるメソッド
    protected function readyListener (e:ReactorEvent):void {
      // このアプリ用のルームを作成
      // あなたのアプリ専用のIDを使ってください
      ramenRoom = reactor.getRoomManager().createRoom(
                                   "TestKen");
      // 他ユーザーがこのルームに送信する"ADD_NARUTO"メッセージを監視します
      ramenRoom.addMessageListener("ADD", 
                                   addNarutoListener);
      // ルームに入室
      ramenRoom.join();
    }
    
    // UI作成
    protected function buildUI ():void {
      // キー入力を監視
      stage.addEventListener(KeyboardEvent.KEY_UP, 
                                        keyUpListener);
      // ラーメン容器を作成
      ramenBowl = new Sprite();
      ramenBowl.graphics.beginFill(0xCCCC99);
      ramenBowl.graphics.drawCircle(150, 150, 150);
      addChild(ramenBowl);
    }
    
    // キー入力のリスナー
    protected function keyUpListener (e:KeyboardEvent):void {
      // 未接続だったら何もしない
      if (!reactor.isReady()) {
        return;
      }
      
      // 'n'キーが押されていたら...
      if (e.keyCode == 78) {
        // ...ナルトを容器に追加
        // sendMessage( メッセージ名, 自分自身も受信するかどうか, フィルター )
        ramenRoom.sendMessage("ADD", 
                             true, 
                             null);
      }
    }
    
    // 他ユーザーの"ADD_NARUTO"メッセージ受信時に起動するメソッド
    protected function addNarutoListener (fromClient:IClient):void {
      // 15より多くのナルトが容器にあったら、一番古いナルトを削除しておく
      if (ramenBowl.numChildren > 15) {
        ramenBowl.removeChildAt(0);
      }

      // 容器に新しいナルトを追加
      var naruto:Naruto = new Naruto();
      naruto.x = 40 + Math.floor(Math.random()*150);
      naruto.y = 40 + Math.floor(Math.random()*150);
      ramenBowl.addChild(naruto);
    }
  }
}

import flash.display.Sprite;
class Naruto extends Sprite {
  public function Naruto () {
    draw();
  }

  protected function draw ():void {
    graphics.beginFill(0xFFFFFF);
    graphics.drawCircle(40, 40, 20);
    graphics.beginFill(0xFF5599);
    graphics.drawCircle(40, 40, 7);
  }
}

