/**
 * Copyright o_healer ( http://wonderfl.net/user/o_healer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uvM8
 */

/*
　Play⇔Pause
　・ステージやプレイヤーを再生したり一時停止したりして進むゲーム

　操作方法（How To Play）
　・右の動画をタッチ（Touch : Right Moview）
　　・再生 ⇔ 一時停止（Play <=> Pause）

　比較用
　・Android版（Air）
　　・https://play.google.com/store/apps/details?id=air.showohealer.game.airprototype

　その他
　・できればロゴも作りたかった
　　・左上にYouTube的なやつを
*/


package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
 
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class PlayPause extends Sprite {

        //==File==
//*
        static public const BITMAP_URL:String = "http://assets.wonderfl.net/images/related_images/5/55/5523/552311643fb306acdabbd1ea47f27e16efd7a5e3";
/*/
        [Embed(source='PlayPause.png')]
         private static var Bitmap_Graphic: Class;
//*/

        //==Const==

        //画面の大きさ
        static public const VIEW_W:int = 465;
        static public const VIEW_H:int = 465;

        //パネルの大きさ
        static public const PANEL_W:int = 32;

        //レイアウト
        static public const MOVIE_W:int = PANEL_W * 15;
        static public const MOVIE_H:int = PANEL_W * 10;
        static public const MAIN_MOVIE_SCALE_X:Number = 0.5;
        static public const MAIN_MOVIE_SCALE_Y:Number = 0.5;
        static public const MAIN_MOVIE_X:int = 20;
        static public const MAIN_MOVIE_Y:int = 80;
        static public const SUB_MOVIE_SCALE_X:Number = 0.2;
        static public const SUB_MOVIE_SCALE_Y:Number = 0.2;
        static public const SUB_MOVIE_X:int = 280;
        static public const SUB_MOVIE_Y:int = 80;
        static public const SUB_MOVIE_OFFSET_X:int = 0;
        static public const SUB_MOVIE_OFFSET_Y:int = 90;

        //マップ要素
        static public var MapIter:int = 0;
        static public const O:uint    = MapIter++;
        static public const W:uint    = MapIter++;
        static public const P:uint    = MapIter++;
        static public const G:uint    = MapIter++;
        static public const X:uint    = MapIter++;
        static public const V:uint    = MapIter++;

        //マップ
        static public const MAP:Array = [
[W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,V,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,X,X,X,X,X,X,O,O,O,O,O,X,X,X,X,O,V,O,X,O,O,O,O,O,O,O,O,X,X,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,X,X,X,X,X,X,O,O,O,O,O,X,X,X,X,O,V,O,X,O,O,O,O,O,O,O,X,O,O,X,O,O,O,O,O,O,O,O,O,O,X,O,X,O,O,V,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,V,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,X,X,X,X,X,X,X,V,V,V,V,V,X,X,X,X,O,O,O,X,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,X,X,O,O,O,O,X,O,X,O,O,V,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,X,X,X,X,X,X,X,V,V,V,V,V,X,X,X,X,O,O,O,O,O,V,O,X,O,O,O,X,O,X,X,O,O,O,X,O,O,X,O,O,X,X,X,X,X,O,V,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,V,O,O,O,O,X,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,V,V,V,V,O,O,O,O,O,O,O,V,V,V,V,V,O,O,O,O,O,O,O,O,O,V,O,X,O,O,O,X,O,O,X,O,O,O,X,O,O,X,O,O,X,O,O,O,X,O,V,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,X,X,X,O,O,O,X,O,O,X,O,O,X,O,O,O,X,O,V,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,V,O,X,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,O,O,X,O,O,O,O,O,O,O,O,V,V,V,V,O,O,O,O,O,O,O,O,O,O,O,O,O],
[O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,X,O,O,O,O,O,X,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,V,O,X,O,O,O,X,O,O,O,O,O,O,O,O,O,O,O,X,X,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O],
[W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W],
        ];

        //モード
        static public var s_ModeIter:int = 0;
        static public const MODE_GAME    :int = s_ModeIter++;
        static public const MODE_GOAL    :int = s_ModeIter++;
        static public const MODE_DEAD    :int = s_ModeIter++;


        //==Var==

        //Pseudo Singleton
        static public var Instance:PlayPause;

        //画像
        public var m_BitmapData_BG:BitmapData;
        public var m_BitmapData_Player:BitmapData;
        public var m_BitmapData_Gimmick:BitmapData;

        //動画フレーム（クリッピングなどを兼ねる）
        public var m_MovieFrame_Main:MovieFrame = new MovieFrame(MOVIE_W, MOVIE_H);
        public var m_MovieFrame_SubA:MovieFrame = new MovieFrame(MOVIE_W, MOVIE_H);
        public var m_MovieFrame_SubB:MovieFrame = new MovieFrame(MOVIE_W, MOVIE_H);
        public var m_MovieFrame_SubC:MovieFrame = new MovieFrame(MOVIE_W, MOVIE_H);

        //Play<=>Pauseの表示
        public var m_PlayPause_SubA:Bitmap;
        public var m_PlayPause_SubB:Bitmap;
        public var m_PlayPause_SubC:Bitmap;

        //同期OBJ
        public var m_MovieObject:Vector.<MovieObject> = new Vector.<MovieObject>();

        //プレイヤー
        public var m_Player:MovieObject_Player;
        //ギミック
        public var m_Gimmick:Vector.<MovieObject_Gimmick> = new Vector.<MovieObject_Gimmick>();

        //Text
        public var m_Text:TextField = new TextField();

        //YouTubeに似せる表示全般
        public var m_Bitmap_Gauge_Main:Bitmap;

        //モード
        public var m_Mode:int = 0;//最初のモードから


        //==Function==

        //Init
        public function PlayPause():void {
            if(stage != null){
                Init(null);
            }else{
                addEventListener(
                    Event.ADDED_TO_STAGE,//ステージに追加されたら
                    Init
                );
            }
        }
        public function Init(e:Event):void
        {
            //Pseudo Singleton
            {
                Instance = this;
            }

            //Static Init
            {
                ImageManager.StaticInit();
                MovieObject_Player.StaticInit();
            }

            //BG
            {
                addChild(new Bitmap(new BitmapData(VIEW_W, VIEW_H, false, 0xEAEAEA)));
            }

            //MovieFrame
            {
                //Main
                {
                    m_MovieFrame_Main.x = MAIN_MOVIE_X;
                    m_MovieFrame_Main.y = MAIN_MOVIE_Y;
                    m_MovieFrame_Main.scaleX = MAIN_MOVIE_SCALE_X;
                    m_MovieFrame_Main.scaleY = MAIN_MOVIE_SCALE_Y;

                    addChild(m_MovieFrame_Main);
                }

                //Sub
                {
                    m_MovieFrame_SubA.x = SUB_MOVIE_X + SUB_MOVIE_OFFSET_X * 0;
                    m_MovieFrame_SubA.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 0;
                    m_MovieFrame_SubA.scaleX = SUB_MOVIE_SCALE_X;
                    m_MovieFrame_SubA.scaleY = SUB_MOVIE_SCALE_Y;

                    addChild(m_MovieFrame_SubA);
                }
                {
                    m_MovieFrame_SubB.x = SUB_MOVIE_X + SUB_MOVIE_OFFSET_X * 1;
                    m_MovieFrame_SubB.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 1;
                    m_MovieFrame_SubB.scaleX = SUB_MOVIE_SCALE_X;
                    m_MovieFrame_SubB.scaleY = SUB_MOVIE_SCALE_Y;

                    addChild(m_MovieFrame_SubB);
                }
                {
                    m_MovieFrame_SubC.x = SUB_MOVIE_X + SUB_MOVIE_OFFSET_X * 2;
                    m_MovieFrame_SubC.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 2;
                    m_MovieFrame_SubC.scaleX = SUB_MOVIE_SCALE_X;
                    m_MovieFrame_SubC.scaleY = SUB_MOVIE_SCALE_Y;

                    addChild(m_MovieFrame_SubC);
                }
            }

            //MovieObject
            {
                //ステージ
                {
                    m_BitmapData_BG = new BitmapData(MAP[0].length * PANEL_W, MAP.length * PANEL_W, true, 0x00000000);

                    var mos:MovieObject_Stage;

                    //Main
                    {
                        mos = new MovieObject_Stage(m_BitmapData_BG);
                        m_MovieObject.push(mos);

                        m_MovieFrame_Main.addChild(mos);
                    }

                    //SubA
                    {
                        mos = new MovieObject_Stage(m_BitmapData_BG);
                        m_MovieObject.push(mos);

                        m_MovieFrame_SubA.addChild(mos);
                    }
                }

                //Player
                {
                    m_BitmapData_Player = new BitmapData(PANEL_W, PANEL_W, true, 0xFFFFFFFF);

                    var mop:MovieObject_Player;

                    //Main
                    {
                        mop = new MovieObject_Player();
                        m_MovieObject.push(mop);

                        m_MovieFrame_Main.addChild(mop);

                        m_Player = mop;
                    }

                    //SubB
                    {
                        mop = new MovieObject_Player();
                        m_MovieObject.push(mop);

                        m_MovieFrame_SubB.addChild(mop);
                    }
                }

                //Gimmick
                {
                    m_BitmapData_Gimmick = new BitmapData(2*PANEL_W, 2*PANEL_W, true, 0x00000000);
                    m_BitmapData_Gimmick.fillRect(new Rectangle(PANEL_W/2, PANEL_W/2, PANEL_W, PANEL_W), 0xFF888888);

                    var mog:MovieObject_Gimmick;

                    //SubC
                    {
                        mog = new MovieObject_Gimmick(MOVIE_W/2 - PANEL_W/2, MOVIE_H/2 - PANEL_W/2, m_BitmapData_Gimmick);
                        mog.m_UseOffsetX = false;
                        m_MovieObject.push(mog);

                        m_MovieFrame_SubC.addChild(mog);
                    }

                    var xx:int;
                    var yy:int;
                    var pos_x:int;
                    var pos_y:int;
                    var MapNumX:int = MAP[0].length;
                    var MapNumY:int = MAP.length;

                    for(yy = 0; yy < MapNumY; ++yy){
                        pos_y = yy * PANEL_W;
                        for(xx = 0; xx < MapNumX; ++xx){
                            pos_x = xx * PANEL_W;

                            switch(MAP[yy][xx]){
                            case V:
                                //Main
                                {
                                    mog = new MovieObject_Gimmick(pos_x, pos_y, m_BitmapData_Gimmick);
                                    m_MovieObject.push(mog);

                                    m_MovieFrame_Main.addChild(mog);

                                    m_Gimmick.push(mog);
                                }
                            }
                        }
                    }
                }
            }

            //Play <=> Pause
            {
                //Sub
                {
                    m_PlayPause_SubA = new Bitmap(ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PLAY]);
                    m_PlayPause_SubA.x = m_MovieFrame_SubA.x;
                    m_PlayPause_SubA.y = m_MovieFrame_SubA.y;
                    addChild(m_PlayPause_SubA);
                }
                {
                    m_PlayPause_SubB = new Bitmap(ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PLAY]);
                    m_PlayPause_SubB.x = m_MovieFrame_SubB.x;
                    m_PlayPause_SubB.y = m_MovieFrame_SubB.y;
                    addChild(m_PlayPause_SubB);
                }
                {
                    m_PlayPause_SubC = new Bitmap(ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PLAY]);
                    m_PlayPause_SubC.x = m_MovieFrame_SubC.x;
                    m_PlayPause_SubC.y = m_MovieFrame_SubC.y;
                    addChild(m_PlayPause_SubC);
                }
            }

            //Text
            {
                var text:TextField;

                //TextFormat
                var tf:TextFormat;
                {
                    tf = new TextFormat();
                    tf.color = 0xFF000000;
                    tf.font = "Verdana";
                }
/*
                //Logo
                {
                }
//*/
                //Main
                {
                    //Title
                    {
                        tf.size = 24;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "Play⇔Pause";

                        text.x = MAIN_MOVIE_X;
                        text.y = MAIN_MOVIE_Y - 35;

                        addChild(text);
                    }

                    //Info
                    {
                        tf.size = 8;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "o_healerさんが2012/06/15にアップロード";

                        text.x = MAIN_MOVIE_X;
                        text.y = MAIN_MOVIE_Y + MOVIE_H * MAIN_MOVIE_SCALE_Y + 20;

                        addChild(text);
                    }

                    //Info
                    {
                        tf.size = 10;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "右の３つの動画をタッチすることで\n左の動画をコントロールするゲームです。\n\nプレイヤーがトゲに当たらないように\nステージの奥を目指してください。";

                        text.x = MAIN_MOVIE_X;
                        text.y = MAIN_MOVIE_Y + MOVIE_H * MAIN_MOVIE_SCALE_Y + 50;

                        addChild(text);
                    }
                }

                //SubA
                {
                    //Title
                    {
                        tf.size = 12;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "Stage";

                        text.x = SUB_MOVIE_X + MOVIE_W * SUB_MOVIE_SCALE_X + 8;
                        text.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 0;

                        addChild(text);
                    }

                    //Info
                    {
                        tf.size = 8;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "ユーザー:o_healer\nXXX,XXX回再生";

                        text.x = SUB_MOVIE_X + MOVIE_W * SUB_MOVIE_SCALE_X + 8;
                        text.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 0 + 20;

                        addChild(text);
                    }
                }

                //SubB
                {
                    //Title
                    {
                        tf.size = 12;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "Player";

                        text.x = SUB_MOVIE_X + MOVIE_W * SUB_MOVIE_SCALE_X + 8;
                        text.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 1;

                        addChild(text);
                    }

                    //Info
                    {
                        tf.size = 8;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "ユーザー:o_healer\nXXX,XXX回再生";

                        text.x = SUB_MOVIE_X + MOVIE_W * SUB_MOVIE_SCALE_X + 8;
                        text.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 1 + 20;

                        addChild(text);
                    }
                }

                //SubC
                {
                    //Title
                    {
                        tf.size = 12;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "Gimmick";

                        text.x = SUB_MOVIE_X + MOVIE_W * SUB_MOVIE_SCALE_X + 8;
                        text.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 2;

                        addChild(text);
                    }

                    //Info
                    {
                        tf.size = 8;

                        text = new TextField();
                        text.selectable = true;
                        text.autoSize = TextFieldAutoSize.LEFT;
                        text.defaultTextFormat = tf;
                        text.text = "ユーザー:o_healer\nXXX,XXX回再生";

                        text.x = SUB_MOVIE_X + MOVIE_W * SUB_MOVIE_SCALE_X + 8;
                        text.y = SUB_MOVIE_Y + SUB_MOVIE_OFFSET_Y * 2 + 20;

                        addChild(text);
                    }
                }

                //補足
                {
                    tf.size = 12;
                    tf.color = 0xFFFF0000;

                    text = new TextField();
                    text.selectable = true;
                    text.autoSize = TextFieldAutoSize.LEFT;
                    text.defaultTextFormat = tf;
                    text.text = "↓Touch";

                    text.x = SUB_MOVIE_X;
                    text.y = SUB_MOVIE_Y - 22;

                    addChild(text);
                }
            }

            //Text
            {
                m_Text.selectable = false;
                m_Text.autoSize = TextFieldAutoSize.LEFT;
                m_Text.defaultTextFormat = new TextFormat('Verdana', 32, 0xFFFFFF, true);
                m_Text.text = "";
//                m_Text.filters = [new GlowFilter(0x00FFFF,1.0, 8,8)];

                addChild(m_Text);
            }

            //YouTubeに似せる表示
            {
                var bmd:BitmapData;
                var bmp:Bitmap;

                const GaugeW:int = MOVIE_W * MAIN_MOVIE_SCALE_X;
                const GaugeH:int = 8;

                //Gauge Base
                bmd = new BitmapData(GaugeW, GaugeH, false, 0x222222);
                bmp = new Bitmap(bmd);
                bmp.x = MAIN_MOVIE_X;
                bmp.y = MAIN_MOVIE_Y + MOVIE_H * MAIN_MOVIE_SCALE_Y;
                addChild(bmp);

                //Gauge Now
                bmd = new BitmapData(GaugeW, GaugeH, false, 0xAA0000);
                bmp = new Bitmap(bmd);
                bmp.x = MAIN_MOVIE_X;
                bmp.y = MAIN_MOVIE_Y + MOVIE_H * MAIN_MOVIE_SCALE_Y;
                bmp.scaleX = 0;
                addChild(bmp);
                m_Bitmap_Gauge_Main = bmp;
            }

            //Touch
            {
                stage.addEventListener(MouseEvent.MOUSE_DOWN, OnMouseDown);
            }

            //Update
            {
                addEventListener(Event.ENTER_FRAME, Update);
            }

            //OnEnd
            {
                addEventListener(Event.REMOVED_FROM_STAGE, Finish);
            }

//*
            //wonderfl用：Bitmapを外部からロードする場合

            //Load
            var loader:Loader = new Loader();
            loader.load(new URLRequest(BITMAP_URL), new LoaderContext(true));//画像のロードを開始して
            loader.contentLoaderInfo.addEventListener(
                Event.COMPLETE,//ロードが完了したら
                function(e:Event):void{
                    OnLoad(loader.content);//それを保持した後
                }
            );
/*/
            //ローカル用：Bitmapを事前ロードできる場合

            //ブロック画像のセット（＆その他初期化）
            OnLoad(new Bitmap_Graphic());
//*/
        }

        //OnLoad
        public function OnLoad(in_Graphic:DisplayObject):void{
            ImageManager.Init(in_Graphic);

            //Draw

            //BG
            ImageManager.DrawBG(MAP, m_BitmapData_BG);

            //Needle
            m_BitmapData_Gimmick.draw(in_Graphic, new Matrix(1,0,0,1, -16*5,-16*0));

            //Player
            {
                var mtx:Matrix = new Matrix(1,0,0,1, 0,0);
                var clip_rect:Rectangle = new Rectangle(0,0, 32,32);

                clip_rect.width  = 24;
                clip_rect.height = 32;

                mtx.ty = -96;
                for(var j:int = 0; j < 3; ++j){
                    mtx.tx = -24*j;
                    var bmd:BitmapData = MovieObject_Player.s_BitmapData[j];
                    bmd.fillRect(bmd.rect, 0x00000000);
                    bmd.draw(in_Graphic, mtx, null, null, clip_rect);
                }
            }
        }

        //Finish
        public function Finish(e:Event):void{
            removeEventListener(Event.ADDED_TO_STAGE, Init);
            removeEventListener(Event.ENTER_FRAME, Update);
            removeEventListener(Event.REMOVED_FROM_STAGE, Finish);
        }

        //Touch
        private function OnMouseDown(e:MouseEvent):void{
            //SubA
            if(m_MovieFrame_SubA.IsRangeIn(this.mouseX, this.mouseY)){
                MovieObject_Stage.FlipPlayFlag();
                if(MovieObject_Stage.s_PlayFlag){
                    m_PlayPause_SubA.bitmapData = ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PLAY];
                }else{
                    m_PlayPause_SubA.bitmapData = ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PAUSE];
                }
            }
            //SubB
            if(m_MovieFrame_SubB.IsRangeIn(this.mouseX, this.mouseY)){
                MovieObject_Player.FlipPlayFlag();
                if(MovieObject_Player.s_PlayFlag){
                    m_PlayPause_SubB.bitmapData = ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PLAY];
                }else{
                    m_PlayPause_SubB.bitmapData = ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PAUSE];
                }
            }
            //SubC
            if(m_MovieFrame_SubC.IsRangeIn(this.mouseX, this.mouseY)){
                MovieObject_Gimmick.FlipPlayFlag();
                if(MovieObject_Gimmick.s_PlayFlag){
                    m_PlayPause_SubC.bitmapData = ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PLAY];
                }else{
                    m_PlayPause_SubC.bitmapData = ImageManager.m_BitmapData_PlayPause[ImageManager.GRAPHIC_PAUSE];
                }
            }
        }

        //Update
        public function Update(e:Event=null):void{
            var DeltaTime:Number = 1.0 / stage.frameRate;

            if(m_Mode != MODE_GAME){
                return;
            }

            //Static Update
            {
                MovieObject_Stage.StaticUpdate(DeltaTime);
                MovieObject_Player.StaticUpdate(DeltaTime);
                MovieObject_Gimmick.StaticUpdate(DeltaTime);

                m_Bitmap_Gauge_Main.scaleX = -MovieObject_Stage.s_OffsetX / (MAP[0].length * PANEL_W - MOVIE_W);
            }

            //Update Obj
            {
                var num:int = m_MovieObject.length;
                for(var i:int = 0; i < num; ++i){
                    m_MovieObject[i].Update();
                }
            }

            //Check Goal & Dead
            {
                Check_Hit();

                Check_Goal();
            }
        }

        //Check : Hit
        public function Check_Hit():void{
            var i:int;
            var j:int;
            var IndexX:int;
            var IndexY:int;

            var PlayerX:Number = m_Player.x;
            var PlayerY:Number = m_Player.y;

            const Offset:Array = [
                [ PANEL_W/4, -PANEL_W/4],
                [ PANEL_W/4,  PANEL_W/4],
                [-PANEL_W/4, -PANEL_W/4],
                [-PANEL_W/4,  PANEL_W/4],
            ];
            const OffsetNum:int = Offset.length;

            const MapNumX:int = MAP[0].length;
            const MapNumY:int = MAP.length;

            //Map
            {
                for(j = 0; j < OffsetNum; ++j){
                    IndexX = (PlayerX + Offset[j][0] - MovieObject_Stage.s_OffsetX) / PANEL_W;
                    IndexY = (PlayerY + Offset[j][1]) / PANEL_W;

                    //Range
                    if(IndexX < 0){continue;}
                    if(MapNumX <= IndexX){continue;}
                    if(IndexY < 0){continue;}
                    if(MapNumY <= IndexY){continue;}

                    if(MAP[IndexY][IndexX] == X){
                        //Hit

                        OnDead();

                        return;
                    }
                }
            }

            //Gimmick
            {
                var GimmickNum:int = m_Gimmick.length;
                for(i = 0; i < GimmickNum; ++i){
                    var gimmick:MovieObject_Gimmick = m_Gimmick[i];

                    for(j = 0; j < OffsetNum; ++j){
                        var RelX:Number = PlayerX + Offset[j][0] - gimmick.x;
                        var RelY:Number = PlayerY + Offset[j][1] - gimmick.y;

                        if(0 <= RelX && RelX <= PANEL_W && 0 <= RelY && RelY <= PANEL_W){
                            //Hit

                            OnDead();

                            return;
                        }
                    }
                }
            }
        }

        //Check : Goal
        public function Check_Goal():void{
            if(MovieObject_Stage.s_OffsetX <= -MAP[0].length * PANEL_W + MOVIE_W){
                OnGoal();
            }
        }

        //GameOver : Dead
        public function OnDead():void{
            m_Text.text = "FAILED";
            m_Text.x = MAIN_MOVIE_X + (MOVIE_W * MAIN_MOVIE_SCALE_X)/2 - m_Text.textWidth/2;
            m_Text.y = MAIN_MOVIE_Y + (MOVIE_H * MAIN_MOVIE_SCALE_Y)/2 - m_Text.textHeight/2;

            m_Mode = MODE_DEAD;
        }

        //GameOver : Goal
        public function OnGoal():void{
            m_Text.text = "CLEAR";
            m_Text.x = MAIN_MOVIE_X + (MOVIE_W * MAIN_MOVIE_SCALE_X)/2 - m_Text.textWidth/2;
            m_Text.y = MAIN_MOVIE_Y + (MOVIE_H * MAIN_MOVIE_SCALE_Y)/2 - m_Text.textHeight/2;

            m_Mode = MODE_GOAL;
        }
    }
}


import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.net.*;
import flash.system.*;
import flash.ui.*;


class ImageManager
{
    //==Const==

    //#Graphic
    static public var m_GraphicIndexIter:int = 0;

    static public const GRAPHIC_INDEX_BG:int            = m_GraphicIndexIter++;

    static public const GRAPHIC_INDEX_WALL:int            = m_GraphicIndexIter++;
    static public const GRAPHIC_INDEX_WALL_X:int        = m_GraphicIndexIter++;
    static public const GRAPHIC_INDEX_WALL_Y:int        = m_GraphicIndexIter++;
    static public const GRAPHIC_INDEX_WALL_XorY:int        = m_GraphicIndexIter++;
    static public const GRAPHIC_INDEX_WALL_XandY:int    = m_GraphicIndexIter++;

    static public const GRAPHIC_INDEX_NEEDLE:int        = m_GraphicIndexIter++;
    static public const GRAPHIC_INDEX_NEEDLE_X:int        = m_GraphicIndexIter++;
    static public const GRAPHIC_INDEX_NEEDLE_Y:int        = m_GraphicIndexIter++;
    static public const GRAPHIC_INDEX_NEEDLE_XY:int        = m_GraphicIndexIter++;

    static public const GRAPHIC_INDEX_NUM:int            = m_GraphicIndexIter;


    static public const GRAPHIC_PLAY:int            = 0;
    static public const GRAPHIC_PAUSE:int            = 1;
    static public const GRAPHIC_PLAY_PAUSE_NUM:int    = 2;


    //#enum:Quater
    static public const LU:int = 0;
    static public const RU:int = 1;
    static public const LD:int = 2;
    static public const RD:int = 3;

    //#enum:Pos
    static public const POS_X:int = 0;
    static public const POS_Y:int = 1;


    //#Graphic
    static public var m_BitmapData_View:BitmapData;
    static public var m_BitmapData_PlayPause:Vector.<BitmapData> = new Vector.<BitmapData>(GRAPHIC_PLAY_PAUSE_NUM);

    //#Mapping
    static public var GRAPHIC_INDEX_TO_POS:Array;


    //#Palette
    static public var m_Palette_ForView:Array;


    //#Utility
    static public const POS_ZERO:Point = new Point(0,0);


    //==Function==

    //#Static Init
    static public function StaticInit():void{
        var i:int;
        var col:uint;

        //Play <=> Pause
        {
            const LINE_W:int = 2;
            const COLOR_ON:uint  = 0xFFFFFF;
            const COLOR_OFF:uint = 0x888888;
            const ALPHA:Number = 1.0;
            const SQRT2:Number = Math.sqrt(2);

            var shape:Shape = new Shape();
            var g:Graphics = shape.graphics;

            var w:int = PlayPause.MOVIE_W * PlayPause.SUB_MOVIE_SCALE_X;
            var h:int = PlayPause.MOVIE_H * PlayPause.SUB_MOVIE_SCALE_Y;
            var rad:int = w * 12/100;
            var in_rad:int = rad * 70/100;
            var offset:int = w*25/100;
            var arrow_len:int = w * 10/100;
            var arrow_w:int = rad * 50/100;

            for(i = 0; i < GRAPHIC_PLAY_PAUSE_NUM; ++i)
            {
                m_BitmapData_PlayPause[i] = new BitmapData(w, h, true, 0x00000000);
                g.clear();

                //Play
                {
                    //Color
                    if(i == GRAPHIC_PLAY){
                        col = COLOR_ON;
                    }else{
                        col = COLOR_OFF;
                    }
                    g.lineStyle(LINE_W, col, ALPHA);

                    //Circle
                    g.drawCircle(offset, h/2, rad);

                    //Play
                    g.beginFill(col, ALPHA);
                    g.moveTo(offset + in_rad, h/2);
                    g.lineTo(offset - in_rad / 2, h/2 - in_rad / SQRT2);
                    g.lineTo(offset - in_rad / 2, h/2 + in_rad / SQRT2);
                    g.endFill();
                }

                //⇔
                {
                    g.lineStyle(LINE_W, COLOR_OFF, ALPHA);

                    g.moveTo(w/2 - arrow_len + arrow_w, h/2 - arrow_w);
                    g.lineTo(w/2 - arrow_len, h/2);
                    g.lineTo(w/2 - arrow_len + arrow_w, h/2 + arrow_w);
                    g.moveTo(w/2 + arrow_len - arrow_w, h/2 - arrow_w);
                    g.lineTo(w/2 + arrow_len, h/2);
                    g.lineTo(w/2 + arrow_len - arrow_w, h/2 + arrow_w);
                    g.moveTo(w/2 - arrow_len + arrow_w/2, h/2 - arrow_w/2);
                    g.lineTo(w/2 + arrow_len - arrow_w/2, h/2 - arrow_w/2);
                    g.moveTo(w/2 - arrow_len + arrow_w/2, h/2 + arrow_w/2);
                    g.lineTo(w/2 + arrow_len - arrow_w/2, h/2 + arrow_w/2);
                }

                //Pause
                {
                    //Color
                    if(i == GRAPHIC_PLAY){
                        col = COLOR_OFF;
                    }else{
                        col = COLOR_ON;
                    }
                    g.lineStyle(LINE_W, col, ALPHA);

                    //Circle
                    g.drawCircle(w-offset, h/2, rad);

                    //Pause
                    g.lineStyle(LINE_W*1.5, col, ALPHA);
                    g.moveTo(w-offset - in_rad / 2, h/2 - in_rad / SQRT2);
                    g.lineTo(w-offset - in_rad / 2, h/2 + in_rad / SQRT2);
                    g.moveTo(w-offset + in_rad / 2, h/2 - in_rad / SQRT2);
                    g.lineTo(w-offset + in_rad / 2, h/2 + in_rad / SQRT2);
                }

                //Apply
                m_BitmapData_PlayPause[i].draw(shape);
            }
        }
    }

    //#Init
    static public function Init(in_Graphic:DisplayObject):void{
        var x:int, y:int, i:int;

        //m_BitmapData_View
        {
            m_BitmapData_View = new BitmapData(256, 256, false, 0x000000);
            m_BitmapData_View.draw(in_Graphic);
        }

        //GRAPHIC_INDEX_TO_POS
        {//GRAPHIC_INDEX_～から画像の位置へのマッピング（さらにどの隅での処理かも含む）（そして左から何マス目、上から何マス目、という指定）
            GRAPHIC_INDEX_TO_POS = new Array(GRAPHIC_INDEX_NUM);

            //[LU][RU][LD][RD]

            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_BG]            = [[3,2], [3,2], [3,2], [3,2]];

            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_WALL]        = [[1,1], [1,1], [1,1], [1,1]];
            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_WALL_X]        = [[0,1], [2,1], [0,1], [2,1]];
            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_WALL_Y]        = [[1,0], [1,0], [1,2], [1,2]];
            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_WALL_XorY]    = [[0,0], [2,0], [0,2], [2,2]];
            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_WALL_XandY]    = [[3,0], [4,0], [3,1], [4,1]];

            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_NEEDLE]        = [[3,3], [4,3], [3,4], [4,4]];
            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_NEEDLE_X]    = [[0,4], [2,4], [0,4], [2,4]];
            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_NEEDLE_Y]    = [[1,3], [1,3], [1,5], [1,5]];
            GRAPHIC_INDEX_TO_POS[GRAPHIC_INDEX_NEEDLE_XY]    = [[0,3], [2,3], [0,5], [2,5]];
        }

        //m_Palette_ForView
        {
            m_Palette_ForView = new Array(256);

            var index_graphic:int = GRAPHIC_INDEX_BG;
            for(i = 0; i < 256; i++){
                //区切りごとにindexを変更。次の区切りまではその値をセット
                switch(i){
                case 0:
                case 6:
                case 18:
                case 24:
                    index_graphic = GRAPHIC_INDEX_BG; break;
                case 3:
                case 21:
                    index_graphic = GRAPHIC_INDEX_NEEDLE_Y; break;
                case 9:
                case 15:
                    index_graphic = GRAPHIC_INDEX_NEEDLE_X; break;
                case 12:
                    index_graphic = GRAPHIC_INDEX_NEEDLE_XY; break;
                case 27:
                    index_graphic = GRAPHIC_INDEX_NEEDLE; break;
                case 54:
                case 63:
                    index_graphic = GRAPHIC_INDEX_WALL_XorY; break;
                case 60:
                case 69:
                    index_graphic = GRAPHIC_INDEX_WALL_X; break;
                case 72:
                    index_graphic = GRAPHIC_INDEX_WALL_Y; break;
                case 78:
                    index_graphic = GRAPHIC_INDEX_WALL_XandY; break;
                case 80:
                    index_graphic = GRAPHIC_INDEX_WALL; break;
                }

                m_Palette_ForView[i] = index_graphic;
            }
        }
    }

    //#Draw : BG
    static public function DrawBG(in_Map:Array, out_BitmapData_View:BitmapData):void
    {
        out_BitmapData_View.lock();

        var x:int, y:int, i:int;
        var mtx:Matrix = new Matrix();

        var NumX:int = in_Map[0].length;
        var NumY:int = in_Map.length;

        //Map => Bitmap_Base
        //Mapの要素を元に、「０：空白」「１：トゲ」「２：壁」というBitmapを生成
        var BitmapData_Base:BitmapData;
        {
            BitmapData_Base = new BitmapData(NumX, NumY, false, 0x000000);
            for(y = 0; y < NumY; y++){
                for(x = 0; x < NumX; x++){
                    var index:int = 0;//default(O, P, G)
                    {
                        switch(in_Map[y][x]){
                        case PlayPause.W:
                            index = 2;
                            break;
                        case PlayPause.X:
                            index = 1;
                            break;
                        }
                    }

                    BitmapData_Base.setPixel(x, y, index);
                }
            }
        }

        //Bitmap_Base => Bitmap_LU,Bitmap_RU,Bitmap_LD,Bitmap_RD
        //Bitmap_Baseを元に、四隅の隣接状況をそれぞれ求める(Uniqueな値になるようにする)
        var BitmapData_Quater:Array = new Array(4);
        {
            //Create Filter
            const filter:Array = [
                new ConvolutionFilter(3,3,
                    [//LU
                        1,  3,  0,
                        9, 27,  0,
                        0,  0,  0,
                    ]
                ),
                new ConvolutionFilter(3,3,
                    [//RU
                        0,  3,  1,
                        0, 27,  9,
                        0,  0,  0,
                    ]
                ),
                new ConvolutionFilter(3,3,
                    [//LD
                        0,  0,  0,
                        9, 27,  0,
                        1,  3,  0,
                    ]
                ),
                new ConvolutionFilter(3,3,
                    [//RD
                        0,  0,  0,
                        0, 27,  9,
                        0,  3,  1,
                    ]
                ),
            ];

            for(i = 0; i < 4; i++){
                //Init
                BitmapData_Quater[i] = new BitmapData(NumX, NumY, false, 0x000000);

                //Apply Filter
                BitmapData_Quater[i].applyFilter(BitmapData_Base, BitmapData_Base.rect, POS_ZERO, filter[i]);
            }
        }

        //Bitmap_LU,Bitmap_RU,Bitmap_LD,Bitmap_RD => ForView
        //Uniqueな値から、対応するIndexへと変換する
        var BitmapData_ForView:Array = new Array(4);
        {
            for(i = 0; i < 4; i++){
                //Init
                BitmapData_ForView[i] = new BitmapData(NumX, NumY, false, 0x000000);

                //Apply Palette
                BitmapData_ForView[i].paletteMap(BitmapData_Quater[i], BitmapData_Quater[i].rect, POS_ZERO, null, null, m_Palette_ForView);
            }
        }


        //Draw
        //上で求めたIndexに基づき描画
        {
            var rect:Rectangle = new Rectangle(0,0, 16,16);

            for(y = 0; y < NumY; y++){
                for(x = 0; x < NumX; x++){
                    for(i = 0; i < 4; i++){
                        rect.x = x * 32 + 16 * ((i&1)>>0);
                        rect.y = y * 32 + 16 * ((i&2)>>1);

                        //#view
                        mtx.tx = rect.x - 16 * GRAPHIC_INDEX_TO_POS[BitmapData_ForView[i].getPixel(x, y)][i][POS_X];
                        mtx.ty = rect.y - 16 * GRAPHIC_INDEX_TO_POS[BitmapData_ForView[i].getPixel(x, y)][i][POS_Y];
                        out_BitmapData_View.draw(m_BitmapData_View, mtx, null, null, rect);
                    }
                }
            }
        }

        out_BitmapData_View.unlock();
    }
}

import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.net.*;
import flash.system.*;
import flash.text.*;


class MovieFrame extends Sprite
{
    //==Var==

    public var m_W:int;
    public var m_H:int;

    //==Function==

    //Init
    public function MovieFrame(in_W:int, in_H:int){
        //Param
        {
            m_W = in_W;
            m_H = in_H;
        }

        //BG
        {
            addChild(new Bitmap(new BitmapData(in_W, in_H, false, 0x000000)));
        }

        //Clipping
        {
            scrollRect = new Rectangle(0, 0, in_W, in_H);
        }
    }

    //Check : Range
    public function IsRangeIn(in_X:int, in_Y:int):Boolean{
        return (this.x <= in_X && in_X <= this.x + m_W * this.scaleX && this.y <= in_Y && in_Y <= this.y + m_H * this.scaleY);
    }
}


class MovieObject extends Sprite
{
    //==Function==

    //Update(virtual)
    virtual public function Update():void{
    }
}


class MovieObject_Stage extends MovieObject
{
    //==Const==

    //移動速度（１秒で何ドット動くか）
    static public const SCROLL_VEL:Number = PlayPause.PANEL_W * 1.0;


    //==Static==

    static public var s_PlayFlag:Boolean = true;
    static public var s_OffsetX:Number = 0;

    static public function FlipPlayFlag():void{
        s_PlayFlag = !s_PlayFlag;
    }

    static public function StaticUpdate(in_DeltaTime:Number):void{
        if(! s_PlayFlag){return;}
        s_OffsetX -= SCROLL_VEL * in_DeltaTime;
    }


    //==Function==

    //Init
    public function MovieObject_Stage(in_BMD:BitmapData){
        var smoothing:Boolean = true;
        addChild(new Bitmap(in_BMD, PixelSnapping.NEVER, smoothing));
    }

    //Update
    override public function Update():void{
        this.x = s_OffsetX;
    }
}


class MovieObject_Player extends MovieObject
{
    //==Const==

    //移動まわり
    static public const MOVE_TIME:Number = 4.0;
    static public const MOVE_RAD:Number = (PlayPause.MOVIE_H - 3*PlayPause.PANEL_W)/2;
    static public const MOVE_CENTER_X:Number = PlayPause.PANEL_W * 1.0;
    static public const MOVE_CENTER_Y:Number = PlayPause.MOVIE_H/2;

    //表示画像
    static public var s_BitmapData:Vector.<BitmapData> = new Vector.<BitmapData>;

    //アニメーション用パラメータ
    static public const ANIM_CYCLE:Number = MOVE_TIME/4;
    static public const ANIM_ITER:Array = [0,1,2,1];
    static public const ANIM_NUM:int = ANIM_ITER.length;


    //==Static==

    static public var s_PlayFlag:Boolean = true;
    static public var s_Timer:Number = 0;

    static public function FlipPlayFlag():void{
        s_PlayFlag = !s_PlayFlag;
    }

    static public function StaticUpdate(in_DeltaTime:Number):void{
        if(! s_PlayFlag){return;}

        s_Timer += in_DeltaTime;
        if(MOVE_TIME <= s_Timer){
            s_Timer -= MOVE_TIME;
        }
    }


    //==Var==

    //画像表示
    public var m_Bitmap:Bitmap;


    //==Function==

    //Static Init
    static public function StaticInit():void{
        s_BitmapData = new Vector.<BitmapData>(3);
        for(var j:int = 0; j < 3; ++j){
            s_BitmapData[j] = new BitmapData(24, 32, true, 0x11FFFFFF);
        }
    }

    //Init
    public function MovieObject_Player(){
        var smoothing:Boolean = true;
        var bmp:Bitmap = new Bitmap(s_BitmapData[0], PixelSnapping.NEVER, smoothing);
        bmp.x = -PlayPause.PANEL_W/2;
        bmp.y = -PlayPause.PANEL_W/2;
        addChild(bmp);

        m_Bitmap = bmp;
    }

    //Update
    override public function Update():void{
        this.x = MOVE_CENTER_X;
        this.y = MOVE_CENTER_Y + MOVE_RAD * Math.sin(2*Math.PI * s_Timer / MOVE_TIME);

        Update_Anim();
    }

    //Update : Anim
    public function Update_Anim():void{
        //m_AnimTimer => iter
        var iter:int;
        {
            iter = ANIM_ITER[int(ANIM_NUM * s_Timer/ANIM_CYCLE)];
        }

        m_Bitmap.bitmapData = s_BitmapData[iter];
    }
}


class MovieObject_Gimmick extends MovieObject
{
    //==Const==

    //移動まわり
    static public const MOVE_TIME:Number = 2.0;
    static public const MOVE_RAD:Number = (PlayPause.MOVIE_H - 3*PlayPause.PANEL_W)/2;


    //==Static==

    static public var s_PlayFlag:Boolean = true;
    static public var s_Timer:Number = 0;

    static public function FlipPlayFlag():void{
        s_PlayFlag = !s_PlayFlag;
    }

    static public function StaticUpdate(in_DeltaTime:Number):void{
        if(! s_PlayFlag){return;}

        s_Timer += in_DeltaTime;
        if(MOVE_TIME <= s_Timer){
            s_Timer -= MOVE_TIME;
        }
    }


    //==Var==

    //基準位置
    public var m_BaseX:Number = 0;
    public var m_BaseY:Number = 0;

    //
    public var m_UseOffsetX:Boolean = true;


    //==Function==

    //Init
    public function MovieObject_Gimmick(in_X:int, in_Y:int, in_BMD:BitmapData){
        //Param
        {
            m_BaseX = in_X;
            m_BaseY = in_Y;
        }

        //Graphic
        {
            var smoothing:Boolean = true;
            var bmp:Bitmap = new Bitmap(in_BMD, PixelSnapping.NEVER, smoothing);
            bmp.x = -PlayPause.PANEL_W/2;
            bmp.y = -PlayPause.PANEL_W/2;
            addChild(bmp);
        }
    }

    //Update
    override public function Update():void{
        this.x = m_BaseX;
        this.y = m_BaseY + MOVE_RAD * Math.sin(2*Math.PI * s_Timer / MOVE_TIME);

        if(m_UseOffsetX){
            this.x += MovieObject_Stage.s_OffsetX;
        }
    }
}
