/**
 * Copyright blashstar ( http://wonderfl.net/user/blashstar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uuIX
 */

// forked from hacker_4tp8ypoc's forked from: forked from: forked from:  PV3D Bezier Lines with TweenLite
// forked from hacker_4tp8ypoc's forked from: forked from:  PV3D Bezier Lines with TweenLite
// forked from htgmanics's forked from:  PV3D Bezier Lines with TweenLite
// forked from marco's  PV3D Bezier Lines with TweenLite
/**
 * PV3D Bezier Lines with TweenLite
 * @author Marco Di Giuseppe
 * @see http://designmarco.com
 * @since 4/9/09
 */
package
{
	import gs.TweenLite;
	import gs.plugins.TweenPlugin;
	import gs.plugins.BezierPlugin;
	import net.hires.debug.Stats;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.objects.special.ParticleField;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.materials.shadematerials.PhongMaterial;

	[SWF(width="465", height="465", backgroundColor="0x000033", frameRate="30")]
	public class Main extends BasicView
	{
		private var lines:int = 15;
		private var duration:int = 20;
		private var orb:Sphere;
		private var vertex:Vertex3D;
		private var bezierLine:Lines3D;
		private var lineMaterial:LineMaterial;

		public function Main()
		{
			init();
		}

		private function init():void
		{
			TweenPlugin.activate([BezierPlugin]);
			
			orb = new Sphere(new PhongMaterial(new PointLight3D(), 0x00FF00, 0x336633, 5), 25, 25, 25);
			scene.addChild(orb);
			
			_camera.focus = 11;
			_camera.zoom = 100;
			//_camera.target = orb;
			
			lineMaterial = new LineMaterial(0x00FF00);
			lineMaterial.smooth = lineMaterial.tiled = true;
			
			bezierLine = new Lines3D(lineMaterial);
			scene.addChild(bezierLine);
			
			var particleField:ParticleField = new ParticleField(new ParticleMaterial(0xFFFF00, 1, 1), 200, 4);
			scene.addChild(particleField);
                  
			addChild(new Stats());
			calculatePoints();
		}

		private function calculatePoints():void
		{
			var pointsArray:Array = [];
			var i:int = lines;
			while (--i != 0)
			{
				var controlPoint:Object = { x:randomInt(-1000, 1000), y:randomInt(-1000, 1000), z:randomInt(-1000, 1000) };
				pointsArray[pointsArray.length] = controlPoint;
			}
                   
			vertex = new Vertex3D();
			TweenLite.to(orb, duration, { x:0, y:0, z:0, bezier:pointsArray, onComplete:resetLines, onUpdate:render});
		}

		private function randomInt(min:int, max:int):int
		{
			return min + int(Math.random() * (max - min + 1));
		}

		private function resetLines():void
		{
			bezierLine.geometry.faces = [];
			bezierLine.geometry.vertices = [];
			bezierLine.removeAllLines();
			vertex = null;
			calculatePoints();
		}

		private function render():void
		{
			bezierLine.addLine(new Line3D(bezierLine, lineMaterial, 2, new Vertex3D(orb.x, orb.y, orb.z), vertex));
			vertex = new Vertex3D(orb.x, orb.y, orb.z);
			//_camera.x += (((mouseX - 233) * 10) - _camera.x) * 0.05;
			//_camera.y += (((mouseY - 233) * 10) - _camera.y) * 0.05;
			//_camera.z = orb.z - 600;
            //    
			singleRender();
		}
	}
}