/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uu64
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.text.TextFormat;
    
    import a24.tween.Ease24;
    import a24.tween.Tween24;
    
    
    
    [SWF(frameRate="30", width="465", height="465")]
    
    public class Main extends Sprite
    {
        
        private var flickManager:FlickManager = new FlickManager();
        private var _baseObject:RectObject;
        
        private var _isFlick:Boolean;
        
        private var colorPicker:ColorPicker;
        private var _colorList:Array = [];
        
        
        public function Main()
        {
            stage.align = StageAlign.TOP_LEFT;
            
            //
            _baseObject = new RectObject( 465, 465 );
            addChild( _baseObject );
            
            
            var menu:PullDownMenu = new PullDownMenu( 150, 25, [ "((((；ﾟДﾟ)))", "(´；ω；`)ﾌﾞﾜｯ", "＼（｀∀´）ﾉ", "m9(・∀・)", "(⌒^⌒)b", "(*｀∀´*)ノ", "|･ω･｀)", "(￣^￣)ゞ", "‎(´･∀･`) ニヤニヤ", "(￣π π￣)" ], new TextFormat( "_ゴシック", 14, 0, null, null, null, null, null, "center" ));
            menu.x = 10;
            menu.y = 10;
            _baseObject.addChild( menu );
            
            menu.addEventListener( Event.CHANGE, onChange );
            
            //
            _baseObject.addEventListener( MouseEvent.MOUSE_DOWN, onDown );
            flickManager.addEventListener( FlickManager.FLICK_RIGHT, onFrick );
            flickManager.addEventListener( FlickManager.FLICK_LEFT, onFrick );
            flickManager.addEventListener( FlickManager.FLICK_CANCEL, onFrick );
            
            //
            for (var i:int = 0; i < 81; i++) 
            {
                _colorList.push( Math.random() * 0xFFFFFF | 0 );
            }
            
            
            
            colorPicker = new ColorPicker( 50, 50, _colorList );
            colorPicker.addEventListener( Event.CHANGE, onColorChange );
            colorPicker.x = 465 * .5 - (25);
            colorPicker.y = 465 * .5 - (25);
            addChild( colorPicker );
        }
        
        // Menu onChange
        private function onChange( e:Event ) : void
        {
            trace( "#", e.target.data );
        }
        
        
        // Flick Trigger ( Stage Press )
        private function onDown( e:MouseEvent ):void
        {
            if( _isFlick ) return;
            
            flickManager.flickCheck( _baseObject, stage );
            _baseObject.startDrag( false, new Rectangle( -640, 0, 640 * 2, 0 ) );
            
        }
        
        // FlickEventHandler Example
        private function onFrick( e:Event ):void
        {
            trace( e.type );
            _baseObject.stopDrag();
            
            _isFlick = true;
            
            if( e.type == "flick_right" )
            {
                Tween24.serial(
                    Tween24.tween( _baseObject, .3, Ease24._6_ExpoOut ).x( 640 ),
                    Tween24.prop( _baseObject, { x:-640 } ),
                    Tween24.tween( _baseObject, .3, Ease24._6_ExpoOut ).x( 0 ).delay( .1 ),
                    Tween24.func( function():void 
                    {
                        _isFlick = false;
                    })
                ).play();
            }
            else if( e.type == "flick_left" )
            {
                Tween24.serial(
                    Tween24.tween( _baseObject, .3, Ease24._6_ExpoOut ).x( -640 ),
                    Tween24.prop( _baseObject, { x:640 } ),
                    Tween24.tween( _baseObject, .3, Ease24._6_ExpoOut ).x( 0 ).delay( .1 ),
                    Tween24.func( function():void 
                    {
                        _isFlick = false;
                    })
                ).play();
            }
            else if( e.type == "flick_cancel" )
            {
                Tween24.serial(
                    Tween24.tween( _baseObject, .1, Ease24._6_ExpoOut ).x( 0 ),
                    Tween24.func( function():void 
                    {
                        _isFlick = false;
                    })
                ).play();
            }
        }
        
        
        // ColorChange
        private function onColorChange( e:Event ):void
        {
            _baseObject.colorChange( colorPicker.color );
        }
        
    }
}



//
import flash.display.Graphics;
import flash.display.Sprite;

internal class RectObject extends Sprite
{
    public function RectObject( w:int, h:int )
    {
        var g:Graphics = this.graphics;
        g.beginFill( 0xFFCC00 );
        g.drawRect( 0, 0, w, h );
    }
    
    public function colorChange( col:int ):void
    {
        var w:int = width;
        var h:int = height;
        
        var g:Graphics = this.graphics;
        g.clear();
        
        g.beginFill( col );
        g.drawRect( 0, 0, w, h );
    }
}




// ---------- Color Pickert ----------------------------------------- /

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;

internal class ColorPicker extends Sprite
{
    public var color:int;
    
    private var _selectTile:ColorTile;
    
    private var _tileContainer:Sprite;
    private var _tiles:Array = [];
    
    private var _colorList:Array = [];
    public function get colorList():Array
    {
        return _colorList;
    }
    
    private var _tileWidth:int;
    private var _tileHeight:int;
    
    private var _dropShadow:DropShadowFilter = new DropShadowFilter( 4, 75, 0, .3, 4, 4);
    
    
    public function ColorPicker( tileW:int, tileH:int, colorList:Array )
    {
        super();
        
        _tileWidth = tileW;
        _tileHeight = tileH;
        _colorList = colorList;
        
        // SelectTile
        _selectTile = new ColorTile( _tileWidth, _tileHeight, 0 );
        _selectTile.filters = [ _dropShadow ];
        addChild( _selectTile );
        _selectTile.addEventListener( MouseEvent.CLICK, onSelectStart );
        
        // TileContainer
        _tileContainer = new Sprite();
        _tileContainer.filters = [ _dropShadow ];
        addChild( _tileContainer );
        _tileContainer.visible = false;
        
        //
        addColorTiles( _colorList );
    }
    
    
    private function addColorTiles( list:Array ):void
    {
        var tile:ColorTile;
        var hCount:int;
        var vCount:int = -1;
        
        var l:int = list.length;
        for (var i:int = 0; i < l; i++) 
        {    
            tile = new ColorTile( _tileWidth, _tileHeight, colorList[ i ] );
            _tileContainer.addChild( tile );
            _tiles.push( tile );
            //
            if( i % 9 == 0 )
            {
                vCount++;
                hCount = 0;
            }
            else
            {
                hCount++;
            }
            
            tile.x = _tileWidth * hCount;
            tile.y = _tileHeight * vCount;
            tile.alpha = 0;
            
            _tileContainer.x = -_tileContainer.width * .5 + _tileWidth * .5;
            _tileContainer.y = -_tileContainer.height * .5 + _tileHeight * .5;
            
            tile.addEventListener( MouseEvent.CLICK, onColorSelect );
        }
        
    }
    
    
    // ---------- Color Select Start ----------------------------------------- /
    private function onSelectStart( e:MouseEvent ):void
    {
        var l:int = _tiles.length;
        
        if( !_tileContainer.visible )
        {
            _tileContainer.visible = true;
            
            Tween24.lag( 
                .005,
                Tween24.tween( _tiles, .5, Ease24._3_CubicOut ).alpha( 1 )
            ).play();
            
        }
        else
        {
            Tween24.serial(
                Tween24.lag( 
                    .005,
                    Tween24.tween( _tiles, .5, Ease24._3_CubicIn ).alpha( 0 )
                ),
                Tween24.prop( _tileContainer, { visible:false })
            ).play();
        }
    }
    
    
    // ---------- Color Select ----------------------------------------- /
    private function onColorSelect( e:MouseEvent ):void
    {
        var tile:ColorTile = e.currentTarget as ColorTile;
        color = tile.color;
        //
        var l:int = _tiles.length;
        
        Tween24.serial(
            Tween24.lag( 
                .005,
                Tween24.tween( _tiles, .5, Ease24._3_CubicIn ).alpha( 0 )
            ),
            Tween24.func( function():void
            {
                _tileContainer.visible = false;
                _selectTile.colorChage( color );
                dispatchEvent( new Event( Event.CHANGE ) );
            })
        ).play();
        
    }
    
    
}


//
import flash.display.Graphics;
import flash.display.Sprite;

internal class ColorTile extends Sprite
{
    
    public var color:int;
    
    public function ColorTile( w:int, h:int, col:int ):void
    {
        color = col;
        //
        var g:Graphics = graphics;
        g.beginFill( 0xFFFFFF, .5 );
        g.drawRect( 0, 0, w, h );
        g.beginFill( color );
        g.drawRect( 3, 3, w - 6, h - 6 );
        g.endFill();
        
        var s:Shape = new Shape();
        var sg:Graphics = s.graphics;
        sg.lineStyle( 1, 0xFFFFFF);
        sg.drawRect( 3, 3, w - 6, h - 6 );
        addChild( s );
    }
    
    public function colorChage( col:int ):void
    {
        var w:int = width;
        var h:int = height;
        color = col;
        
        var g:Graphics = graphics;
        g.clear();
        g.beginFill( 0xFFFFFF, .5 );
        g.drawRect( 0, 0, w, h );
        g.beginFill( color );
        g.drawRect( 3, 3, w - 6, h - 6 );
        g.endFill();
    }
}




// ---------- Flick Manager ----------------------------------------- /

import flash.display.InteractiveObject;
import flash.display.Stage;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.utils.getTimer;

internal class FlickManager extends EventDispatcher
{    
    
    public static const FLICK_LEFT:String = "flick_left";
    public static const FLICK_RIGHT:String = "flick_right";
    public static const FLICK_UP:String = "flick_up";
    public static const FLICK_DOWN:String = "flick_down";
    public static const FLICK_CANCEL:String = "flick_cancel";
    
    
    public function FlickManager()
    {    
        
    }
    
    // vec = "horizon" or "vertical"
    public function flickCheck( target:InteractiveObject, stage:Stage, vec:String = "horizon" ):void
    {    
        var startPoint:Point;
        var endPoint:Point;
        
        var startTime:int;
        var endTime:int;
        
        var time:int;
        var distX:Number = 0;
        var distY:Number = 0;
        
        var a:Number = 0;
        var v:Number = 0;
        
        const minAccel:Number = .6;
        const minDist:int = 50;
        
        target.addEventListener( MouseEvent.MOUSE_UP, onUp );
        //
        startPoint = new Point( stage.mouseX, stage.mouseY );
        startTime = getTimer();
        
        
        // Up
        function onUp( e:MouseEvent ):void
        {
            target.removeEventListener( MouseEvent.MOUSE_UP, onUp );
            //
            endPoint = new Point( stage.mouseX, stage.mouseY );
            endTime = getTimer();
            
            //
            time = endTime - startTime;
            
            distX = endPoint.x - startPoint.x;
            distY = endPoint.y - startPoint.y;
            
            //
            if( vec == "horizon" )
            {
                v = Math.abs( distX );
                a = v / time;
                
                if( v < minDist || a < minAccel ) 
                {
                    dispatchEvent( new Event( FlickManager.FLICK_CANCEL ) );
                    return;
                }
                
                if( distX > 0 )
                {
                    dispatchEvent( new Event( FlickManager.FLICK_RIGHT ) );
                }
                else
                {
                    dispatchEvent( new Event( FlickManager.FLICK_LEFT ) );
                }
                
                trace( a );
            }
            else if( vec == "vertical" )
            {
                v = Math.abs( distY );
                a = v / time;
                
                if( v < minDist || a < minAccel )
                {
                    dispatchEvent( new Event( FlickManager.FLICK_CANCEL ) );
                    return;
                }
                
                if( distY > 0 )
                {
                    dispatchEvent( new Event( FlickManager.FLICK_DOWN ) );
                }
                else
                {
                    dispatchEvent( new Event( FlickManager.FLICK_UP ) );
                }
            }
            
        }
        
    }
    
}




// ---------- Pull DownMenu ----------------------------------------- /

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextFormat;

import a24.tween.Ease24;
import a24.tween.Tween24;

internal class PullDownMenu extends Sprite
{
    public var data:*;
    
    private var _initY:Number;
    
    private var _hideY:Number;
    
    private var _tfmt:TextFormat;
    
    private var bt:MenuItem;
    
    private var menuSet:Sprite;
    
    public function PullDownMenu( w:int, h:int, labels:Array, tfmt:TextFormat )
    {
        _initY = h;
        _tfmt = tfmt;
        
        // btn
        bt = new MenuItem( w, h, 0xFFFFFF, _tfmt );
        bt.tx.text = "Menu >>";
        addChild( bt );
        
        // Menu
        menuSet = new Sprite();
        addChild( menuSet );
        
        var l:int = labels.length;
        for( var i:int = 0; i < l; i++ )
        {
            var item:MenuItem = new MenuItem( w, h, 0xFFFFCC, _tfmt );
            item.tx.text = labels[ i ];
            item.y = h * i + h + 4;
            menuSet.addChild( item );
            
            item.addEventListener( MouseEvent.CLICK, onMenuClick );
            item.addEventListener( MouseEvent.MOUSE_DOWN, onMenuTouch );
        }
        
        _hideY = -( menuSet.height + h );
        menuSet.y = _hideY;
        
        // Mask
        var mask:MenuMask = new MenuMask( menuSet.width, menuSet.height );
        mask.y = h;
        addChild( mask );
        menuSet.mask = mask;
        
        //
        bt.addEventListener( MouseEvent.CLICK, onBtnClick );
    }
    
    
    // ------------- Btn Touch ----------------------------------------- /
    private function onBtnClick( e:MouseEvent ):void
    {
        if( menuSet.y < 0 )
        {
            Tween24.serial( 
                Tween24.tween( menuSet, .3, Ease24._6_ExpoOut ).y( 0 )
            ).play();
        }
        else
        {
            Tween24.serial( 
                Tween24.tween( menuSet, .2, Ease24._6_ExpoIn ).y( _hideY )
            ).play();
        }
    }
    
    
    // ------------- Menu Touch ----------------------------------------- /
    private function onMenuTouch( e:MouseEvent ):void
    {
        var menu:MenuItem = e.currentTarget as MenuItem;
        Tween24.tween( menu, 0 ).bright( -1 ).play();
    }
    
    private function onMenuClick( e:MouseEvent ):void
    {
        var menu:MenuItem = e.currentTarget as MenuItem;
        Tween24.tween( menu, 0 ).bright( 0 ).play();
        
        Tween24.serial( 
            Tween24.tween( menuSet, .2, Ease24._6_ExpoIn ).y( _hideY ),
            Tween24.prop( bt.tx, { text: menu.tx.text })
        ).play();
        
        data = menu.tx.text;
        dispatchEvent( new Event( Event.CHANGE ));
    }
    
}



//
import flash.display.Graphics;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.text.TextField;
import flash.text.TextFormat;

internal class MenuItem extends Sprite
{
    
    public var tx:TextField = new TextField();
    
    public function MenuItem( w:Number, h:Number, color:int = 0xFFFFFF, tfmt:TextFormat = null )
    {
        var g:Graphics = this.graphics;
        g.lineStyle( 1, 0xCCCCCC );
        g.beginFill( color, 1 );
        g.drawRect( 0, 0, w, h );
        g.endFill();
        
        tx.selectable = false;
        tx.width = w;
        tx.height = h;
        tx.y = 6;
        tx.defaultTextFormat = tfmt;
        addChild( tx );
        
        this.filters = [ new DropShadowFilter( 2, 85, 0, .3, 2, 2 )];
    }
}


//
import flash.display.Shape;

internal class MenuMask extends Shape
{
    public function MenuMask( w:int, h:int )
    {
        var g:Graphics = this.graphics;
        g.beginFill( 0 );
        g.drawRect( 0, 0, w, h );
    }
}
