/**
 * Copyright Hado_A ( http://wonderfl.net/user/Hado_A )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/utyp
 */

/*
 * author : Hado_A
 * BitmapDataとかColorTransformとかの勉強をしつつ遊んでいたら、ちょっとヘンテコなものが
 * 出来たのでUPしてみます。
 * 自分では花が次々に咲いているように見えるのですが、見方によっては「ヘンな細胞が生まれてる…?!」
 * みたいに感じるかもしれませんw
 * 画面一杯に埋まるとカオスです。
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BevelFilter;
    import flash.geom.ColorTransform;
    import flash.utils.Dictionary;
    import flash.utils.Timer;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import net.hires.debug.Stats;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]

    public class GradationTest1 extends Sprite
    {
        //---------------------------------------------------------------
        // const
        //---------------------------------------------------------------
        
        private static const TIMER_DELAY                :Number     = 1000;
        private static const TIMER_REPEAT               :int        = 0;
        private static const DEFAULT_RADIUS             :Number     = 10;
        private static const PERTICLE_CHANGE_COLOR      :Number     = 0.8;
        private static const PERTICLE_DRAW_SPEED        :Number     = 1.0;
        private static const PERTICLE_SWING_WIDTH       :Number     = 0.24;
        private static const PERTICLE_MAX_SIZE          :Number     = 1.2;
        private static const PERTICLE_INC_SIZE          :Number     = 0.01;
     
        //---------------------------------------------------------------
        // var
        //---------------------------------------------------------------
        
        private var m_timer               :Timer;
        private var m_perticles           :Dictionary;
        private var m_canvas              :BitmapData;
        private var m_blurAry             :Array;
        
        //---------------------------------------------------------------
        // method
        //---------------------------------------------------------------
        
        //---------------------------------------------------------------
        /**
         * コンストラクタ。
         */
        public function GradationTest1()
        {
            m_timer = new Timer(TIMER_DELAY, TIMER_REPEAT);
            m_timer.addEventListener(TimerEvent.TIMER, onTimer);
            m_timer.start();
            
            m_blurAry = new Array();
            m_blurAry.push(new BlurFilter(7, 7, BitmapFilterQuality.LOW));
            
            m_perticles = new Dictionary(true);
            
            m_canvas = new BitmapData(465, 465, true, 0x00000000);
            
            this.addChild(new Bitmap(m_canvas));
            this.addChild(new Stats());
        }
        
        //---------------------------------------------------------------
        // event
        //---------------------------------------------------------------
        
        //---------------------------------------------------------------
        /**
         * (花を形作る)円を描くオブジェクトの毎フレームイベント。
         */
        private function runPerticle(e:Event):void
        {
            var perticle:Perticle = Perticle(e.currentTarget);
            
            // 最大サイズになったら終了
            if (perticle.size > PERTICLE_MAX_SIZE)
            {
                perticle.removeEventListener(Event.ENTER_FRAME, runPerticle);
                m_perticles[perticle] = null;
            }
            
            // 円の描画間隔
            perticle.drawSpeed += PERTICLE_DRAW_SPEED;
            perticle.swingWidth += PERTICLE_SWING_WIDTH;
            
            // スケーリング
            perticle.size += PERTICLE_INC_SIZE;
            perticle.scaleX = perticle.size;
            perticle.scaleY = perticle.size;
            
            // 円の描画位置移動
            perticle.x += (Math.cos(perticle.drawSpeed) * perticle.swingWidth);
            perticle.y += (Math.sin(perticle.drawSpeed) * perticle.swingWidth);
            
            // カラートランスフォーム変更
            perticle.color.redOffset   += perticle.changeColor.redOffset;
            perticle.color.greenOffset += perticle.changeColor.greenOffset;
            perticle.color.blueOffset  += perticle.changeColor.blueOffset;
            perticle.transform.colorTransform = perticle.color; // セット
            
            // 描画
            m_canvas.draw(perticle, perticle.transform.matrix, perticle.transform.colorTransform, BlendMode.HARDLIGHT);
        }
        
        //---------------------------------------------------------------
        /**
         * 一定間隔で円（花を形づくるもの）を新規作成。
         */
        private function onTimer(e:TimerEvent):void
        {
            var perticle:Perticle = new Perticle();
            perticle.x = Math.random() * stage.stageWidth;
            perticle.y = Math.random() * stage.stageHeight;
            perticle.filters = m_blurAry;
            
            var radius:Number = DEFAULT_RADIUS;
            
            // 色初期化
            perticle.color = initReflectColor(); // 描画色
            perticle.changeColor  = initChangeColor(perticle.color); // 描画色を変化させる色
            
            // 円を描画
            var g:Graphics = perticle.graphics;
            g.beginFill(0x000000);
            g.drawCircle(0, 0, radius);
            g.endFill();
            
            // 毎フレームイベントを設定
            perticle.addEventListener(Event.ENTER_FRAME, runPerticle);
            m_perticles[perticle] = perticle;
        }
        
        //---------------------------------------------------------------
        /**
         * 描画色を初期化。
         */
        private function initReflectColor():ColorTransform
        {
            var color:ColorTransform = new ColorTransform();
            
            color.redOffset   = Math.random() * 255;
            color.greenOffset = Math.random() * 255;
            color.blueOffset  = Math.random() * 255;
            
            return color;
        }
        
        //---------------------------------------------------------------
        /**
         * 描画色を変化させる色を初期化。
         */
        private function initChangeColor(color:ColorTransform):ColorTransform
        {
            var cc:ColorTransform = new ColorTransform();
            
            // 赤変化方向・量
            if (color.redOffset < 127.5) { cc.redOffset = PERTICLE_CHANGE_COLOR; }
            else { cc.redOffset = -PERTICLE_CHANGE_COLOR; }
            
            // 緑変化方向・量
            if (color.greenOffset < 127.5) { cc.greenOffset = PERTICLE_CHANGE_COLOR; }
            else { cc.greenOffset = -PERTICLE_CHANGE_COLOR; }
            
            // 青変化方向・量
            if (color.blueOffset < 127.5) { cc.blueOffset = PERTICLE_CHANGE_COLOR; }
            else { cc.blueOffset = -PERTICLE_CHANGE_COLOR; }
            
            return cc;
        }
        
    }
}

//---------------------------------------------------------------
// Perticleクラス
//---------------------------------------------------------------
import flash.display.Sprite
import flash.geom.ColorTransform;

class Perticle extends Sprite
{
    public var drawSpeed:Number;
    public var swingWidth:Number;
    public var size:Number;
    public var color:ColorTransform;
    public var changeColor:ColorTransform;
    
    public function Perticle()
    {
        drawSpeed = 0;
        swingWidth = 0;
        size = 0;
        color = new ColorTransform();
        changeColor = new ColorTransform();
    }
}

