/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/utgQ
 */

package {
  import flash.display.Sprite;
  import flash.events.ActivityEvent;
  import flash.events.SampleDataEvent;
  import flash.media.Microphone;
  import flash.utils.ByteArray;
  public class ch33ex4 extends Sprite {
    protected var mic:Microphone;
    public function ch33ex4() {
      mic = Microphone.getMicrophone();
      mic.rate = 22;
      mic.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampleData);
    }
    protected function onSampleData(event:SampleDataEvent):void {
      var waveform:ByteArray = event.data;
      var SAMPLES:Number = waveform.length / 4; //4 bytes per float
      var W:Number = stage.stageWidth;
      var H:Number = stage.stageHeight;
      var xstep:Number = W/SAMPLES;
      
      graphics.clear();
      graphics.lineStyle(0, 0);
      graphics.moveTo(0, H/2);
      for (var i:int = 0, x:Number = 0; i < SAMPLES; i++, x+=xstep) {
        var amplitude:Number = waveform.readFloat();
        var y:Number = H/2 + (amplitude * H/2); //amplitude is from -1 to 1
        graphics.lineTo(x, y);
      }
    }
  }
}