/**
 * Copyright Wataru.Miyazaki ( http://wonderfl.net/user/Wataru.Miyazaki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/utNg
 */

// forked from Hiroki.Nigorinuma's forked from: forked from: Label機能
// forked from Wataru.Miyazaki's forked from: Label機能
// forked from Hiroki.Nigorinuma's Label機能
// forked from oshige's TextField_INPUT
package {
    import flash.ui.Mouse;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.events.KeyboardEvent;
    import com.actionscriptbible.Example;
    public class MyTextField extends Example {
        
        private var fld:TextField;
        private var rect:Sprite;
        private var button:Sprite;
        private var rotateButton:Sprite;
        private var mouseMove:Boolean;
        private var sizing:Boolean;
        private var baseRect:Rectangle;
        
        public function MyTextField(){
              
            baseRect = new Rectangle(100,100,300,24);  
              
            // フラグ
            mouseMove = false;
            sizing    = false;
            
            // テキストの書式
            var tf:TextFormat = new TextFormat();
            tf.font = "_typewriter";
            tf.size = 18;
            
            // ベースのオブジェクト
            rect = new Sprite();
            //rect.graphics.beginFill(0xCCCCCC);
            rect.graphics.drawRect(baseRect.x,baseRect.y,baseRect.width,baseRect.height);
            rect.buttonMode = true;
            addChild(rect);
            
            //テキスト入力フィールドの作成
            fld = new TextField();
            fld.type = TextFieldType.INPUT;
            fld.defaultTextFormat = tf;
            fld.x = baseRect.x;
            fld.y = baseRect.y;
            fld.width = baseRect.width;
            fld.height = baseRect.height;
            fld.border = true;
            rect.addChild(fld);
            
            // 拡大縮小ボタン
            button = new Button();
            button.x = baseRect.x+baseRect.width;
            button.y = baseRect.y+baseRect.height;
            rect.addChild(button);
            
            // 回転ボタン
            rotateButton = new Button();
            rotateButton.x = baseRect.x+baseRect.width;
            rotateButton.y = baseRect.y;
            //rect.addChild(rotateButton);
            
            // イベント実装
            fld.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
            fld.addEventListener(MouseEvent.CLICK, onClick);
            button.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownButton);
            button.addEventListener(MouseEvent.MOUSE_UP, onMouseUpButton);
            rotateButton.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownRotate);
            rotateButton.addEventListener(MouseEvent.MOUSE_UP, onMouseUpRotate);
            rect.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
            rect.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
            
        }
       private function keyDownHandler(event:KeyboardEvent):void{
            trace("keyDownHandler");
            if (event.charCode == 13) {
                fld.type = TextFieldType.DYNAMIC;
                fld.border = false;
                rect.removeEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
                rect.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
                rect.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
                button.visible = false;
            }
        }
        private function onClick(event:MouseEvent):void{
            trace("onClick");
            fld.borderColor = 0xFF0000;
            fld.type = TextFieldType.INPUT;
            fld.border = true;
            rect.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
            button.visible = true;
        }
        private function onMouseOver(e:MouseEvent):void{
            //trace("onMouseOver");
            fld.borderColor = 0xFF0000;
        }
        private function onMouseOut(e:MouseEvent):void{
            trace("onMouseOut",rect.x);
            fld.borderColor = 0x000000;
        }
       private function onMouseDown(e:MouseEvent):void{
            trace("onMouseDown");
            if (!sizing) {
                e.currentTarget.startDrag();
            }
        }
        private function onMouseUp(e:MouseEvent):void{
            //trace("onMouseUp");
            trace(e.currentTarget.x,e.currentTarget.y);
            if (!sizing) {
                e.currentTarget.stopDrag();
            }
        }
        private function onMouseDownButton(e:MouseEvent):void{
            trace("onMouseDownButton");
            mouseMove = true;
            sizing = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            e.currentTarget.startDrag();
        }
        private function onMouseUpButton(e:MouseEvent):void{
            trace("onMouseUpButton");
            mouseMove = false;
            sizing = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            e.currentTarget.stopDrag();
        }
        private function onMouseMove(e:MouseEvent):void{
            //trace("onMouseMove",e.stageX,e.currentTarget.x,fld.x);
           
            //var parent:Sprite = e.currentTarget;
            fld.width = e.stageX-fld.x-rect.x;     
            fld.height = e.stageY-fld.y-rect.y;
            
        }
        private function onMouseDownRotate(e:MouseEvent):void{
            trace("onMouseDownButton");
            mouseMove = true;
            sizing = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveRotate);
            e.currentTarget.startDrag();
        }
        private function onMouseUpRotate(e:MouseEvent):void{
            trace("onMouseUpButton");
            mouseMove = false;
            sizing = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveRotate);
            e.currentTarget.stopDrag();
        }
        
        private function onMouseMoveRotate(e:MouseEvent):void{
            //trace("onMouseMove",e.stageX,e.currentTarget.x,fld.x);
           
            //var parent:Sprite = e.currentTarget;
            // rect.rotation += 0.1;
            
        }
    }
}

// 拡大縮小ボタン
import flash.display.Sprite;
import com.actionscriptbible.Example;

class Button extends Example{
    public function Button(){
        graphics.lineStyle(1, 0x999999);
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0, 0, 10);
    }
}


