/**
 * Copyright t4423 ( http://wonderfl.net/user/t4423 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/utK7
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextFormat;
    import flash.text.TextField;

    import org.si.sion.*;
    
    [SWF(backgroundColor="#000000", frameRate=30)]
    
    public class CountDown extends Sprite {
        private const STW:uint = stage.stageWidth;
        private const STH:uint = stage.stageHeight;
        private var tf:TextField;
        private var fmt:TextFormat;
        private var remain:Remaining;
        
        private var driver:SiONDriver;
        private var sinWave:SiONVoice;
        
        public static var checkSec:String;
        
        public function CountDown() {
            
            tf = new TextField();
            tf.x = 0;
            tf.width = STW;
            tf.y = (STH - tf.height)/2;
            tf.selectable = false;
            addChild(tf);
            
            fmt = new TextFormat()
            fmt.size = 48;
            fmt.align = "center";
            fmt.color = 0xffffff;
            fmt.font = "Centry";
           
           
               var tYear:uint = 2011;
               var tMonth:uint = 8;
               var tDay:uint = 1;
               var tHours:uint = 19;

            remain = new Remaining(new Date(tYear,tMonth-1,tDay,tHours));
            
            addEventListener(Event.ENTER_FRAME ,  onEnterFrame);
            
            initSiON();
        }
        
        
        private function onEnterFrame(evtObj:Event):void{
            var milisec:String = String(remain.getRemainTime());
            milisec = milisec.substr(milisec.length-3,3);
            var sec:String = add0(remain.getRemainSeconds() , 2);
            var min:String = add0(remain.getRemainMinutes() , 2);
            var hour:String = add0(remain.getRemainHours() , 2);
            var day:String = String(remain.getRemainDays());
            if(!checkSec){
                checkSec = sec;
            }
            if(checkSec != sec){
               driver.noteOn(110, sinWave, 0.5, 0);
               checkSec = sec;
            }

            var str:String = day+" days  " +  hour + ":" + min + ":" + sec;
            tf.text = str;
            tf.setTextFormat(fmt);
            
            
         }
                
        private function initSiON():void
        {
            driver = new SiONDriver();
            driver.play();
            sinWave = new SiONVoice(5,1);
        }
 
        
        private function add0(num:uint , keta:uint):String{
            var rStr:String=String(num);
            var strCnt:uint = keta - String(num).length;
            if(strCnt > 0){
                for(var i:uint=0;i<strCnt;i++){
                    rStr = "0"+rStr;
                }
            }
            return rStr;
        }
    }
}
class Remaining{    
    private var tDate:Date;
    private var target_sec:Number;

    public function Remaining(targetDate:Date){
        tDate = targetDate;
        target_sec = tDate.getTime();
    }
    public function getRemainTime():Number{
        var now_date:Date = new Date();
        var now_sec:Number = now_date.getTime();
        var pastMillisec:Number = target_sec - now_sec;
        return pastMillisec;
    }
    public function getRemainSeconds():Number{
        var now_date:Date = new Date();
        var now_sec:Number = now_date.getTime();
        var pastMillisec:Number = target_sec - now_sec;
        return Math.floor(pastMillisec/1000)%60;
    }
    public function getRemainMinutes():Number{
        var now_date:Date = new Date();
        var now_sec:Number = now_date.getTime();
        var pastMillisec:Number = target_sec - now_sec;
        return Math.floor(pastMillisec/1000/60)%60;
    }
    public function getRemainHours():Number{
        var now_date:Date = new Date();
        var now_sec:Number = now_date.getTime();
        var pastMillisec:Number = target_sec - now_sec;
        return Math.floor(pastMillisec/1000/60/60)%24;
    }
    public function getRemainDays():Number{
        var now_date:Date = new Date();
        var now_sec:Number = now_date.getTime();
        var pastMillisec:Number = target_sec - now_sec;
        return Math.floor(pastMillisec/1000/60/60/24);
    }
}