/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/urx3
 */

package {
    import flash.display.CapsStyle;
    import flash.display.LineScaleMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Rectangle;

    [SWF(width = '465', height = '465')]
    public class Noodle3 extends Sprite {
        private const NUM_BITS : uint = 1 << 10;
        private var node0 : Node;
        private var headX : Number;
        private var headY : Number;
        private var twirl : Number = 0.0;

        public function Noodle3() {
            var sw : int = stage.stageWidth;
            var sh : int = stage.stageHeight;

            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.fullScreenSourceRect = new Rectangle(0, 0, sw, sh);
            stage.quality = StageQuality.MEDIUM;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            /* */

            var node : Node = node0 = new Node();
            var i : uint = NUM_BITS;
            while (i-- != 0) {
                twirl += (Math.PI * 2) / NUM_BITS;
                node.x = sw * Math.cos(twirl);
                node.y = sh * Math.sin(twirl);
                node.next = new Node();
                node.next.prev = node;
                node = node.next;
            }

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            var thk : Number = 64;
            
            var c : uint = 0x404040;
            var mood : int = 0x040702;

            twirl += Math.PI / 3;
            headX = stage.mouseX + 32 * Math.cos(twirl);
            headY = stage.mouseY + 32 * Math.sin(twirl);

            /* */

            var pnode : Node = node0;
            var node : Node = node0.next;

            node.a = Math.PI + Math.atan2(headY - node.y, headX - node.x);
            node.x += (headX - node.x) * 0.11;
            node.y += (headY - node.y) * 0.11;

            /* */

            graphics.clear();
            graphics.beginFill(c);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();

            node = node.next;
            graphics.moveTo(node.x, node.y);

            while (node != null) {
                pnode = node.prev;

                var tx : Number = pnode.x - node.x;
                var ty : Number = pnode.y - node.y;
                var td : Number = (ty < 0) ? -ty : ty;

                node.a = 3.141592653589793 + ((tx >= 0.0) ? (ty < 0.0) ? -(0.7853981633974483 - 0.7853981633974483 * ((tx - td) / (tx + td))) : (0.7853981633974483 - 0.7853981633974483 * ((tx - td) / (tx + td))) : (ty < 0.0) ? -((3.0 * 0.7853981633974483) - 0.7853981633974483 * ((tx + td) / (td - tx))) : ((3.0 * 0.7853981633974483) - 0.7853981633974483 * ((tx + td) / (td - tx))));
                node.x = pnode.x + 12 * Math.cos(pnode.a);
                node.y = pnode.y + 12 * Math.sin(pnode.a);

                c += mood;
                if ((c < 0x101010) || (c > 0xF0F0F0)) mood = (mood ^ -1) + 1;
                
                thk *= 0.998;

                graphics.lineStyle(((thk < 2.0) ? 2.0 : thk), c, 1.0, false, LineScaleMode.NONE, CapsStyle.ROUND);
                graphics.lineTo(node.x, node.y);

                node = node.next;
            }
        }
    }
}
internal class Node {
    /* */
    public var x : Number;
    public var y : Number;
    public var a : Number;
    /* */
    public var next : Node;
    public var prev : Node;

    function Node() {
    }
}