/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uqS7
 */

package
{
	import flash.display.Sprite;
	import flash.filters.DropShadowFilter;
	
	import org.as3lib.kitchensync.*;
	import org.as3lib.kitchensync.action.*;
	import org.as3lib.kitchensync.action.group.*;
	import org.as3lib.kitchensync.action.tween.*;
	import org.as3lib.kitchensync.easing.Bounce;
	import org.as3lib.kitchensync.easing.Cubic;
	import org.as3lib.kitchensync.utils.FrameRateView;

	[SWF(width='500', height='500', backgroundColor='#FFFFFF', frameRate='60')]
	public class FilterTest extends Sprite {
		private var bg:Sprite;
		private var sprite:Sprite;
	
		public function FilterTest() {
			KitchenSync.initialize(this, "2.1");

			// add a framerate display
			addChild(new FrameRateView());
			
			sprite = new Sprite();
			sprite.graphics.beginFill(0);
			sprite.graphics.drawCircle(0,0,25);
			sprite.x = 300;
			sprite.y = 300;
			addChild(sprite);
		
			// Create an initial starting point for the shadow filter.
			var defaultShadow:DropShadowFilter = new DropShadowFilter(0, 45, 0, .25, 0, 0);
			sprite.filters = [defaultShadow];
		
			var tweenPosition:KSTween = TweenFactory.newTween(sprite, ["x", "y"], AUTO_TWEEN_VALUE, 100, "6s", 0, Bounce.easeIn);
			var tweenScale:KSTween = TweenFactory.newTween(sprite, ["scaleX", "scaleY"], .5, 3.5, "6s", 0, Bounce.easeIn);
			var tweenBlur:KSTween = TweenFactory.newTweenWithTargets(new SimpleBlurTweenTarget(sprite, 20, 0), "6s", 0, Bounce.easeIn);
			 
			var tweenShadow:KSTween = TweenFactory.newTweenWithTargets(new FilterTargetProperty(sprite, DropShadowFilter, "distance", 0, 400), "6s", 0, Bounce.easeIn); 
		 	tweenShadow.addTweenTarget(new FilterTargetProperty(sprite, DropShadowFilter, "blurX", 0, 50)); 
			tweenShadow.addTweenTarget(new FilterTargetProperty(sprite, DropShadowFilter, "blurY", 0, 50)); 
			
			new KSParallelGroup(tweenPosition, tweenScale, tweenBlur, tweenShadow).start();
		}	
	}
}