/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uq4Y
 */

// forked from ProjectNya's ボタンonボタン
////////////////////////////////////////////////////////////////////////////////
// ボタンonボタン
//
// [AS3.0] ボタンonボタン
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1437
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
     import flash.events.MouseEvent;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var controller:Sprite;
        private static var max:uint = 4;
        private var menus:Array;
        private var label:Label;
        private var itween:ITween

        public function Main() {
            //Wonderfl.capture_delay(1);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {

            controller = new Sprite();
            addChild(controller);
            controller.x = 232;
            controller.y = 212;
            controller.graphics.beginFill(0xFFFFFF, 0);
            controller.graphics.drawRect(-180, -20, 360, 40);
            controller.graphics.endFill();
            controller.buttonMode = false;
            controller.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            controller.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            //
            menus = new Array();
            var colors:Array = new Array();
            colors.push({color: 0x0066CC, colors: [0x00FFFF, 0x3333FF]});
            colors.push({color: 0x669900, colors: [0x99FF00, 0x33CC00]});
            colors.push({color: 0xFF6600, colors: [0xFFFF00, 0xFFCC00]});
            colors.push({color: 0xFF3399, colors: [0xFFCCFF, 0xFF66CC]});
            for (var n:uint = 0; n < max; n++) {
                var menu:ActionMenu = new ActionMenu();
                menu.x = - 135 + 90*n;
                menu.y = 0;
                controller.addChild(menu);
                menu.init({id: n, label: "menu" + (n + 1), width: 80});
                menu.colorize(colors[n].color, colors[n].colors);
                menu.addEventListener(MouseEvent.CLICK, select, false, 0, true);
                menus.push(menu);
            }
            //
            label = new Label(200, 24, 20, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 252;
            label.textColor = 0x333333;
        }
        private function rollOver(evt:MouseEvent):void {
            clear();
            enable(true);
            itween = BetweenAS3.to(controller, {alpha: 1}, 0.6, Linear.easeNone);
            itween.play();
        }
        private function rollOut(evt:MouseEvent):void {
            clear();
            itween = BetweenAS3.to(controller, {alpha: 0.3}, 0.4, Linear.easeNone);
            itween.addEventListener(TweenEvent.COMPLETE, faded, false, 0, true);
            itween.play();
        }
        private function faded(evt:TweenEvent):void {
            itween.removeEventListener(TweenEvent.COMPLETE, faded);
            //enable(false);
        }
        private function clear():void {
            if (itween) {
                itween.stop();
                itween = null;
            }
        }
        private function enable(useful:Boolean):void {
            for (var n:uint = 0; n < max; n++) {
                var menu:ActionMenu = menus[n];
                menu.enabled = useful;
            }
        }
        private function select(evt:MouseEvent):void {
            label.text = "content" + (evt.target.id + 1);
            for (var n:uint = 0; n < menus.length; n++) {
                var menu:ActionMenu = menus[n];
                if (n == evt.target.id) {
                    menu.selected = true;
                } else {
                    menu.selected = false;
                }
            }
        }
        
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// ActionMenuクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class ActionMenu extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var base:Shape;
    private var front:Shape;
    private var light:Shape;
    private var reflection:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 32;
    private static var corner:uint = 6;
    private static var tHeight:uint = 17;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var baseColor:uint = 0x0066CC;
    private var lightColor:uint = 0x00FFFF;
    private var overColor:uint = 0x3333FF;
    private static var tColor:uint = 0xFFFFFF;
    private var defaultColorTrans:ColorTransform;
    private static var disableColor:uint = 0xCCCCCC;
    private static var disableColorTrans:ColorTransform;
    private var mode:int;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function ActionMenu() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        draw();
    }
    public function colorize(color:uint, list:Array):void {
        var bTrans:ColorTransform = new ColorTransform();
        bTrans.color = color;
        defaultColorTrans = bTrans;
        base.transform.colorTransform = bTrans;
        front.transform.colorTransform = bTrans;
        lightColor = list[0];
        overColor = list[0];
        createLight(light, _width-2, _height-2, corner);
    }
    private function draw():void {
        defaultColorTrans = new ColorTransform();
        disableColorTrans = new ColorTransform();
        disableColorTrans.color = disableColor;
        shade = new Shape();
        base = new Shape();
        front = new Shape();
        light = new Shape();
        reflection = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(base);
        addChild(front);
        addChild(light);
        addChild(reflection);
        addChild(txt);
        createBase(shade, _width, _height, corner, bColor);
        shade.filters = [new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false)];
        createBase(base, _width-2, _height-2, corner, baseColor);
        createFront(front, _width, _height, corner);
        createLight(light, _width-2, _height-2, corner);
        createReflection(reflection, _width-2, _height-2, corner);
        txt.x = -_width/2;
        txt.y = -tHeight + _height/4;
        txt.width = _width;
        txt.height = tHeight;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        txt.text = label;
        txt.filters = [new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 2, 3, false, false)];
        light.alpha = 0;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        mode = 1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function rollOut(evt:MouseEvent = null):void {
        mode = -1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function action(evt:Event):void {
        light.alpha += 0.1*mode;
        if (light.alpha < 0) {
            light.alpha = 0;
            removeEventListener(Event.ENTER_FRAME, action);
        }
        if (light.alpha > 1) {
            light.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, action);
        }
    }
    private function _up():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
        light.alpha = 1;
    }
    private function _disable():void {
        base.transform.colorTransform = disableColorTrans;
        front.transform.colorTransform = disableColorTrans;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            _down();
        } else {
            _up();
            rollOut();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        } else {
            _disable();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createFront(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = [baseColor, baseColor];
        var alphas:Array = [0, 0.5];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w/2, -h/2);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createLight(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.clear();
        var colors:Array = [lightColor, overColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [40, 160];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*2, h*3, 0, -w, -h*0.9);
        target.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createReflection(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor, 0.3);
        target.graphics.drawEllipse(-w*1.125, -h*4.375, w*2.25, h*4.375);
        target.graphics.endFill();
        var _mask:Shape = new Shape();
        _mask.graphics.beginFill(sColor);
        _mask.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        _mask.graphics.endFill();
        addChild(_mask);
        target.mask = _mask;
    }

}
