/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uq3O
 */

// http://www.ObjectClub.jp/ml-arch/magazine/327.html

package {
    import flash.display.Bitmap;
	import flash.events.Event;
	import org.papervision3d.core.effects.view.ReflectionView;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.BitmapFileMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Cube;
	
    public class DoubutsuShogi extends ReflectionView {
        public function DoubutsuShogi() {
            viewport.interactive = true;
			var komaData:Array
			var koma:Koma
			
            
			var komas:Array = [[Hiyoko, 2, 3], [Zou, 1, 4], [Tora, 2, 4], [Kirin, 3, 4]]
			for each(komaData in komas) {
				koma = new komaData[0]();
				koma.move(komaData[1], komaData[2])
				scene.addChild(koma.cube);
			}
			
			for each(komaData in komas) {
				koma = new komaData[0]();
				koma.move(4 - komaData[1], 5 - komaData[2])
				koma.turn()
				scene.addChild(koma.cube);
			}

			var boardTopMaterial:BitmapFileMaterial = new BitmapFileMaterial(Koma.IMAGE_URL + Koma.BOARD_TOP_URL);
			var boardMaterial:BitmapFileMaterial = new BitmapFileMaterial(Koma.IMAGE_URL + Koma.BOARD_URL);

			var mlist:MaterialsList = new MaterialsList( { all:boardMaterial, top:boardTopMaterial } );
			var cube:Cube = new Cube(mlist, Koma.UNIT_SIZE / 2 * 3 + 10, Koma.UNIT_SIZE / 2 * 4 + 10, 10, 3, 2, 4);
			cube.y = 5
			scene.addChild(cube);
			
            addEventListener(Event.ENTER_FRAME, update);
        }

        public function update(e:Event):void {
			var c:Number = ((mouseX / stage.width) - 0.5) * 2 * Math.PI / 2;
			var d:Number = (1 - (mouseY / stage.height)) * Math.PI / 2;
			var x:Number = Math.sin(c) * Math.cos(d) * 200;
			var z:Number = Math.cos(c) * Math.cos(d) * 200;
			var y:Number = Math.sin(d) * 200;
			camera.x = x;
			camera.y = y;
			camera.z = z;

            singleRender()
        }
    }
}

import flash.system.Security;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Rectangle;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.materials.BitmapFileMaterial;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.materials.special.CompositeMaterial;
import org.papervision3d.materials.utils.MaterialsList;
import org.papervision3d.objects.primitives.Cube;
import caurina.transitions.Tweener;
import org.papervision3d.events.InteractiveScene3DEvent;
import org.papervision3d.objects.DisplayObject3D;

class Koma {
	protected var _cube:Cube;

	public static const UNIT_SIZE:Number = 100;
	public static const KOMA_SIZE:Number = UNIT_SIZE * 0.8;

    Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
	public static const IMAGE_URL:String = "http://assets.wonderfl.net/images/related_images/";

	public static const HIYOKO_URL:String    = "7/73/7362/7362fe45e00bbd8b73cc67acad5ab2af451b52e2"
    public static const KIRIN_URL:String     = "8/8a/8a66/8a66a59b06d675822b75b08ec8a8fcfa392b236a"
    public static const ZOU_URL:String       = "e/e6/e6e6/e6e6a6096b7ccd7e4dfedb5e508fa10dd0b9a9fa"
    public static const TORA_URL:String      = "d/d5/d5d7/d5d7101a782a3f9b48a1fa722f5b5547edfb7a79"
    public static const NIWATORI_URL:String  = "4/41/41ad/41ad48895eacaf9249f91dd8ed7f2bd0f76a1562"
    public static const BOARD_URL:String     = "d/d3/d308/d308eea2f48ce3922aace07079a2b1c443897a3b"
    public static const BOARD_TOP_URL:String = "8/89/89e5/89e5f619ecaece6a7c294fe9d85a6af305f2742c"
    public static const KI_URL:String        = "b/b8/b850/b850141ea815c9ec0c5225deb8e0d12d3805c72cm"
	
	public function Koma(filenameTop:String, directionTop:Array, filenameBottom:String = null, directionBottom:Array = null) {
		this._cube = createCube(filenameTop, directionTop, filenameBottom, directionBottom)
	}

	public function move(x:Number, y:Number):void {
		_cube.x = (x - 1) * UNIT_SIZE / 2 - UNIT_SIZE / 2
		_cube.y = UNIT_SIZE / 4
		_cube.z = - (y - 1.5) * UNIT_SIZE / 2 + UNIT_SIZE / 2
	}

	public function turn():void {
		_cube.rotationY += 180
	}

	public function get cube():Cube {
		return this._cube
	}

	private function createCube(filenameTop:String, directionTop:Array, filenameBottom:String, directionBottom:Array):Cube {
		var materialsList:MaterialsList = new MaterialsList( { all:materialKi} );

		var materialKi:BitmapFileMaterial = new BitmapFileMaterial(Koma.IMAGE_URL + Koma.KI_URL);
		materialKi.interactive = true
		materialsList.addMaterial(materialKi, "all")

		materialsList.addMaterial(createCompositeMaterial(filenameTop, directionTop), "top")
		if (filenameBottom != null) {
			materialsList.addMaterial(createCompositeMaterial(filenameBottom, directionBottom), "bottom")
		}

		return new Cube(materialsList, KOMA_SIZE / 2, KOMA_SIZE / 2, KOMA_SIZE / 4, 2, 2, 2);
	}

	private function createCompositeMaterial(filename:String, direction:Array):CompositeMaterial {
		var material:CompositeMaterial = new CompositeMaterial();
		material.addMaterial(new BitmapFileMaterial(Koma.IMAGE_URL + filename));
		material.addMaterial(createDirectionMarkMaterial(direction));
		material.interactive = true;
		return material;
	}

	private function createDirectionMarkMaterial(direction:Array):BitmapMaterial {
		var bd:BitmapData = new BitmapData(100, 100, true, 0x00000000);
		for (var j:Number = 0; j < 3; j++) { 
			for (var i:Number = 0; i < 3; i++) { 
				if (direction[j][i] == 1) {
					bd.fillRect(new Rectangle(5 + i*40, 5 + j*40, 10, 10), 0xFFFF0000);
				}
			} 
		}
		return new BitmapMaterial(bd);
	}
}

class Hiyoko extends Koma {
	public function Hiyoko() {
		super(Koma.HIYOKO_URL, [[0, 1, 0], [0, 0, 0], [0, 0, 0]],
			Koma.NIWATORI_URL, [[1,1,1],[1,0,1],[0,1,0]])

		_cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, clicked);
	}

	public function clicked(event:InteractiveScene3DEvent):void {
		var cube:DisplayObject3D = event.displayObject3D;
		if (!Tweener.isTweening(cube)) {
			Tweener.addTween(cube, {
				rotationZ:cube.rotationZ+180, time:1, transition: 'easeInOutCubic'
			})
		}
	}
}

class Kirin extends Koma {
	public function Kirin() {
		super(Koma.KIRIN_URL, [[0,1,0],[1,0,1],[0,1,0]])
	}
}

class Tora extends Koma {
	public function Tora() {
		super(Koma.TORA_URL, [[1,1,1],[1,0,1],[1,1,1]])
	}
}

class Zou extends Koma {
	public function Zou() {
		super(Koma.ZOU_URL, [[1,0,1],[0,0,0],[1,0,1]])
	}
}
