/**
 * Copyright mirkofresa ( http://wonderfl.net/user/mirkofresa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/upv7
 */

// forked from narutohyper's Alternativa3D Tips 平面プリミティブの頂点にアクセスして、変形する2
package {
	import alternativ5.engine3d.materials.TextureMaterial;
	import alternativ5.engine3d.primitives.Plane;
	import alternativ5.engine3d.primitives.Cone;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.engine3d.core.Mesh;
	import alternativ5.engine3d.events.MouseEvent3D
	import alternativ5.types.Point3D;
	import alternativ5.types.Texture;
	import alternativ5.utils.*

	import flash.display.Sprite;
	import flash.display.BlendMode;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.GradientType;

	import flash.geom.Matrix;
	

	[SWF(width = 588, height = 100, frameRate = 24,backgroundColor=0xFFFFFF)]
	/**
	 * Alternativa3D Tips 平面(Plane)プリミティブの頂点(Vertex)にアクセスして、変形する
	 * 
	 * 頂点へのアクセス方法がわかれば、好きに形を変更できます。
	 * 今回は、波打たせてみました。
	 * 
	 * @narutohyper
	*/

		/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	public class SimpleDemo extends Sprite {

		
		public function SimpleDemo():void {
			// テンプレートを作成します
			var template:BasicTemplate = new BasicTemplate();
			addChild(template);
			template.camera.z = -500;


			// Planeプリミティブを作成します
			var plane:Plane= new Plane(400, 600, 1,36,true,true,true)

			var i:uint
			var id0:String
			var id1:String
			var temp0:Point3D;
			var temp1:Point3D;
			var vy:Number
			var vz:Number

			//グラデーションのマテリアルを作成する
				var bmd1:BitmapData=new BitmapData(100,100,true,0xFF000000)
				var bmd2:BitmapData=new BitmapData(100,100,true,0xFF000000)
				var tempSprite:Sprite=new Sprite();
				var colors:Array=new Array(0x732222,0xFFFFFF,0x732222)
				var alphas:Array=new Array(1,1,1)
				var ratios:Array=new Array(0,127,255)
				var matrix:Matrix=new Matrix()
				matrix.createGradientBox(100,100,Math.PI/2,0,0)
				tempSprite.graphics.beginGradientFill(GradientType.LINEAR,colors, alphas, ratios, matrix)
				tempSprite.graphics.drawRect(0,0,100,100)
				bmd1.draw(tempSprite)

				colors=new Array(0xFFFFFF,0x732222,0xFFFFFF)
				tempSprite.graphics.beginGradientFill(GradientType.LINEAR,colors, alphas, ratios, matrix)
				tempSprite.graphics.drawRect(0,0,100,100)
				bmd2.draw(tempSprite)

				var ltm1:TextureMaterial=new TextureMaterial(new Texture(bmd1))
				var ltm2:TextureMaterial=new TextureMaterial(new Texture(bmd2))

				plane.setMaterialToSurface(ltm1,'front');
				plane.setMaterialToSurface(ltm2,'back');

				//明るい面が上に行くように回転
				plane.rotationX = MathUtils.toRadian(90)

				// 3Dシーンのルートに追加します
				template.scene.root.addChild(plane);


			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。

			var angle:Number=0

			template.onPreRender = function():void {
				angle++
				for(i=0;i<=36;i++) {
					vy=Math.sin(MathUtils.toRadian((i+angle)*10))*50
					vz=Math.sin(MathUtils.toRadian((i+angle)*10))*50
					//↓旗のなびきっぽくなるけど、線がちらついて汚いｗ
					//vz=Math.sin(MathUtils.toRadian((i+angle+10)*10))*50

					id0=0+'_'+i
					id1=1+'_'+i
					temp0=plane.getVertexById(id0).coords
					temp1=plane.getVertexById(id1).coords

					//temp0.z=vz
					temp0.z=vy
					//temp1.z=vz
					temp1.z=vz

					plane.getVertexById(id0).coords=temp0
					plane.getVertexById(id1).coords=temp1
				}



				// 立方体を回転させます (角度はラジアン)
				plane.rotationY += 1 * Math.PI / 180;
			
				// マウスがステージの高さ何%の位置にあるか算出
				var rateY:Number = mouseY / stage.stageHeight;
				
				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				
				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());
			}
		}


	}
}






import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;


/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}

	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}
