/**
 * Copyright k-a-z-a-m ( http://wonderfl.net/user/k-a-z-a-m )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uox2
 */

// forked from testest's forked from: Emotion Fractal DNA synthesis
// forked from testest's Emotion Fractal DNA synthesis
// forked from 5ivestar's Emotion Fractal in AS3
// Emotion Fractal in AS3
// refer to http://levitated.net/daily/levEmotionFractal.html

///only replacing words to the elements of DNA as my practice
package {
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.TextShortcuts;

	[SWF(backgroundColor="#ffffff", frameRate=30)]   

	public class EmotionFractal extends Sprite {

		private var queue:Array; 
		private var words:Array;

		[Embed(systemFont="sansserif", fontName="font", unicodeRange="U+0041-U+005A", mimeType="application/x-font")]
		private var font:Class; 
  
		public function EmotionFractal() {
			stage.align = "TL";
			stage.scaleMode = "noScale";

			words = 'awgwtwc'.split('w'); 

			TextShortcuts.init();
			init(null);
			addEventListener(MouseEvent.MOUSE_DOWN, init);
		}

		public function init(e:MouseEvent):void {
			Tweener.removeAllTweens();
			while (numChildren) removeChildAt(0);
			queue = [new Rectangle(0, 0, stage.stageWidth, stage.stageHeight)];
			addEventListener(Event.ENTER_FRAME, fill);
		}

		public function fill(e:Event):void {
			var i:int = 0;
			while (queue.length > 0 && i < 3) {
				var rect:Rectangle = queue.pop();
				if (rect.width > 2 && rect.height > 2) {
					fillRegion(rect);
					i++;
				}
			}
			if (!queue.length) removeEventListener(Event.ENTER_FRAME, fill);
		}

		public function fillRegion(region:Rectangle):void {
			var tf:TextField = new TextField();
			var fmt:TextFormat = new TextFormat();
			fmt.font = 'font'; 
			fmt.size = 10; 
			fmt.letterSpacing = -0.4; 
			fmt.rightMargin = 0.4;
			tf.defaultTextFormat = fmt;
			tf.text = choice(words).toUpperCase();
			tf.autoSize = "left";
			tf.embedFonts = true;
			tf.selectable = false;

			var bitmap:BitmapData = new BitmapData(tf.width, tf.height, true);
			bitmap.draw(tf);
			var bound:Rectangle = bitmap.getColorBoundsRect(0xFFFFFFFF, 0xFFFFFFFF, false);
			bitmap.dispose();

			var s:Number = region.width / bound.width * (Math.random() * 0.4 + 0.1);
			if (bound.height * s > region.height) s = region.height / bound.height;
			tf.scaleX = s;
			tf.scaleY = s;
			bound.x *= s;
			bound.y *= s;
			bound.width  *= s;
			bound.height *= s;

			switch (choice([1,2,3,4])) {
				case 1:
					tf.x = region.x - bound.x;
					tf.y = region.y - bound.y;
					queue.push(
						new Rectangle(region.x + bound.width, region.y, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y + bound.height, region.width, region.height - bound.height)
					);
					break;
				case 2:
					tf.x = region.x - bound.x;
					tf.y = region.bottom - bound.bottom;
					queue.push(
						new Rectangle(region.x + bound.width, region.bottom - bound.height, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y, region.width, region.height - bound.height)
					);
					break;
				case 3:
					tf.x = region.right - bound.right;
					tf.y = region.y - bound.y;
					queue.push(
						new Rectangle(region.x, region.y, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y + bound.height, region.width, region.height - bound.height)
					);
					break;
				case 4:
					tf.x = region.right - bound.right;
					tf.y = region.bottom - bound.bottom;
					queue.push(
						new Rectangle(region.x, region.bottom - bound.height, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y, region.width, region.height - bound.height)
					);
					break;
			}

			addChild(tf);
			Tweener.addTween(tf, {_text_color: 0x000000, time: 5, transition: "liner"});
		}

		private function choice(ary:Array):* {
			return ary[Math.floor(ary.length * Math.random())];
		}

	}
}
