/**
 * Copyright mex_ichikawa ( http://wonderfl.net/user/mex_ichikawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/unUv
 */

// forked from mex's 【AS100本ノック】6回目：爽快
/* 
 * AS100本ノック
 * 6回目のお題は「爽快」
 * あなたなりの「爽快」を表現してください。
 * --
 * 爽快→スピード→ワイプア○トのトンネル?
 * と思ったんですが、不快で変な空間になりました。
 */
package {
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.ui.Mouse;
	import flash.utils.Timer;
	
	import frocessing.color.ColorHSV;

	[SWF(width=465, height=465, backgroundColor=0xFFFFFF, frameRate=30)]
	public class Refreshing extends Sprite
	{
		public static const STAGE_WIDTH:uint = 465;
		public static const STAGE_HEIGHT:uint = 465;
		private var _square:Vector.<MySquare>;
		private var _isDown:Boolean;
		private var _timer:Timer;
		private var _rotate:Number;
		private var _scale:Number;
		private var _hsv:ColorHSV;
		private var _g:Graphics;
		private var _mpos:Point;
		private var _timeCount:uint;
		
		public function Refreshing()
		{
			init();
		}
		private function init():void
		{
			Mouse.hide();
			_square = new Vector.<MySquare>();
			_isDown = false;
			_rotate = 0;
			_scale = 1.3;
			_hsv = new ColorHSV(0, 1, 1, 1);
			_g = graphics;
			_timeCount = 0;
			_mpos = new Point(STAGE_WIDTH/2, STAGE_HEIGHT/2);

			_timer = new Timer(50);
			_timer.addEventListener(TimerEvent.TIMER, timerHandler);
			_timer.start();

			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);

			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		private function mouseDownHandler(event:MouseEvent):void
		{
			_isDown = true;
		}
		private function mouseUpHandler(event:MouseEvent):void
		{
			_isDown = false;
		}
		private function mouseMoveHandler(event:MouseEvent):void
		{
			_mpos.x = event.stageX;
			_mpos.y = event.stageY;
			_rotate = (STAGE_WIDTH / 2 - _mpos.x) / (STAGE_WIDTH / 2) * 1;
			_scale = 1.25 + (_mpos.y / STAGE_HEIGHT / 5);
			
		}
		private function timerHandler(event:TimerEvent):void
		{
			_hsv.h = _timeCount = (_timeCount+3) % 360;
			_square.unshift(new MySquare(_mpos, _hsv.value));
		}
		private function cleanData():void
		{
			while(_square.length > 0 && _square[_square.length-1].isOut())
			{
				_square.pop();
			}
		}
		private function enterFrameHandler(event:Event):void
		{
			cleanData();
			_g.clear();
			_g.lineStyle(1, 0x000000, 1);
			var lineCommand:Vector.<int> = new Vector.<int>;
			var lineData:Vector.<Number> = new Vector.<Number>;
			for(var i:uint=0,imax:uint=_square.length; i<imax; i++)
			{
				_square[i].scaleBy(_scale);
				_square[i].rotateBy(_rotate);
				for(var j:uint=0,jmax:uint=MySquare.POINT_COUNT; j<jmax; j++)
				{

					if(j==0)
					{
						lineCommand.push(1);
						lineData = lineData.concat(_square[i].getPoint2D(jmax-1));
					}
					lineCommand.push(2);
					lineData = lineData.concat(_square[i].getPoint2D(j));
				}
			}
			_g.lineStyle(1, 0x000000, 1);
			_g.drawPath(lineCommand, lineData);

			for(i=1,imax=_square.length; i<imax; i++)
			{
				
				
				for(j=0,jmax=MySquare.POINT_COUNT; j<jmax; j++)
				{
					lineCommand = new Vector.<int>();
					lineData = new Vector.<Number>();
					var matr:Matrix = new Matrix();
					_g.beginFill(_square[i].getColor(), 1);
					lineCommand.push(1);
					lineData = lineData.concat(_square[i].getPoint2D(j));
					lineCommand.push(2);
					lineData = lineData.concat(_square[i-1].getPoint2D(j));
					lineCommand.push(2);
					lineData = lineData.concat(_square[i-1].getPoint2D((j+(jmax-1))%jmax));
					lineCommand.push(2);
					lineData = lineData.concat(_square[i].getPoint2D((j+(jmax-1))%jmax));
					lineCommand.push(2);
					lineData = lineData.concat(_square[i].getPoint2D(j));
					_g.drawPath(lineCommand, lineData);
					_g.endFill();
				}
			}
			
		}
	}
}
import flash.geom.Point;
class MySquare
{
	public static const POINT_COUNT:int = 4;
	private static const DEFAULT_SIZE:int = 5;
	private var _points:Vector.<Number>;
	private var _rotate:Number;
	private var _color:uint;
	private var _center:Point;
	private var _outflg:Boolean;
	public function MySquare(pos:Point, color:uint)
	{
		_center = pos;
		_color = color;
		init();
	}
	private function init():void
	{
		_rotate = 0;
		_points = new Vector.<Number>();
		_outflg = false;
		//lt
		_points.push(-(DEFAULT_SIZE/2));
		_points.push(-(DEFAULT_SIZE/2));
		//rt
		_points.push(DEFAULT_SIZE/2);
		_points.push(-(DEFAULT_SIZE/2));
		//rb
		_points.push(DEFAULT_SIZE/2);
		_points.push(DEFAULT_SIZE/2);

		//lb
		_points.push(-(DEFAULT_SIZE/2));
		_points.push(DEFAULT_SIZE/2);

	}
	public function get x():Number
	{
		return _center.x;
	}
	public function get y():Number
	{
		return _center.y;
	}
	public function rotateBy(angle:Number):void
	{
		var radian:Number = angle * Math.PI/180;
		for(var i:uint=0,imax:uint=_points.length; i<imax; i+=2)
		{
			_points[i] = _points[i] * Math.cos(radian) - _points[i+1] * Math.sin(radian);
			_points[i+1] = _points[i+1] * Math.cos(radian) + _points[i] * Math.sin(radian);
		}
		_rotate = (_rotate + angle) % 360;
	}
	private function rotateTo(angle:Number):void
	{
		var radian:Number = (angle - _rotate)  * Math.PI/180;
		for(var i:uint=0,imax:uint=_points.length; i<imax; i+=2)
		{
			_points[i] = _points[i] * Math.cos(radian) - _points[i+1] * Math.sin(radian);
			_points[i+1] = _points[i+1] * Math.cos(radian) + _points[i] * Math.sin(radian);
		}
	}
	public function scaleBy(scale:Number):void
	{
		var r:Number = _rotate;
		rotateTo(0);
		for(var i:uint=0,imax:uint=_points.length; i<imax; i++)
		{
			_points[i] *= scale;
		}
		var w:Number = _points[2] - _points[0];
		var h:Number = _points[7] - _points[1];
		
		if(Math.sqrt(w*w + h*h) > Math.sqrt(Refreshing.STAGE_WIDTH*Refreshing.STAGE_WIDTH + Refreshing.STAGE_HEIGHT*Refreshing.STAGE_HEIGHT) * 3)
		{
			_outflg = true;
		}
		rotateTo(r);
	}
	public function getColor():uint
	{
		return _color;
	}
	public function isOut():Boolean
	{
		return _outflg;
	}
	public function getPoint2D(key:int):Vector.<Number>
	{
		var vec:Vector.<Number> = _points.slice(key*2, key*2+2);
		vec[0] += x;
		vec[1] += y;
		return vec;
	}
}
