/**
 * Copyright kuroneko ( http://wonderfl.net/user/kuroneko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/um1g
 */

// forked from clockmaker's [PV3D] Field of Blur
/**
* Papervision3Dで被写界深度
* 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#000000")]
	
	public class Main extends BasicView 
	{	
		// const vars
		static private const OBJ_LENGTH   :int = 20;
		static private const CIRCLE_RANGE :int = 500;
		static private const CIRCLE_RANGE2 :int = 490;
		
		// 3d vars
		private var list :Array = []
		private var list2 :Array = []
		private var wrap :DisplayObject3D;
		private var wrap2 :DisplayObject3D;

		/**
		 * Constructor
		 */
		public function Main()
		{
			//camera
			camera.x         = 0;
			camera.y         = 500;
			camera.z         = 1000;
			camera.rotationX = 5;
			
			// wrap
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			wrap2 = new DisplayObject3D();
			scene.addChild(wrap2);
			
			for (var i:int = 0; i < OBJ_LENGTH; i++)
			{
				var rot:Number = 360 * i / OBJ_LENGTH ;
				
				var m:ColorMaterial = new ColorMaterial(0x00CCCC);
				m.doubleSided = true;
				
				var o:Plane = new Plane(m, 100, 100);
				o.x = CIRCLE_RANGE * Math.sin(rot * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE * Math.cos(rot * Math.PI / 180);
				o.rotationY = rot;
				o.useOwnContainer = true; //ココ重要 これがないとblewしない
				
				// 配列に追加　＆　wrapの子供にする
				list.push(wrap.addChild(o));
			}

			for (var j:int = 0; j < OBJ_LENGTH; j++)
			{
				rot = 360 * j / OBJ_LENGTH ;
				
				m = new ColorMaterial(0x0000CC);
				m.doubleSided = true;
				
				o = new Plane(m, 100, 100);
				o.x = CIRCLE_RANGE2 * Math.sin(rot * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE2 * Math.cos(rot * Math.PI / 180);
				o.rotationY = rot;
				o.useOwnContainer = true; //ココ重要 これがないとblewしない
				
				// 配列に追加　＆　wrapの子供にする
				list2.push(wrap2.addChild(o));
			}
			
			addEventListener(Event.ENTER_FRAME, loop);
			addEventListener(Event.ENTER_FRAME, loop2);
			startRendering(); 
		}
		
		// loop
		private function loop(event:Event):void
		{
			wrap.yaw(-1);
//			wrap.pitch(-1);
//			wrap.roll(-1);

			// 被写界深度
			
			for (var i:int = 0; i < list.length; i++)
			{
				var o:DisplayObject3D = list[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 50); 
				o.filters = [new BlurFilter(blur, blur, 2)];
			}

		}

		// loop
		private function loop2(event:Event):void
		{
			wrap2.yaw(2);

			// 被写界深度
			
			for (var i:int = 0; i < list2.length; i++)
			{
				var o:DisplayObject3D = list2[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE2 - o.sceneZ) / 50); 
				o.filters = [new BlurFilter(blur, blur, 2)];
			}

		}

	}
}