/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ulIw
 */

/* 
 * 流れてくるエビフライにただひたすらソースとマヨネーズをかける
 */
package 
{
	import com.bit101.components.PushButton;
	import com.bit101.components.RadioButton;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BevelFilter;
	import flash.filters.BlurFilter;
	import flash.filters.DropShadowFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	
	[SWF(width=465,height=465,frameRate=40)]
	public class FlashTest extends Sprite 
	{
		private var sp:Sprite = new Sprite();
		private var bevelFilter:BevelFilter = new BevelFilter();
		private var dropShadowFilter:DropShadowFilter = new DropShadowFilter(5,90,0x660000,0.2,5,5);
		private var bimtapBase:Bitmap;
		private var bimtapTemp:Bitmap;
		private var oldX:Number;
		private var oldY:Number;
		private var isMouseDown:Boolean = false;
		private var source:int = 0;
		private var katsu:Bitmap;
		private var slide:Number = 0;
		
		public function FlashTest():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, this.init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, this.init);
			
			var l:Loader = new Loader();
			l.load(new URLRequest("http://assets.wonderfl.net/images/related_images/b/b2/b27a/b27a6bbf68d1ad97352deb926114403deb4b8fa4"),new LoaderContext(true));
			l.contentLoaderInfo.addEventListener(Event.COMPLETE , loadCompleteHandler);
			
			this.bimtapBase = new Bitmap(new BitmapData(465, 465, true, 0xFF6699));
			this.bimtapTemp = new Bitmap(new BitmapData(465, 465, true, 0xFF6699));
			this.addChild(this.bimtapBase);
			this.addChild(this.bimtapTemp);
			
			this.bimtapTemp.filters = [this.dropShadowFilter];
			
			new RadioButton(this, 0, 0, "Mayonnaise", true,radioButtonClickHandler);
			new RadioButton(this, 0, 15, "Tonkatsu sauce",false,radioButtonClickHandler);
			
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			var mat:Matrix = new Matrix();
			mat.translate(this.slide--, 0);
			this.graphics.clear();
			this.graphics.beginBitmapFill(this.katsu.bitmapData,mat,true);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			var bd:BitmapData = this.bimtapBase.bitmapData.clone();
			this.bimtapBase.bitmapData.fillRect(this.bimtapBase.bitmapData.rect, 0);
			this.bimtapBase.bitmapData.copyPixels(bd, bd.rect, new Point(-1,0));
			bd = this.bimtapTemp.bitmapData.clone();
			this.bimtapTemp.bitmapData.fillRect(this.bimtapBase.bitmapData.rect, 0);
			this.bimtapTemp.bitmapData.copyPixels(bd, bd.rect, new Point(-1,0));
			bd.dispose();
		}
		
		private function loadCompleteHandler(event:Event):void
		{
			this.katsu = (event.currentTarget as LoaderInfo).loader.content as Bitmap;
			
			this.stage.addEventListener(MouseEvent.MOUSE_DOWN , mouseDownHandler);
			this.stage.addEventListener(MouseEvent.MOUSE_UP   , mouseUpHandler);
			this.stage.addEventListener(Event.ENTER_FRAME     , mouseMoveHandler);
			this.stage.addEventListener(Event.ENTER_FRAME     , enterFrameHandler);
		}
		
		private function radioButtonClickHandler(e:Event):void
		{
			var rb:RadioButton = e.currentTarget as RadioButton;
			switch (rb.label) 
			{
				case "Mayonnaise":this.source = 0; break;
				default: this.source = 1;
			}
		}
		
		private function mouseUpHandler(e:MouseEvent):void 
		{
			this.isMouseDown = false;
			if (this.source != 0) this.bimtapTemp.filters = [new BlurFilter(12, 12),this.dropShadowFilter];
			this.bimtapBase.bitmapData.draw(this.bimtapTemp);
			this.bimtapTemp.filters = [this.dropShadowFilter];
			this.bimtapTemp.bitmapData.fillRect(this.bimtapTemp.bitmapData.rect, 0);
		}
		
		private function mouseDownHandler(e:MouseEvent):void 
		{
			this.isMouseDown = true;
		}
		
		private function mouseMoveHandler(e:Event):void 
		{
			if (!this.isMouseDown)
			{
				this.oldX = this.oldY = NaN;
				return;
			}
			
			if (!isNaN(this.oldX))
			{
				var color:uint = (this.source==0)?0xFAEE05:0x803C23;
				var thic:uint  = (this.source==0)?8:12;
				this.sp.graphics.clear();
				this.sp.graphics.lineStyle(thic, color , 1);
				this.sp.graphics.moveTo(this.oldX, this.oldY);
				this.sp.graphics.lineTo(this.stage.mouseX,this.stage.mouseY);
				
				this.bevelFilter.highlightColor = this.bevelFilter.shadowColor = (this.source == 0)?0xF5CF1B:0x6D2717;
				this.bevelFilter.angle = Math.atan2(this.stage.mouseY-this.oldY, this.stage.mouseX-this.oldX) * (180/Math.PI) + 90;
				this.sp.filters = [this.bevelFilter];
				
				this.bimtapTemp.bitmapData.draw(this.sp);
			}
			
			this.oldX = this.stage.mouseX;
			this.oldY = this.stage.mouseY;
			
		}
		
	}
	
}