/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ukUl
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * [企画]皆で動くパズル作ろうぜ
     * http://wonderfl.net/c/yb0z
     * 前から気になってた事があって、Wonderfl は色んな作品があるけど作品同士のつながりがないのが気になっていた。
     * 例えば、パーツだけ作って読み込んでロードするだけで使える[素材]を作るとか。
     * あと Fork することで何かに参加できるようにすればもっと面白い事になって行きそうなきがする。
     * チェックメイトやJAMのような方法ではなく、Forkされたもの全てが一つの作品を作るというか。
     * これからもチェックメイトやJAM以外にも[企画]タグや[素材]タグが増えていくといいなぁ。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "30", width = "465", height = "465")]
    public class MoviePuzzle extends Sprite 
    {
        private static const BG_COLOR: uint = 0x000000;
        private static const FRAME_RATE: uint = 30;
        private var disp:DisplayObject;
        
        public function MoviePuzzle() 
        {
            // ローダーで読み込まれなかった時の為のデモ用
            addEventListener(Event.ADDED_TO_STAGE, demo);
        }
        
        /**
         * 
         * MoviePuzzle -> MovieJigsawPuzzle
         *         obj["disp"]      : DisplayObject : 描画対象このオブジェクトの440x440の範囲で切り取られて描画されます。
         *         obj["color"]     : uint : 背景色(省略時は0x000000)
         *         obj["frameRate"] : uint : フレームレート(省略時は60)
         *         obj["level"]     : uint : 上限レベル(省略時は1)
         * @param    obj : <Object>
         */
        public function initialize(obj: Object): void
        {
            disp = new soundSpectrum("http://www.takasumi-nagai.com/soundfiles/sound007.mp3");
            obj["disp"]  = disp;
            obj["color"] = BG_COLOR;
            obj["frameRate"]  = FRAME_RATE;
            obj["level"] = 3;
        }
        
        /**
         * スタートする時に呼ばれます。
         * @param    level : uint : 指定レベル : 変える必要があれば。
         */
        public function start(level: uint): void
        {
            Object(disp).start(level);
        }
        
        /**
         * 終了した時に呼ばれます。
         */
        public function end(): void
        {
            Object(disp).end();
        }
        
        
        /**
         * デモ用
         * @param    e
         */
        private function demo(e: Event): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, demo);
            //
            var obj: Object = {};
            initialize(obj);
            disp = obj["disp"];
            var col: uint = obj["color"];
            var bmd: BitmapData = new BitmapData(440, 440, false, col);
            var bmp: Bitmap = new Bitmap(bmd, "auto", true);
            start(1);
            addChild(bmp);
            addEventListener(Event.ENTER_FRAME, function(e: Event): void {
                bmd.lock();
                bmd.fillRect(bmd.rect, col);
                bmd.draw(disp);
                bmd.unlock();
            } );
        }
    }
}



        import caurina.transitions.Tweener;
        import com.bit101.components.Label;
        import flash.display.Sprite;
        import flash.events.Event;
        import flash.geom.Point;
        import flash.media.Sound;
        import flash.media.SoundChannel;
        import flash.media.SoundLoaderContext;
        import flash.media.SoundMixer;
        import flash.media.SoundTransform;
        import flash.net.URLRequest;
        import flash.utils.ByteArray;
        
        class soundSpectrum extends Sprite
        {
            private var leftRightSpList:Array;
            private var position:Array;
            private var snd:Sound;
            private var FFTswitch:Boolean = false;
            private var _level:uint = 1;
            private var _url:String;
            private var sndChannel:SoundChannel;
            
            function soundSpectrum(url:String) 
            {
                graphics.beginFill(0);
                graphics.drawRect(0, 0, 465, 465);
                graphics.endFill();
                
                _url = url;
                
                leftRightSpList = makeLeftRightSpList();
                position = makePosition();
            }
            
            public function start(level:uint = 1):void
            {
                _level = level * 2;
                playSound(_url);
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            }
            
            public function end():void
            {
                removeEventListener(Event.ENTER_FRAME, onEnterFrame);
                //sndChannel.stop();
                //playSound("http://www.takasumi-nagai.com/soundfiles/sound004.mp3");
                //addEventListener(Event.ENTER_FRAME, EndEvent);
                var _label:Label = new Label(this);
                _label.text = "congratulation";
                _label.scaleX = _label.scaleY = 2;
                _label.x = 10;
                _label.y = 10;
                _label.blendMode = "invert";
            }
            
            private function playSound(url:String = ""):void
            {
                snd = new Sound();
                var context:SoundLoaderContext = new SoundLoaderContext(10,true);
                var req:URLRequest = new URLRequest(url);
                snd.load(req, context);
                sndChannel = new SoundChannel();
                sndChannel = snd.play(0, 100, new SoundTransform(0.3, 0));
            }
            
            private function onEnterFrame(event:Event):void {
                var bytes:ByteArray = new ByteArray();
                SoundMixer.computeSpectrum(bytes, FFTswitch, 0);
                var n:uint, j:uint;
                for (n = 0; n < 2; n++)
                {
                    var spList:Array = leftRightSpList[n];
                    for (j = 0; j < 256; j++)
                    {
                        var sp:Sprite = spList[j] as Sprite;
                        var rf:Number = bytes.readFloat();
                        var scale:Number = Math.max(0.2, 1 + rf * 20);
                        sp.scaleX = sp.scaleY = scale;
                        
                        sp.x += sp.x * rf * 5 + _level;
                    }
                }
            }
                    
            private function makeLeftRightSpList():Array
            {
                var spLRList:Array = [];
                var circle_r:uint = 2;
                var n:uint;
                var i:uint;
                for (n = 0; n < 2; n++)
                {
                    var spList:Array = [];
                    for (i = 0; i < 256; i++) {
                        var _col:uint = 0x00FF00 * (i + 1);
                        var sp:Sprite = new Sprite();
                        if (n == 0) {
                            sp.graphics.beginFill(_col, 0);
                            sp.graphics.lineStyle(0.5, _col);
                            sp.graphics.drawCircle(0, 0, circle_r);
                        }else {
                            sp.graphics.beginFill(_col);
                            sp.graphics.drawCircle(0, 0, circle_r);
                        }
                        sp.graphics.endFill();
                        sp.y = 465 / 256 * i;
                        addChild(sp);
                        spList.push(sp);
                    }
                    spLRList.push(spList);
                }
                return spLRList;
            }
            
            private function makePosition():Array
            {
                var _container:Array = [];
                var _w:Number = 465 / 16;
                var _h:Number = 465 / 16;
                var n:uint;
                var i:uint;
                for (n = 0; n < 2; n++)
                {
                    var _arr:Array = new Array();
                    for (i = 0; i < 256; i++) {
                        var p:Point = new Point();
                        p.x = _w / 2 + (i % 16) * _w;
                        p.y = _h / 2 + _h * Math.floor(i / 16);
                        _arr.push(p);
                    }
                    _container.push(_arr);
                }
                return _container;
            }
            
            private function EndEvent(e:Event):void 
            {
                var bytes:ByteArray = new ByteArray();
                SoundMixer.computeSpectrum(bytes, FFTswitch, 0);
                var n:uint, j:uint;
                for (n = 0; n < 2; n++)
                {
                    var spList:Array = leftRightSpList[n];
                    var positionList:Array = position[n];
                    for (j = 0; j < 256; j++)
                    {
                        var sp:Sprite = spList[j] as Sprite;
                        var rf:Number = bytes.readFloat();
                        var scale:Number = Math.max(0.5, 1 + rf * 100);
                        
                        var p:Point = positionList[j] as Point;
                        
                        Tweener.addTween(sp, { x:p.x, y:p.y, scaleX:scale, scaleY:scale, time:0.5 } );
                    }
                }
            }

        }