/**
 * Copyright yew ( http://wonderfl.net/user/yew )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uirL
 */

// forked from rsakane's キャラ / マップチップ表示
/*
 * 画面をクリックした後、矢印キーで移動できます。
 * 
 * チップ素材
 * First Seed Material
 * http://www.tekepon.net/fsm/
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
 
    public class Main extends Sprite
    {
        private var charaChip:BitmapData;
        private var mapChip:BitmapData;
        private const C_WIDTH:int = 32;
        private const C_HEIGHT:int = 48;
        private const CHIPSIZE:int = 32;
        private const SPEED:int = 4;
 
        private var frame:int = 0;
        private var cx:int = 1;
        private var cy:int = 1;
        private var prevcy:int = 0;
        private var chara:BitmapData;
        private var key:int = 0;
        private var player:Sprite;        
        private var isMoving:Boolean = false;
        private var vx:int = 0;
        private var vy:int = 0;
        private var images:Object = new Object();
        private var bg:BitmapData;
        private var background:Bitmap;
        private var uLayer:Bitmap;
        private var lLayer:Bitmap;
        private var pos:Point = new Point();
 
        private    const IMAGE_URL:Array =
        [
            ["http://assets.wonderfl.net/images/related_images/3/3a/3a22/3a2215b000c245d9f0de63c7c0e69ba7a05961ab", Image.CHARACTER],
            ["http://assets.wonderfl.net/images/related_images/e/ef/ef41/ef415c45339b10ebe3697131179e72a5c864f3cb", Image.MAP]
        ];
 
        public function Main()
        {
            var loadCount:int = 0;
            var f:Function = function(event:Event):void
            {
                //f?
                images[event.currentTarget.loader.name] = event.currentTarget.loader;//必要
                if (++loadCount == IMAGE_URL.length) initHandler();
            }
 
            for (var i:int = 0; i < IMAGE_URL.length; i++)
            {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.INIT, f);
                loader.load(new URLRequest(IMAGE_URL[i][0]), new LoaderContext(true));
                loader.name = IMAGE_URL[i][1];
            }
        }
 
        private function initHandler():void
        {            
            Map.width = Map.data[0].length;
            Map.height = Map.data.length;
            
            var loader:Loader = images[Image.MAP];
            mapChip = new BitmapData(loader.width, loader.height, true, 0x0);
            mapChip.draw(loader);//真っ白になった
 
            bg = new BitmapData(Map.width * CHIPSIZE, Map.height * CHIPSIZE, true, 0x0);
            var lower:BitmapData = bg.clone();
            var upper:BitmapData = bg.clone();
            background = new Bitmap(bg);
            addChild(background);//まっろなった
 
            var length:int = mapChip.width / CHIPSIZE;
            for (var y:int = 0; y < Map.height; y++)
            {
                for (var x:int = 0; x < Map.width; x++)
                {
                    var p:int = Math.abs(Map.data[y][x]);
                    var mx:int = p % length;
                    var my:int = p / length;
                    bg.copyPixels(mapChip, new Rectangle(mx * CHIPSIZE, my * CHIPSIZE, CHIPSIZE, CHIPSIZE), new Point(x * CHIPSIZE, y * CHIPSIZE));
                }
            }
            
            for (y = 0; y < Map.height; y++)
            {
                for (x = 0; x < Map.width; x++)
                {
                    if (Map.lLayer[y][x] != -1)
                    {
                        mx = Map.lLayer[y][x] % length;
                        my = Map.lLayer[y][x] / length;
                        
                        lower.copyPixels(mapChip, new Rectangle(mx * CHIPSIZE, my * CHIPSIZE, CHIPSIZE, CHIPSIZE), new Point(x * CHIPSIZE, y * CHIPSIZE));
                    }
                    
                    if (Map.uLayer[y][x] != -1)
                    {
                        mx = Map.uLayer[y][x] % length;
                        my = Map.uLayer[y][x] / length;
                        
                        upper.copyPixels(mapChip, new Rectangle(mx * CHIPSIZE, my * CHIPSIZE, CHIPSIZE, CHIPSIZE), new Point(x * CHIPSIZE, y * CHIPSIZE));
                    }
                }
            }
            
            lLayer = new Bitmap(lower);
            addChild(lLayer);//墓とか家の窓が消える
 
            loader = images[Image.CHARACTER];
            charaChip = new BitmapData(loader.width, loader.height, true, 0x0);
            charaChip.draw(loader);//きゃらいないのに動く
            charaChip.threshold(charaChip, charaChip.rect, new Point(), "==", 0x78c380, 0x0, 0xFFFFFF);
 
            chara = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x0);
            var bitmap:Bitmap = new Bitmap(chara);
            bitmap.y -= (CHIPSIZE);
            player = new Sprite();
            pos.x = player.x = 10 * CHIPSIZE;
            pos.y = player.y = 10 * CHIPSIZE;
            
            player.addChild(bitmap);
            addChild(player);//プレーヤー//うごかない
            
            uLayer = new Bitmap(upper);
            addChild(uLayer);//なぜか中途半端なものばかり消える
 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);//キャラきえた
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);//stop指定？
        }
 
        private function onEnterFrame(event:Event = null):void
        {
            background.x = uLayer.x = lLayer.x = (stage.stageWidth  - CHIPSIZE) / 2 - pos.x;
            background.y = uLayer.y = lLayer.y = (stage.stageHeight - CHIPSIZE) / 2 - pos.y;
 
            background.x = uLayer.x = lLayer.x = Math.min(0, background.x);
            background.y = uLayer.y = lLayer.y = Math.min(0, background.y);
 
            background.x = uLayer.x = lLayer.x = Math.max(stage.stageWidth,  background.x + Map.width  * CHIPSIZE) - Map.width  * CHIPSIZE;
            background.y = uLayer.y = lLayer.y = Math.max(stage.stageHeight, background.y + Map.height * CHIPSIZE) - Map.height * CHIPSIZE;
            
            player.x = background.x + pos.x;
            player.y = background.y + pos.y;
 
            if (isMoving)
            {
                pos.x += vx;
                pos.y += vy;
 
                if ((vx && pos.x % CHIPSIZE == 0) || (vy && pos.y % CHIPSIZE == 0))
                {
                    isMoving = false;
                    if (!key) cx =20;//なにち
                    //-20000;だとしょりおち
                    //-20000;にしたら男の子がたまに出てくる
                    //if (!key) cx = 10;//なにち
                }
            }
            else
            {
                vx = vy = 0;
 
                if (key & Key.LEFT) vx = -SPEED, cy = 1;
                else if (key & Key.RIGHT) vx = SPEED, cy = 2;//S-は左しかいかんくなる、みぎきかん
                else if (key & Key.TOP) vy = -SPEED, cy = 3;//うえにいかない-つかないと
                else if (key & Key.BOTTOM) vy = SPEED, cy = 0;//したにいかない-つけると
                                
                /* if (key & Key.LEFT) vx = -SPEED, cy = 1;
                else if (key & Key.RIGHT) vx = SPEED, cy = 2;
                else if (key & Key.TOP) vy = -SPEED, cy = 3;
                else if (key & Key.BOTTOM) vy = SPEED, cy = 0;
                */
                if (vx || vy)
                {
                    var px:int = pos.x / CHIPSIZE;
                    var py:int = pos.y / CHIPSIZE;
                    py += vy / SPEED;
                    px += vx / SPEED;
                if (0 <= py && py < Map.height &&
                    0 <= px && px < Map.width &&
                    Map.data[py][px] >= 0)
                {
                    isMoving = true;
                    onEnterFrame();
                }
                }
            }
 
            if (prevcy != cy || frame++ % 5 == 0)
            {
                chara.copyPixels(charaChip, new Rectangle(C_WIDTH * (cx + 6), C_HEIGHT * cy, C_WIDTH, C_HEIGHT), new Point());
                if (isMoving) cx = (cx + 1) % 3;
                prevcy = cy;
            }
        }
 
        private function onKeyDown(event:KeyboardEvent):void
        {
            if (event.keyCode == 37) key |= Key.LEFT;
            if (event.keyCode == 39) key |= Key.RIGHT;
            if (event.keyCode == 38) key |= Key.TOP;
            if (event.keyCode == 40) key |= Key.BOTTOM;
        }
 
        private function onKeyUp(event:KeyboardEvent):void
        {
            if (event.keyCode == 37) key &= ~Key.LEFT;
            if (event.keyCode == 39) key &= ~Key.RIGHT;
            if (event.keyCode == 38) key &= ~Key.TOP;
            if (event.keyCode == 40) key &= ~Key.BOTTOM;
        }
    }
}
 
class Key
{
    public static const LEFT:int = 1;
    public static const RIGHT:int = 2;
    public static const TOP:int = 4;
    public static const BOTTOM:int = 8;
}
 
class Map
{
    public static var width:int;
    public static var height:int;
 
    public static var data:Array = 
    [
        [-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,   0,   0,  -6,  -6,  -6,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,-6  ,-6  ,-6  ,   0],
        [-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0, -6 ,-6  ,-6  ,   0,   0,   0,-6  ,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,-6  ,-6  ,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,   0,-6  ,-6  ,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,   0,-6  ,-6  ,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,-104,-104,-104,-104,-104,-104,-104,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-104,-104,-104,-104,-104,-104,-104,-104,-104,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-104,-104, 104, 104, 104, 104, 104, 104,-104,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,  -6,  -6,   0,   0,   0],
        [-6  ,   0,-104,-104, 104, 104, 104, 104, 104, 104,-104,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-24 ,   8,   8,   8,   8,   8,   8,   8,-25 ,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-10 ,  11,  11,  11,  11,  11,  11,  11,-26 ,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-10 ,  11,  11,  11,  11,  11,  11,  11,-26 ,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-40 ,-9  ,-9  ,-9  ,-9  ,-9  ,-9  ,-9  ,-41 ,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,   1, 48 , 48 , 48 , 48 , 48 , 48 , 2  ,   0,   0, 103, 103, 103,   0,   0],
        [-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,   0,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,-1  , 48 , 48 , 48 , 48 , 48 , 48 , 2  ,   0,   0, 103, 103,-103,-6  ,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  , 48 , 48 , 48 , 48 , 48 , 48 , 2  ,   0,   0,-103, 103, 103,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  66,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   -6,  0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  66,   0,   0,   0,   0,   0,   0],
        [   0,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  66,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  82,  51,  51,  51,  51,  51,  51],
        [   0,-6  ,-6  ,-6  ,   0,-6  ,   0,   0,-6  ,   0,  -6,   0,   0,-6  ,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,-98 ,-98 ,  97,-97 ,-97 ,-97 ,-97 ],
        [   0,-6  ,-6  ,-6  ,   0,-6  ,   0,   0,-6  ,   0,  -6,   0,   0,-6  ,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,-112,-113, 113,-113,-113,-113,-113],
        [   0,   0,   0,   0,   0,-6  ,-6  ,-6  ,-6  ,   0,  -6,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [   0,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,-6  ,-6  ,   0,   0,   0,-6  ,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0]
    ];
    
    public static var lLayer:Array = 
    [
        [ 154, 155, 155, 155, 155, 155, 155, 155, 155, 155, 155, 155, 156,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 170, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 172,-1  ,-1  , 134, 135, 136,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 212, 213, 142, 212, 213,-1  ],
        [ 227, 226, 227,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 226, 227, 226,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 227, 226, 227,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 224, 225,-1  ,-1  ,-1  ,-1  , 102,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  , 177,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 101, 176, 101,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  , 179,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 126, 127,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 198, 198,-1  , 126, 127,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 214, 214,-1  , 126, 127,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 83 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 83 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  , 105, 106, 122,-1  ,-1  ,-1  , 124, 108, 109,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 210, 211,-1  ,-1  ,-1  ],
        [-1  ,-1  , 121, 122,-1  ,-1  , 123,-1  ,-1  , 124, 125,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,14  ,15  ,-1  ,14  ,15  ,-1  ,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,62  ,63  ,-1  ,46  ,47  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,  12,-1  ,-1  ,  12,-1  ,-1  ,  45,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,  28,-1  ,-1  ,  28,-1  ,-1  ,  44,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 53 , 53 , 53 , 53 , 53 , 53 , 53 , 53 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 182,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 69 , 69 , 69 , 69 , 69 , 69 , 69 , 69 ,-1  ,-1  , 148,-1  , 148,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 70 , 69 , 69 , 69 , 69 , 69 , 69 , 69 ,-1  ,-1  ,-1  , 148, 147, 100,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 86 , 85 , 85 , 85 , 85 , 85 , 85 , 85 ,-1  ,-1  , 147, 148,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 149,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  , 215, 216, 217,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  , 139, 139, 139,-1  ,  78,  79,   4,   5,-1  , 157, 158, 159,  55,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 128,-1  ,-1  ,-1  ,-1  ],
        [-1  , 140, 141, 180,-1  ,  94,  95,  20,  21,-1  , 173, 174, 175,  71,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 128,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  , 110, 111,  36,  37,-1  , 189, 190, 191,  87,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 160,-1  , 165],
        [-1  , 137, 138, 137,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 114, 115,-1  ,-1  ,-1  , 117,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 145, 146,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
    ];
    
    public static var uLayer:Array = 
    [
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 118, 119, 120,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 196, 197,-1  , 196, 197,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 192, 193, 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 208, 209, 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  , 178,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,  72,  56,  88,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,  72,  58,  75,  60,  88,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,  72,  58,  74,  75,  76,  60,  88,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 67 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,  57,  58,  74,  90,  91,  92,  76,  60,  61,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,  73,  74,  90, 106, 107, 108,  92,  76,  77,-1  , 186,-1  ,-1  , 52 ,-1  , 67 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],    
        [ 185,-1  ,  89,  90, 106, 122,-1  , 124, 108,  92,  93,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 194, 195,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 152, 184, 184, 184, 184, 184, 184, 184, 150,-1  , 151, 184, 153,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 168, 183, 183, 183, 183, 183, 183, 183, 166,-1  , 167, 183, 169,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 84 ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  , 199, 200, 201,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 131, 132, 133,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 129, 130,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ]
    ]
}
 
class Image
{
    public static const CHARACTER:int = 0;
 /////////////////////////////////////   
    /*
    // forked from rsakane's キャラ / マップチップ表示
/*
 * 画面をクリックした後、矢印キーで移動できます。
 * 
 * チップ素材
 * First Seed Material
 * http://www.tekepon.net/fsm/
 */
 /*
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
 
    public class Main extends Sprite
    {
        private var charaChip:BitmapData;
        private var mapChip:BitmapData;
        private const C_WIDTH:int = 32;
        private const C_HEIGHT:int = 48;
        private const CHIPSIZE:int = 32;
        private const SPEED:int = 4;
 
        private var frame:int = 0;
        private var cx:int = 1;
        private var cy:int = 1;
        private var prevcy:int = 0;
        private var chara:BitmapData;
        private var key:int = 0;
        private var player:Sprite;        
        private var isMoving:Boolean = false;
        private var vx:int = 0;
        private var vy:int = 0;
        private var images:Object = new Object();
        private var bg:BitmapData;
        private var background:Bitmap;
        private var uLayer:Bitmap;
        private var lLayer:Bitmap;
        private var pos:Point = new Point();
 
        private    const IMAGE_URL:Array =
        [
            ["http://assets.wonderfl.net/images/related_images/3/3a/3a22/3a2215b000c245d9f0de63c7c0e69ba7a05961ab", Image.CHARACTER],
            ["http://assets.wonderfl.net/images/related_images/e/ef/ef41/ef415c45339b10ebe3697131179e72a5c864f3cb", Image.MAP]
        ];
 
        public function Main()
        {
            var loadCount:int = 0;
            var f:Function = function(event:Event):void
            {
                //f?
                images[event.currentTarget.loader.name] = event.currentTarget.loader;//必要
                if (++loadCount == IMAGE_URL.length) initHandler();
            }
 
            for (var i:int = 0; i < IMAGE_URL.length; i++)
            {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.INIT, f);
                loader.load(new URLRequest(IMAGE_URL[i][0]), new LoaderContext(true));
                loader.name = IMAGE_URL[i][1];
            }
        }
 
        private function initHandler():void
        {            
            Map.width = Map.data[0].length;
            Map.height = Map.data.length;
            
            var loader:Loader = images[Image.MAP];
            mapChip = new BitmapData(loader.width, loader.height, true, 0x0);
            mapChip.draw(loader);//真っ白になった
 
            bg = new BitmapData(Map.width * CHIPSIZE, Map.height * CHIPSIZE, true, 0x0);
            var lower:BitmapData = bg.clone();
            var upper:BitmapData = bg.clone();
            background = new Bitmap(bg);
            addChild(background);//まっろなった
 
            var length:int = mapChip.width / CHIPSIZE;
            for (var y:int = 0; y < Map.height; y++)
            {
                for (var x:int = 0; x < Map.width; x++)
                {
                    var p:int = Math.abs(Map.data[y][x]);
                    var mx:int = p % length;
                    var my:int = p / length;
                    bg.copyPixels(mapChip, new Rectangle(mx * CHIPSIZE, my * CHIPSIZE, CHIPSIZE, CHIPSIZE), new Point(x * CHIPSIZE, y * CHIPSIZE));
                }
            }
            
            for (y = 0; y < Map.height; y++)
            {
                for (x = 0; x < Map.width; x++)
                {
                    if (Map.lLayer[y][x] != -1)
                    {
                        mx = Map.lLayer[y][x] % length;
                        my = Map.lLayer[y][x] / length;
                        
                        lower.copyPixels(mapChip, new Rectangle(mx * CHIPSIZE, my * CHIPSIZE, CHIPSIZE, CHIPSIZE), new Point(x * CHIPSIZE, y * CHIPSIZE));
                    }
                    
                    if (Map.uLayer[y][x] != -1)
                    {
                        mx = Map.uLayer[y][x] % length;
                        my = Map.uLayer[y][x] / length;
                        
                        upper.copyPixels(mapChip, new Rectangle(mx * CHIPSIZE, my * CHIPSIZE, CHIPSIZE, CHIPSIZE), new Point(x * CHIPSIZE, y * CHIPSIZE));
                    }
                }
            }
            
            lLayer = new Bitmap(lower);
            addChild(lLayer);//墓とか家の窓が消える
 
            loader = images[Image.CHARACTER];
            charaChip = new BitmapData(loader.width, loader.height, true, 0x0);
            charaChip.draw(loader);//きゃらいないのに動く
            charaChip.threshold(charaChip, charaChip.rect, new Point(), "==", 0x78c380, 0x0, 0xFFFFFF);
 
            chara = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x0);
            var bitmap:Bitmap = new Bitmap(chara);
            bitmap.y -= (CHIPSIZE);
            player = new Sprite();
            pos.x = player.x = 10 * CHIPSIZE;
            pos.y = player.y = 10 * CHIPSIZE;
            
            player.addChild(bitmap);
            addChild(player);//プレーヤー//うごかない
            
            uLayer = new Bitmap(upper);
            addChild(uLayer);//なぜか中途半端なものばかり消える
 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);//キャラきえた
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);//stop指定？
        }
 
        private function onEnterFrame(event:Event = null):void
        {
            background.x = uLayer.x = lLayer.x = (stage.stageWidth  - CHIPSIZE) / 2 - pos.x;
            background.y = uLayer.y = lLayer.y = (stage.stageHeight - CHIPSIZE) / 2 - pos.y;
 
            background.x = uLayer.x = lLayer.x = Math.min(0, background.x);
            background.y = uLayer.y = lLayer.y = Math.min(0, background.y);
 
            background.x = uLayer.x = lLayer.x = Math.max(stage.stageWidth,  background.x + Map.width  * CHIPSIZE) - Map.width  * CHIPSIZE;
            background.y = uLayer.y = lLayer.y = Math.max(stage.stageHeight, background.y + Map.height * CHIPSIZE) - Map.height * CHIPSIZE;
            
            player.x = background.x + pos.x;
            player.y = background.y + pos.y;
 
            if (isMoving)
            {
                pos.x += vx;
                pos.y += vy;
 
                if ((vx && pos.x % CHIPSIZE == 0) || (vy && pos.y % CHIPSIZE == 0))
                {
                    isMoving = false;
                    if (!key) cx = 10s;//なにち
                }
            }
            else
            {
                vx = vy = 0;
 
                if (key & Key.LEFT) vx = -SPEED, cy = 1;
                else if (key & Key.RIGHT) vx = SPEED, cy = 2;
                else if (key & Key.TOP) vy = -SPEED, cy = 3;
                else if (key & Key.BOTTOM) vy = SPEED, cy = 0;
 
                if (vx || vy)
                {
                    var px:int = pos.x / CHIPSIZE;
                    var py:int = pos.y / CHIPSIZE;
                    py += vy / SPEED;
                    px += vx / SPEED;
                if (0 <= py && py < Map.height &&
                    0 <= px && px < Map.width &&
                    Map.data[py][px] >= 0)
                {
                    isMoving = true;
                    onEnterFrame();
                }
                }
            }
 
            if (prevcy != cy || frame++ % 5 == 0)
            {
                chara.copyPixels(charaChip, new Rectangle(C_WIDTH * (cx + 6), C_HEIGHT * cy, C_WIDTH, C_HEIGHT), new Point());
                if (isMoving) cx = (cx + 1) % 3;
                prevcy = cy;
            }
        }
 
        private function onKeyDown(event:KeyboardEvent):void
        {
            if (event.keyCode == 37) key |= Key.LEFT;
            if (event.keyCode == 39) key |= Key.RIGHT;
            if (event.keyCode == 38) key |= Key.TOP;
            if (event.keyCode == 40) key |= Key.BOTTOM;
        }
 
        private function onKeyUp(event:KeyboardEvent):void
        {
            if (event.keyCode == 37) key &= ~Key.LEFT;
            if (event.keyCode == 39) key &= ~Key.RIGHT;
            if (event.keyCode == 38) key &= ~Key.TOP;
            if (event.keyCode == 40) key &= ~Key.BOTTOM;
        }
    }
}
 
class Key
{
    public static const LEFT:int = 1;
    public static const RIGHT:int = 2;
    public static const TOP:int = 4;
    public static const BOTTOM:int = 8;
}
 
class Map
{
    public static var width:int;
    public static var height:int;
 
    public static var data:Array = 
    [
        [-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,   0,   0,  -6,  -6,  -6,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,-6  ,-6  ,-6  ,   0],
        [-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0, -6 ,-6  ,-6  ,   0,   0,   0,-6  ,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,-6  ,-6  ,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,   0,-6  ,-6  ,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,   0,-6  ,-6  ,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,-104,-104,-104,-104,-104,-104,-104,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-104,-104,-104,-104,-104,-104,-104,-104,-104,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-104,-104, 104, 104, 104, 104, 104, 104,-104,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,  -6,  -6,   0,   0,   0],
        [-6  ,   0,-104,-104, 104, 104, 104, 104, 104, 104,-104,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-24 ,   8,   8,   8,   8,   8,   8,   8,-25 ,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-10 ,  11,  11,  11,  11,  11,  11,  11,-26 ,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-10 ,  11,  11,  11,  11,  11,  11,  11,-26 ,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,-40 ,-9  ,-9  ,-9  ,-9  ,-9  ,-9  ,-9  ,-41 ,   0,-6  ,   0,   0,-6  ,   0,-6  ,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,   1, 48 , 48 , 48 , 48 , 48 , 48 , 2  ,   0,   0, 103, 103, 103,   0,   0],
        [-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,-6  ,   0,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,-1  , 48 , 48 , 48 , 48 , 48 , 48 , 2  ,   0,   0, 103, 103,-103,-6  ,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  , 48 , 48 , 48 , 48 , 48 , 48 , 2  ,   0,   0,-103, 103, 103,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  66,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   -6,  0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  66,   0,   0,   0,   0,   0,   0],
        [   0,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  66,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,  82,  51,  51,  51,  51,  51,  51],
        [   0,-6  ,-6  ,-6  ,   0,-6  ,   0,   0,-6  ,   0,  -6,   0,   0,-6  ,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,-98 ,-98 ,  97,-97 ,-97 ,-97 ,-97 ],
        [   0,-6  ,-6  ,-6  ,   0,-6  ,   0,   0,-6  ,   0,  -6,   0,   0,-6  ,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,-112,-113, 113,-113,-113,-113,-113],
        [   0,   0,   0,   0,   0,-6  ,-6  ,-6  ,-6  ,   0,  -6,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [   0,-6  ,-6  ,-6  ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,-6  ,-6  ,   0,   0,   0,-6  ,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,-6  ,-6  ,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0],
        [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-1  ,-48 ,-48 ,-48 ,-48 ,-48 ,-48 ,-2  ,   0,   0,   0,   0,   0,   0,   0]
    ];
    
    public static var lLayer:Array = 
    [
        [ 154, 155, 155, 155, 155, 155, 155, 155, 155, 155, 155, 155, 156,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 170, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 172,-1  ,-1  , 134, 135, 136,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 212, 213, 142, 212, 213,-1  ],
        [ 227, 226, 227,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 226, 227, 226,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 227, 226, 227,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 224, 225,-1  ,-1  ,-1  ,-1  , 102,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  , 177,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 101, 176, 101,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  , 179,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 126, 127,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 198, 198,-1  , 126, 127,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 214, 214,-1  , 126, 127,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 83 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 83 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  , 105, 106, 122,-1  ,-1  ,-1  , 124, 108, 109,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 210, 211,-1  ,-1  ,-1  ],
        [-1  ,-1  , 121, 122,-1  ,-1  , 123,-1  ,-1  , 124, 125,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,14  ,15  ,-1  ,14  ,15  ,-1  ,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,62  ,63  ,-1  ,46  ,47  ,-1  ,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,  12,-1  ,-1  ,  12,-1  ,-1  ,  45,-1  ,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,  28,-1  ,-1  ,  28,-1  ,-1  ,  44,-1  ,-1  ,-1  ,-1  , 165, 68 ,-1  , 68 , 165,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 53 , 53 , 53 , 53 , 53 , 53 , 53 , 53 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 182,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 69 , 69 , 69 , 69 , 69 , 69 , 69 , 69 ,-1  ,-1  , 148,-1  , 148,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 70 , 69 , 69 , 69 , 69 , 69 , 69 , 69 ,-1  ,-1  ,-1  , 148, 147, 100,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 86 , 85 , 85 , 85 , 85 , 85 , 85 , 85 ,-1  ,-1  , 147, 148,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 149,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  , 215, 216, 217,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  , 139, 139, 139,-1  ,  78,  79,   4,   5,-1  , 157, 158, 159,  55,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 128,-1  ,-1  ,-1  ,-1  ],
        [-1  , 140, 141, 180,-1  ,  94,  95,  20,  21,-1  , 173, 174, 175,  71,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 128,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  , 110, 111,  36,  37,-1  , 189, 190, 191,  87,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 160,-1  , 165],
        [-1  , 137, 138, 137,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 114, 115,-1  ,-1  ,-1  , 117,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 145, 146,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
    ];
    
    public static var uLayer:Array = 
    [
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 118, 119, 120,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 196, 197,-1  , 196, 197,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 192, 193, 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 208, 209, 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  , 178,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,  72,  56,  88,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,  72,  58,  75,  60,  88,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,  72,  58,  74,  75,  76,  60,  88,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 67 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,  57,  58,  74,  90,  91,  92,  76,  60,  61,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,  73,  74,  90, 106, 107, 108,  92,  76,  77,-1  , 186,-1  ,-1  , 52 ,-1  , 67 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],    
        [ 185,-1  ,  89,  90, 106, 122,-1  , 124, 108,  92,  93,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 194, 195,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  , 52 ,-1  , 52 ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 185,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 186,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 152, 184, 184, 184, 184, 184, 184, 184, 150,-1  , 151, 184, 153,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [ 168, 183, 183, 183, 183, 183, 183, 183, 166,-1  , 167, 183, 169,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 84 ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  , 199, 200, 201,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 131, 132, 133,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  , 129, 130,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ],
        [-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ,-1  ]
    ]
}
 
class Image
{
    public static const CHARACTER:int = 0;
    public static const MAP:int = 1;
}
    */
    public static const MAP:int = 1;
}