/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uhr5
 */

package
{
    import net.wonderfl.utils.SequentialLoader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    public class Main extends Sprite
    {
        private static const IMG_URL:String = "http://assets.wonderfl.net/images/related_images/d/dd/ddaf/ddaf70f0881616c4ce0bd9e4122b6d75aecc3745";
        private var imgs:Array;
        private var source:Bitmap;
        private var perlinBmpd:BitmapData;
        private var perlinBmp:Bitmap;
        private var seed:Number;
        private var offset:Array;
        private var sp:Shape;
        
        public function Main()
        {
            imgs=[];
            SequentialLoader.loadImages([IMG_URL], imgs, onLoaded);
        }
        
        public function onLoaded():void
        {
            // 画像の読み込み
            var ldr:Loader=imgs.pop();
            source = addChild(ldr.content) as Bitmap;  
            
            // 白いShapeを作成
            sp = addChild(new Shape) as Shape;
            sp.graphics.beginFill(0xffffff);
            sp.graphics.drawRect(0, 0, source.width, source.height);
            sp.cacheAsBitmap=true;
            
            // パーリンノイズ用
            perlinBmpd=new BitmapData(source.width, source.height, true, 0xFFFFFF);
            perlinBmp = addChild(new Bitmap(perlinBmpd)) as Bitmap;
            perlinBmp.cacheAsBitmap=true;
            seed=Math.floor(Math.random() * 10);
            offset=[new Point(0, 0), new Point(0, 0)];
            
            // マスクを適用
            sp.mask=perlinBmp;

            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // パーリンノイズ生成
        public function onFrame(e:Event):void
        {
            perlinBmpd.perlinNoise(source.width / 2, source.height / 2, 3, seed, false, true, BitmapDataChannel.ALPHA, false, offset);
            offset[0].x+=5;
            offset[1].y+=5;
        }
    }
}
