/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uhiS
 */

/*
 * BetweenAS3の基本3(加工)
 * 
 * 参考
 * http://www.be-interactive.org/?itemid=449
 * */
package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Cubic;
    import org.libspark.betweenas3.tweens.ITween;
    
    public class Main extends Sprite
    {
        
        public function Main()
        {
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            mouseUpHandler(null);
        }
        
        private function mouseUpHandler(e:MouseEvent):void
        {
            while (numChildren > 0) {
                removeChildAt(0);
            }
            addNewText(0, 0, "Click to replay");
            
            //◆Step0 通常 BetweenAS3.tween(box0, { x:400 }, null, 3, Cubic.easeOut)
            addNewText(50, 30, "◆0. BetweenAS3.tween(box0, { x:400 }, null, 3, Cubic.easeOut)");
            var box0:Sprite = addNewBox(50, 50, 0xFF0000);
            var t0:ITween = BetweenAS3.tween(box0, { x:400 }, null, 3, Cubic.easeOut);
            t0.play();
            
            //◆Step1 ディレイ1.5秒　BetweenAS3.delay(t1, 1.5)
            addNewText(50, 90, "◆1. ディレイ1.5秒　BetweenAS3.delay(t1, 1.5)");
            var box1:Sprite = addNewBox(50, 110, 0x00FF00);
            var t1:ITween = BetweenAS3.tween(box1, { x:400 }, null, 3, Cubic.easeOut);
            //ディレイ
            t1 = BetweenAS3.delay(t1, 1.5);
            t1.play();
            
            
            //◆Step2 逆再生　BetweenAS3.reverse(t2)
            addNewText(50, 150, "◆2. 逆再生　BetweenAS3.reverse(t2)");
            var box2:Sprite = addNewBox(50, 170, 0x0000FF);
            var t2:ITween = BetweenAS3.tween(box2, { x:400 }, null, 3, Cubic.easeOut);
            //逆再生
            t2 = BetweenAS3.reverse(t2);
            t2.play();
            
            
            //◆Step3 スライス0.3秒～1秒　BetweenAS3.slice(t3, 0.3, 1)
            addNewText(50, 210, "◆3. スライス0.3秒～1秒　BetweenAS3.slice(t3, 0.3, 1)");
            var box3:Sprite = addNewBox(50, 230, 0x000000);
            var t3:ITween = BetweenAS3.tween(box3, { x:400 }, null, 3, Cubic.easeOut);
            //スライス
            t3 = BetweenAS3.slice(t3, 0.3, 1);
            t3.play();
            
            
            //◆Step4 タイムスケール2.5倍　BetweenAS3.scale(t4, 2.5)
            addNewText(50, 270, "◆4. タイムスケール2.5倍　BetweenAS3.scale(t4, 2.5)");
            var box4:Sprite = addNewBox(50, 290, 0x009999);
            var t4:ITween = BetweenAS3.tween(box4, { x:400 }, null, 3, Cubic.easeOut);
            //スケール
            t4 = BetweenAS3.scale(t4, 2.5);
            t4.play();
            
            
            //◆Step5 リピート3回　BetweenAS3.repeat(t5, 3)
            addNewText(50, 330, "◆5. リピート3回　BetweenAS3.repeat(t5, 3)");
            var box5:Sprite = addNewBox(50, 350, 0x990099);
            var t5:ITween = BetweenAS3.tween(box5, { x:400 }, null, 3, Cubic.easeOut);
            //リピート
            t5 = BetweenAS3.repeat(t5, 3);
            t5.play();
            
            
            //◆Step6 永遠に繰り返す　t6.stopOnComplete = false
            addNewText(50, 390, "◆6. 永遠に繰り返す　t6.stopOnComplete = false");
            var box6:Sprite = addNewBox(50, 410, 0x999900);
            var t6:ITween = BetweenAS3.tween(box6, { x:400 }, null, 3, Cubic.easeOut);
            //終了しない
            t6.stopOnComplete = false;
            t6.play();
        }
        
        private function addNewBox(x:Number, y:Number, c:int):Sprite
        {
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(c);
            sp.graphics.drawRect( -10, -10, 20, 20);
            sp.graphics.endFill();
            sp.x = x;
            sp.y = y;
            addChild(sp);
            return sp;
        }
        
        private function addNewText(x:Number, y:Number, txt:String):TextField
        {
            var tf:TextField = new TextField();
            tf.text = txt;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.x = x;
            tf.y = y;
            addChild(tf);
            return tf;
        }
    }
}
