/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uhd2
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Bubbles extends Sprite {
        private var balls:Array;
        private var numBalls:Number = 10;
        private var centerBall:Ball;
        private var bounce:Number = -1;
        private var spring:Number = .1;
        
        public function Bubbles() {
            init();
        }
        
        private function init():void {
            balls = [];
            centerBall = new Ball(50, 0xcccccc);
            addChild(centerBall);
            centerBall.x = stage.stageWidth/2;
            centerBall.y = stage.stageHeight/2;
            
            for (var i:int = 0; i < numBalls; i++) {
                var ball:Ball = new Ball(Math.random()*40+5, Math.random() * 0xffffff + 0xff000000);
                ball.x = Math.random() * stage.width;
                ball.y = Math.random() * stage.height;
                ball.vx = Math.random() * 6 - 3;
                ball.vy = Math.random() * 6 - 3;
                addChild(ball);
                balls.push(ball);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);

        }
        
        private function onEnterFrame(e:Event):void {
            for (var i:int = 0; i < numBalls; i++) {
                var ball:Ball = balls[i] as Ball;
                move(ball);
                
                //collision detection
                var dx:Number = ball.x - centerBall.x;
                var dy:Number = ball.y - centerBall.y;
                var distance:Number = Math.sqrt(dx * dx + dy * dy);
                var minDist:Number = ball.radius + centerBall.radius;
                
                if (distance < minDist) {
                    var angle:Number = Math.atan2(dy,dx);
                    var tx:Number = centerBall.x + Math.cos(angle) * minDist;
                    var ty:Number = centerBall.y + Math.sin(angle) * minDist;
                    ball.vx += (tx - ball.x) * spring;
                    ball.vy += (ty - ball.y) * spring;
                }

            }

        }
        
        private function move(ball:Ball):void {
            ball.x += ball.vx;
            ball.y += ball.vy;
            if (ball.x + ball.radius > stage.stageWidth) {
                ball.x = stage.stageWidth - ball.radius;
                ball.vx *= bounce;
            } else if (ball.x - ball.radius < 0) {
                ball.x = ball.radius;
                ball.vx *= bounce;
            }

            if (ball.y + ball.radius > stage.stageHeight) {
                ball.y = stage.stageHeight - ball.radius;
                ball.vy *= bounce;
            } else if (ball.y - ball.radius < 0) {
                ball.y = ball.radius;
                ball.vy *= bounce;
            }



        }



    }
}




//ball class
import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;   
    public var isDragging:Boolean = false; 
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}