/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uhVO
 */

/**
 * MOUSE_MOVEの実験
 * @author エスケイ
 *
 * MOUSE_MOVEがいったいどのくらいの間隔でとれるのかの実験。
 *
 * ■分かったこと
 * ・15msか16msくらいでとれることが多い。(約60fps相当)
 * ・３回に一階くらい0msでとれてる。どういうことなの？検証方法間違ってる？1ms未満で取得できてるの？
 * ・取得頻度は実行FPSにはよらない。
 *
 *　■疑問
 * ・取得頻度はなにで決まってるの？どこかに仕様が書いてある？
 * ・0msで取得できるときはなにが起こってるの？
 * 
 */
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;
    public class FlashTest extends Sprite {
    		private var textField:TextField;
		private var currentTime:Number = 0;
    		private var lastTime:Number = 0;
    		private var stats:Stats;
        public function FlashTest() {
            // write as3 code here..
            
            textField = new TextField();
            textField.width = stage.stageWidth;
            textField.height = stage.stageHeight;
            textField.multiline = true;
            textField.selectable = false;
            textField.wordWrap = true;
            
            addChild(textField);
            
            //FPS変化チェック用
            stats = new Stats();
            stats.x = 400;
            addChild(stats);
            
            textField.text = 'Move your mouse!\n\n';
            lastTime = new Date().time;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, function(e:MouseEvent):void
            {
            		currentTime = new Date().time;
            		//textField.text = '';
            		textField.text = currentTime.toString() + ' / ' + lastTime.toString() + ' / ' + (currentTime-lastTime).toString() + '\nmouseX:' + mouseX.toString() + ',mouseY:' + mouseY.toString() + '\n\n' + textField.text;
            		lastTime = currentTime;
            });
        }
    }
}