/**
 * Copyright Rhinolu ( http://wonderfl.net/user/Rhinolu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uhKi
 */

package {
    import com.greensock.data.TweenMaxVars;
    import com.greensock.easing.Linear;
    import com.greensock.TweenMax;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite
    {
        public function FlashTest()
        {
            makeClip();
        }
        
        private function makeClip():void
	{
		for (var i:int = 0; i < 250; i++) 
		{
			var clip:Clip = new Clip();
			addChild(clip);
			clip.x = Math.random() * 550;
			clip.y = -10;
			var duration:Number = 2 + Math.random() * 2;
			var delay:Number = Math.random() * 2;
			TweenMax.to(clip, duration, new TweenMaxVars().prop("y",400).ease(Linear.easeNone).onComplete(onClipComplete, [clip]).delay(delay).vars);
		}
	}
		
	private function onClipComplete(clip:Clip):void 
	{
		clip.kill();
		removeChild(clip);
	}
    }
}

import flash.display.Shape;
import flash.events.Event;
	
class Clip extends Shape
{
		
	public function Clip() 
	{
        	graphics.beginFill(0x0000, 1);
		graphics.drawRect(0, 0, 5, 5);
		addEventListener(Event.ENTER_FRAME, onEnterFrame);
	}
		
	private function onEnterFrame(e:Event):void 
	{
		this.rotation = Math.random() * 360;
		this.scaleX = Math.random();
		this.scaleY = Math.random();
	}
		
	public function kill():void
	{
		removeEventListener(Event.ENTER_FRAME, onEnterFrame);
	}
}