/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ugsY
 */

// forked from yd_niku's flash on 2010-7-26
package {
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    import flash.events.*;
    import flash.text.*;
    [SWF(frameRate=60)]
    public class FlashTest extends Sprite {
        private var m:Matrix;
        
        private var _spped:Number = Math.PI/180*3;
        public function FlashTest() {
            m = new Matrix();
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void{
            m.rotate(_spped);
            m.translate(232,232);
            
            graphics.clear();
            drawPoint( m.transformPoint( new Point(0,0)), 0x40FF0000, 10 );
            drawPoint( m.transformPoint( new Point(200,0) ), 0x40FF0000, 10 );
            
            m.translate(-232,-232);
        }
        
        private function drawPoint(p:Point,c:uint,r:Number=2):void{
            var a:Number = ((c>>24)&0xFF) / 0xFF; 
            graphics.beginFill(c&0x00FFFFFF,a);
            graphics.drawCircle(p.x,p.y,r);
            graphics.endFill();
        }
    }
}

import flash.geom.Point;

import flash.external.*;

internal function log(msg:*):void{
    if( ExternalInterface.available ) ExternalInterface.call("console.log", msg );
}
class Matrix3x3{
    public var m11:Number;
    public var m12:Number;
    public var m13:Number;
    public var m21:Number;
    public var m22:Number;
    public var m23:Number;
    public var m31:Number;
    public var m32:Number;
    public var m33:Number;
    public function Matrix3x3(
        m11:Number=1, m12:Number=0, m13:Number=0,
        m21:Number=0, m22:Number=1, m23:Number=0,
        m31:Number=0, m32:Number=0, m33:Number=1 ) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }
    public function clone():Matrix3x3{
        return new Matrix3x3(m11,m12,m13,m21,m22,m23,m31,m32,m33);
    }
    
    public function add(m:Matrix3x3):void{
        m11 += m.m11;
        m12 += m.m12;
        m13 += m.m13;
        m21 += m.m21;
        m22 += m.m22;
        m23 += m.m23;
        m31 += m.m31;
        m32 += m.m32;
        m33 += m.m33;
    }
    public function sub(m:Matrix3x3):void{
        m11 -= m.m11;
        m12 -= m.m12;
        m13 -= m.m13;
        m21 -= m.m21;
        m22 -= m.m22;
        m23 -= m.m23;
        m31 -= m.m31;
        m32 -= m.m32;
        m33 -= m.m33;
    }
    public function multiply(b:Matrix3x3):void{
        var a:Matrix3x3 = clone();
        m11 = a.m11 * b.m11 + a.m12 * b.m21 + a.m13 * b.m31;
        m12 = a.m11 * b.m12 + a.m12 * b.m22 + a.m13 * b.m32;
        m13 = a.m11 * b.m13 + a.m12 * b.m23 + a.m13 * b.m33;
        m21 = a.m21 * b.m11 + a.m22 * b.m21 + a.m23 * b.m31;
        m22 = a.m21 * b.m12 + a.m22 * b.m22 + a.m23 * b.m32;
        m23 = a.m21 * b.m13 + a.m22 * b.m23 + a.m23 * b.m33;
        m31 = a.m31 * b.m11 + a.m32 * b.m21 + a.m33 * b.m31;
        m32 = a.m31 * b.m12 + a.m32 * b.m22 + a.m33 * b.m32;
        m33 = a.m31 * b.m13 + a.m32 * b.m23 + a.m33 * b.m33;
    }
    
    
    public function translate(vx:Number=0,vy:Number=0):void{
        m13 += vx;
        m23 += vy;
    }
    
    public function scale(sx:Number=1,sy:Number=1):void{
        m11 *= sx;
        m21 *= sy;
    }
    public function rotate(rad:Number):void {
        var c:Number = Math.cos(rad);
        var s:Number = Math.sin(rad);
        
        var m:Matrix3x3 = clone();
        m11 = c; m12 = -s; m13 = 0;
        m21 = s; m22 =  c; m23 = 0;
        m31 = 0; m32 =  0; m33 = 1;
        multiply(m);
    }
    
    
    public function deltaTransformPoint(p:Point):Point{
        var rp:Point = new Point();
        rp.x = p.x* m11 + p.y * m12;
        rp.y = p.x* m21 + p.y * m22; 
        return rp;
    }
    public function transformPoint(p:Point):Point{
        var rp:Point = new Point();
        rp.x = p.x* m11 + p.y * m12 + m13;
        rp.y = p.x* m21 + p.y * m22 + m23;
        return rp;
    }
}