/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uedD
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", bakcgroundColor="0", frameRate="60")]
    
    public class FlashTest extends Sprite {
        private const W:int = 465;
        private const H:int = 465;
        private const FREQUENCY_RANGE:int = 3;
        
        private var _particles:Array  = [];
        private var _startX:Number;
        private var _startY:Number;
        
        private var _canvas:BitmapData;
        private var _ct:ColorTransform;
         
        public function FlashTest() {
            _ct = new ColorTransform(0.93, 0.93, 0.93, 0.99);
            _canvas = new BitmapData(W, H, false, 0);
            var canvas:Bitmap = new Bitmap(_canvas, "auto", true);
            addChild(canvas);
            addEventListener(Event.ENTER_FRAME, update);            
        }
        
        private function createParticle():void {
            var p:Particle = new Particle();
            var radius:Number = Math.sqrt(Math.random()) * 5;
            var angle:Number = Math.random() * (Math.PI) * 2;
            _startX += (mouseX - _startX) * .01;
            _startY += (mouseY - _startY) * .01;
            p.x = _startX;
            p.y = _startY;
            p.vx = Math.cos(angle) * radius;
            p.vy = Math.sin(angle) * radius;
            _particles.push(p);
        }
        
        private function emitte():void
        {
            var n:int = Math.random() * 200 + 50;
            _startX = mouseX;
            _startY = mouseY;
            while(n--) createParticle();
        }
        
        private function update(e:Event):void
        {
            _canvas.lock();
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(4,4));
            _canvas.colorTransform(_canvas.rect, _ct);
            
            var n:int = _particles.length;
            while(n--) {
                var v:Number = Math.random() * 0.14 + 0.85;
                var p:Particle = _particles[n];
                var ranx:Number = Math.random() * 3 - 1.5;
                var rany:Number = Math.random() * 3 - 1.5;
                p.vx += ranx;
                p.vy += rany;
                p.vx *= v;
                p.vy *= v;
                p.x += p.vx;
                p.y += p.vy;
                _canvas.setPixel(p.x, p.y, p.c);
                
                if((p.x > W || p.x < 0) || (p.y < 0 || p.y > H) || Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01) {
                    _particles.splice(n, 1);
                }
            }
            _canvas.unlock();
            var frequency:Boolean = Boolean(int(Math.random() * FREQUENCY_RANGE));
            if(frequency == false) emitte();
        }
    }
}

import flash.geom.Point;

internal class Particle extends Point
{
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var c:uint = 0xffffff;
}
