/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ueRD
 */

// Mydy Gira - Vladimir Israel Ramírez Díaz - VLD
package 
{
    import flash.display.Sprite;
    
    [SWF(width="465", height="465", backgroundColor= 0x000000, frameRate="60")]
    
    public class Main
    extends Sprite
    {
        public function Main():void 
        {
            
            
            var cube:Cube = new Cube();
            cube.x = stage.stageWidth * 0.5;
            cube.y = stage.stageHeight * 0.5;
            addChild(cube);
            
        }
    }    
}
import flash.display.Sprite
import caurina.transitions.Tweener
import flash.utils.Timer;
import flash.events.TimerEvent;

class Cube
extends Sprite
{
    private var wordsContainer:Sprite;
    public function Cube():void 
    {
        wordsContainer = new Sprite;
        addChild(wordsContainer);
        
        var heart:Heart = new Heart;

        addChild(heart);
        
        rotCompleteHandler();
    }

    public function listen(word_:String):void 
    {
        var word:Words = new Words(word_, 180);
        wordsContainer.addChild(word);
        word.rotation = -rotation;

        var timer:Timer = new Timer(word_.length * 40 + 1200);
        timer.addEventListener(TimerEvent.TIMER, rotTimerHandler,false,0,false);
        timer.start();

        if(4 < wordsContainer.numChildren) wordsContainer.removeChildAt(0);
    }
    private function rotTimerHandler(evt:TimerEvent):void
    {
        evt.target.stop();
        Tweener.addTween(this, {
            rotation: rotation - 90,
            time: 2.8,
            transition: "easeOutBack",
            onComplete: rotCompleteHandler
        });
        
        if (3 < wordsContainer.numChildren)
        {
            Tweener.addTween(wordsContainer.getChildAt(0), {
                alpha: 0,
                scaleX: 0,
                scaleY: 0,
                time: 2.8,
                transition: "easeOutQuint"
            });
        }
    }
    public function rotCompleteHandler():void 
    {
        if (GLaDOS.isStillAlive()) listen(GLaDOS.Sings());
    }
}

class Heart
extends Sprite
{
    public function Heart():void 
    {
        var radius:Number = 10;
        graphics.beginFill(0x999999);
        graphics.drawCircle( 0, 0, radius*3); 
        graphics.endFill();
        
        graphics.beginFill(0xffccff);
        graphics.drawCircle( -radius*0.9, -radius*0.4, radius); 
        graphics.endFill();
        
        graphics.beginFill(0xffccff);
        graphics.drawCircle( radius*0.9, -radius*0.4, radius); 
        graphics.endFill();
        
        graphics.beginFill(0xffccff);
        graphics.moveTo(0, radius * 2);
        graphics.lineTo( -radius * 1.85, 0);
        graphics.lineTo(radius * 1.85, 0);
        graphics.endFill();
        
        scaleX = scaleY = 1.5;
//        heartScaleUp();
    }
    private var scaleUp:Number = 1.0;
    private var scaleDown:Number= 0.9;
    
    private function heartScaleUp():void 
    {
        Tweener.addTween(this, {
            scaleX: scaleUp,
            scaleY: scaleUp,
            time: 0.5,
            transition: "easeOutBack",
            onComplete: heartScaleDown
        });        
    }
    private function heartScaleDown():void 
    {
        Tweener.addTween(this, {
            scaleX: scaleDown,
            scaleY: scaleDown,
            time: 0.5,
            transition: "easeOutBack",
            onComplete: heartScaleUp
        });        
    }
}

import flash.text.TextField;
import flash.text.TextFormat;
import flash.geom.Rectangle;
class Words
extends Sprite
{
    private var wordsIdx:uint = 0;
    private var words:String;
    private var wordScale:Number;
    private var tfd:TextField;
    private var center:Number;
    public function Words(words_:String, center_:Number):void 
    {
        words = words_;
        center = center_;
        
        tfd = new TextField();
        tfd.defaultTextFormat = new TextFormat("Arial Black", 10);  
        tfd.textColor = 0xcc9900;  
        tfd.autoSize = "left"; 
        tfd.text = words;

        wordScale = (center * 2 -60) / tfd.width;

        var timer:Timer = new Timer(10);
        timer.addEventListener(TimerEvent.TIMER, timerHandler,false,0,false);
        timer.start();
    }
    private function timerHandler(evt:TimerEvent):void 
    {    
        if (wordsIdx >= words.length)
        {
            evt.target.stop();
            return;
        }
        
        var bounds:Rectangle = tfd.getCharBoundaries(wordsIdx);        
        var word:Word = new Word(words.charAt(wordsIdx));
        
        
        word.height = 60;
        word.scaleX = wordScale;
        word.x = word.y = -center;

        word.x += bounds.x * wordScale;
        addChild(word);
        
        word.y += 100;
        
        Tweener.addTween(word, {
            y: word.y - 100 - word.height * (1.0 + Math.random()*0.1),
            time: 0.5 + Math.random() * 0.05 + 0.01 * (words.length - wordsIdx),
            transition: "easeOutQuart",
            onComplete: jumpupCompleteHandler,
            onCompleteParams: [word]
        });
        
        wordsIdx++;
    }
    private function jumpupCompleteHandler(word:Word):void 
    {
        Tweener.addTween(word, {
            y: word.y + word.height * 1.0,
            time: 1.8 + Math.random() * 0.2,
            transition: "easeOutBounce"
        });
    }
}

import flash.display.BitmapData;
import flash.display.Bitmap;

class Word
extends Sprite
{
    public function Word(word:String):void 
    {
        var tfd:TextField = new TextField();
        tfd.defaultTextFormat = new TextFormat("Arial Black", 10);  
        tfd.textColor = 0xcc9900;  
        tfd.autoSize = "left"; 
        tfd.text = word;
        
        var bd:BitmapData = new BitmapData(tfd.width, tfd.height, true, 0xff0000); 
        bd.draw(tfd);
        addChild(new Bitmap(bd));
    }
}

class GLaDOS
{
    public static function isStillAlive():Boolean
    {
        return noteLine < notes.length;
    }
    public static function SingsTo(cube:Cube):void 
    {
//        cube.listen(notes[notes.length - 1 - noteLine++] );
        cube.listen(notes[noteLine++] );
    }
    public static function Sings():String
    {
        return notes[noteLine++];
    }
    
    private static var noteLine:uint = 0;
    private static var notes:Array = [

   

        "El tiempo es relativo",        
        "Mientras estoy recostado ",
        "entre mi sábanas descompuestas, estoy contigo,",
        "mientras miro en el espejo ",
        "mis ojos casi desvanecidos, estoy contigo. ",
        "Dejarme tocar  esas manos que recorrerán mi ser",
        "que tu piel se adhiera a la mía húmeda de sudor ",
        "Acariciar tu espalda, frotar tu pelo, enlazarme a ti,",
        "besarte con ternura traviesa.", 

        "Beber de tu energía, tus ganas, tu esencia.",
        "Te amaríaa placer, con alguna caricia .",
        "húmeda que te dijera -te estoy amando, te amo-.",
        "Bien podrías entender mi lenguaje y me observarías, ",
        "quizá en un acto de sobrevivencia tomarías ",
        "mi cabello en tus manos, obligándome a ver tu rostro ",
        "-observa, observa a quien devoras, recuérdame- ",



        "No sabe que mi mente ya es una extensión de ella.",
        "-No mi amor, mis ojos no te reconocerían " ,
        "en ese momento sagrado,",
        "sólo tu sabor en mi lengua lo haría.-",
        "quiero que ese ritmo,delicado y agitado,",
        "me posea y te posea a ti. "
        

    ];
}