/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ud4G
 */

//←↑→↓またはA、W、D、Sボタンで操作オブジェクトを移動させます
//←　→またはA、Dで方向決定、↑またはWで前進、↓またはSで後退
//VボタンでY軸に沿ってカメラ視点を変更　Vボタンを押し続けると元の視点に戻ります
//カメラが操作オブジェクトに合わせて移動、視点も操作オブジェクトに合わせます

//参考にしたサイト
//↓カメラ視点について参考にしたサイトです
//http://www.akibahideki.com/blog/flash-1/papervision-3d.html
//↓三角関数について参考にしたサイトです
//http://www.procreo.jp/tutorial03.html

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
 
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
 
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#111111")]
 
    public class MoviePaperPlane extends Sprite
    {
        private var container    : Sprite;
        private var viewport     : Viewport3D;
        private var scene        : Scene3D;
        private var camera       : Camera3D;
        private var wireFramMate : WireframeMaterial;
        private var planeObj     : Plane;
        private var playerObj    : PaperPlane;
        private var renderer     : BasicRenderEngine;

        private var planeSize : int = 2000;//Planeオブジェクト1辺の長さ

        //MoviePaperPlaneクラスのコンストラクタ
        public function MoviePaperPlane():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(stage.stageWidth, stage.stageHeight);
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //Planeオブジェクト用ワイヤーフレームマテリアル設定
            wireFramMate = new WireframeMaterial(0xFF0000);

            //Planeオブジェクト生成
            planeObj= new Plane(wireFramMate, planeSize, planeSize, 4, 4);
            planeObj.rotationX = 90;
            scene.addChild(planeObj);
            
            //PaperPlaneオブジェクト生成
            playerObj= new PaperPlane(null,1);
            playerObj.z = -300;
            scene.addChild(playerObj);
            
            //カメラ設定
            camera = new Camera3D();
            camera.y = 200;
            camera.target = DisplayObject3D.ZERO;    
             
            //イベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        //フレーム毎の処理
        private function onEnterFrame(e:Event):void{
            renderer.renderScene(scene, camera, viewport);
        }
        
        //カメラ視点設定
        private function setCamera():void{
            camera.x=-300*Math.cos((90-playerObj.rotationY)*Math.PI/180)+playerObj.x;  
            camera.z=-300*Math.sin((90-playerObj.rotationY)*Math.PI/180)+playerObj.z;  
            camera.target.x=playerObj.x;
            camera.target.y=playerObj.y;
            camera.target.z=playerObj.z;
        }
        
        //キーボード入力処理
        //←↑→↓、A、W、D、Sボタン押下時処理(操作オブジェクト移動処理)
        //Vボタン押下時処理(カメラ視点変更処理)
        private function onKeyDown(event:KeyboardEvent):void{
            //←ボタンまたはAボタン 左回転     
            if ((event.keyCode == 37) || (event.keyCode == 65)) {
                playerObj.rotationY -= 5;
            //→ボタンまたはDボタン 右回転
            } else if ((event.keyCode == 39) || (event.keyCode == 68)) {
                playerObj.rotationY += 5;
            //↑ボタンまたはWボタン 前進
            } else if ((event.keyCode == 38) || (event.keyCode == 87)) {
                playerObj.moveForward(10); 
            //↓ボタンまたはSボタン 後退
            } else if ((event.keyCode == 40) || (event.keyCode == 83)) {
                playerObj.moveBackward(5);
            //Vボタン　カメラY軸座標視点変更
            } else if (event.keyCode == 86) {
                camera.y += 100;
                if (camera.y > 400) {camera.y = 100;}
            } 
            //カメラ視点設定            
            setCamera();
        }
    }
}
