/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ucvA
 */

// forked from miyaoka's JuliaAnimation
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import caurina.transitions.Tweener;

	

	[SWF(width="465", height="465", backgroundColor= 0xffffff, frameRate="30")]
	public class Julia2
	extends Sprite
	{
		private var colors:Array;
		private var bd:BitmapData;
		private var transitions:Array = ["easeInOutBack", "easeOutCubic", "easeInCubic" ];
		
		private var rMin:Number;
		private var rMax:Number;
		private var iMin:Number;
		private var iMax:Number;
		public var rVal:Number;
		public var iVal:Number;
		private var count:Number;
		private var level:Number;
		
		public function Julia2():void 
		{
			bd = new BitmapData(150, 150);
			var bmp:Bitmap = new Bitmap(bd);
			bmp.smoothing = true;
			addChild(bmp);
			bmp.width = bmp.height = 465;		
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			initJulia();
		}
		private function mouseDownHandler(e:MouseEvent):void 
		{
			initJulia();
		}
		private function initJulia():void 
		{
			rMin = Math.random() * -2 - 0.2;
			iMin = Math.random() * -2 - 0.2;
			rMax = Math.random() * 2 + 0.2;
			iMax = Math.random() * 2 + 0.2;
			rVal = Math.random() * (rMax - rMin)  + rMin;
			iVal = Math.random() * (iMax - iMin)  + iMin;
			count = Math.random() * 50 + 5;
			level = Math.random() * 10 +1;
			
			colors = new Array();
			var colorsLen:int = Math.random() * 10 + 2;
			while(0<colorsLen--)
			{
				colors.push(Math.random() * 0xFFFFFF);
			}
			Tweener.addTween(this, {
				rVal: Math.random() * (rMax - rMin)  + rMin,
				iVal: Math.random() * (iMax - iMin)  + iMin,
				time: 0.5 + Math.random()*2,
				transition: transitions[Math.floor(Math.random()* transitions.length)],
				onUpdate: updateTweenHandler,
				onComplete: contiJulia
			});
		}
		private function contiJulia():void 
		{
			Tweener.addTween(this, {
				rVal: Math.random() * (rMax - rMin)  + rMin,
				iVal: Math.random() * (iMax - iMin)  + iMin,
				time: 0.5 + Math.random()*2,
				transition: transitions[Math.floor(Math.random()* transitions.length)],
				onUpdate: updateTweenHandler,
				onComplete: contiJulia
			});
		}
		private function updateTweenHandler():void 
		{
			drawJulia(rVal, iVal);				
		}
	
		public function drawJulia(a_rval:Number, a_ival:Number):void 
		{
			var r:Number;
			var i:Number;
			var rF:Number;
			var iF:Number;
			var rd:Number = (rMax - rMin) / bd.width;
			var id:Number = (iMax - iMin) / bd.height;
			
			bd.fillRect(new Rectangle(0, 0, bd.width, bd.height), 0xFF000000 );// + Math.random() * 0xFFFFFF);
			for (var x_:int = 0; x_ < bd.width; x_++)
			{
				for (var y_:int = 0; y_ < bd.height; y_++)
				{
					r = rMin + rd * x_;
					i = iMax - id * y_;
					for (var j:int = 0; j < count; j++)
					{
						rF = r * r - i * i + a_rval;
						iF = 2 * r * i  + a_ival;
						if (rF * rF + iF * iF > level) 
						{
							bd.setPixel(x_, y_, colors[j % colors.length] );
							break;
						}
						r = rF;
						i = iF;
					}
				}
			}
		}
	}
}