/**
 * Copyright _ryotaros ( http://wonderfl.net/user/_ryotaros )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ucrc
 */

// forked from _ryotaros's Basic Segment
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        
        public var ball:Ball;
        public var segs:Array;
        public var segNum:int = 5;
        
        public var gravity:Number = 0.5;
        
        public function FlashTest() {
            init();
        }
       
        public function init():void {
        		segs = [];
        		for (var i:int = 0;i <segNum;i++){
	        		var segment:Segment = new Segment(50,20);
	        		addChild(segment);
	        		segs.push(segment);
        		}
        		segment.x =stage.stageWidth/2;
	        	segment.y =stage.stageHeight/2;   		
        		
        		ball = new Ball(30);
        		addChild(ball);
        		
        		addEventListener(Event.ENTER_FRAME, onenterframe);
        }
        
        public function onenterframe(e:Event):void {
        		
        		move();	
        		
	        var target:Point = reach(segs[0],ball.x, ball.y);
	        	for (var i:int = 1;i<segNum;i++){
	        		target = reach(segs[i],target.x,target.y);	
	        	}
	        	for (i = segNum -1; i > 0; i--){
	        		 setPosition(segs[i-1],segs[i]);
	        	}
        	 	
        }
        
        public function move():void{
        		ball.vy += gravity;
        		ball.x += ball.vx;
        		ball.y += ball.vy;
        		screnWrap();
        }
        
        public function screnWrap():void{
        		if (ball.y + ball.height/2 > stage.stageHeight){
        			ball.x = stage.stageWidth *Math.random();
        			ball.y = -ball.height / 2;
        			ball.vx = 0;
        			ball.vy = 5;
        		}
        }
        
        public function reach(seg:Segment,xPos:Number, yPos:Number):Point{
        		var dx:Number = xPos - seg.x;
        		var dy:Number  = yPos - seg.y;
        		var angle:Number = Math.atan2(dy,dx);
        		seg.rotation = angle * 180 / Math.PI;
        		
        		var w:Number = seg.getPin().x - seg.x;
        		var h:Number = seg.getPin().y - seg.y;
        		var tx:Number = xPos- w;
        		var ty:Number = yPos - h;
        		return new Point(tx,ty);
        }
        
        public function setPosition(segA:Segment, segB:Segment):void{
        		segA.x = segB.getPin().x;
        		segA.y = segB.getPin().y;
        }
    }
}
import flash.display.Sprite;
import flash.geom.Point;

class Segment extends Sprite {
		
		public var segmentWidth:int;
		public var segmentHeight:int;
		public var segmentColor:int;
		
		public var vx:Number = 0;
		public var vy:Number = 0;
	
		public function Segment(sWidth:int=10,sHeight:int=10,color:uint=0xff0000):void{
			segmentWidth = sWidth;
			segmentHeight = sHeight;
			segmentColor = color;
			init();	
		}
		
		public function init():void{
			
			graphics.lineStyle(0);
			graphics.beginFill(segmentColor);
			graphics.drawRoundRect(-segmentHeight / 2, -segmentHeight /2, segmentWidth + segmentHeight, segmentHeight, segmentHeight, segmentHeight);
			graphics.endFill();
			
			graphics.drawCircle(0, 0, 2);
			graphics.drawCircle(segmentWidth, 0, 2);
		}
		
		public function getPin():Point {
			var angle:Number = rotation * Math.PI / 180;
			var xPos:Number = x + Math.cos(angle) * segmentWidth;
			var yPos:Number = y + Math.sin(angle) * segmentWidth;
			return new Point(xPos, yPos);
		}
}

class Ball extends Sprite {
	
	public var vx:Number = 2;
	public var vy:Number = 2;
	
	public function 	Ball(r:int=10,color:uint=0xffff00){
		graphics.lineStyle(0);
		graphics.beginFill(color);
		graphics.drawCircle(0,0,r);
		graphics.endFill();
	}
}