/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uc2F
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
   
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class FlashTest3d10 extends Sprite
    {
		private const MAX_SP:int = 50;
		private const SHAPE_SIZE:Number = 20;
		private const LINE_SIZE:Number = 8;
		
        private var sp_list:Array = [];
        private var flag:Boolean = true;
        private var mode:int = 0;
        private var buffer:BitmapData = new BitmapData(465, 465, false, 0x000000);
        private var screen:Bitmap = new Bitmap(buffer);
        private var count:int = 0;
       
        public function FlashTest3d10()
        {
			var width:Number = MAX_SP * 200;
			for (var i:int = 0; i < MAX_SP; i++) {
				sp_list.push(new Line(i * 400 - width, i, MAX_SP));
			}
			
            addChild(screen);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
       
        private function onEnterFrame(e:Event):void
        {
			var shape:Shape = new Shape();
            var tmp_line_size:Number;
            var tmp_shape_size:Number;
			var tmp_shape_size_half:Number;
			var tmp_shape_center:Number;
			var tmp_x:Number;
			var tmp_y:Number;
			var tmp_scale:Number;
			
			for (var i:int = 0; i < MAX_SP; i++) {
				for (var n:int = 0; n < MAX_SP; n++) {
					sp_list[i].list[n].setPosition(stage.mouseX, stage.mouseY);
					tmp_scale = sp_list[i].list[n].scale;
					tmp_x = sp_list[i].list[n].x;
					tmp_y = sp_list[i].list[n].y;
					
					tmp_line_size = LINE_SIZE * tmp_scale;
					tmp_shape_size = SHAPE_SIZE * tmp_scale;
					
					if (tmp_line_size < 0.01 || tmp_shape_size < 0.01) {
						continue;
					}
					
					tmp_shape_size_half = tmp_shape_size * 0.5;
					tmp_shape_center = tmp_shape_size * 0.5 + tmp_line_size * 0.5;
					
					shape.graphics.lineStyle(tmp_line_size, 0x66ff66, 0.8, false, "normal", CapsStyle.SQUARE);
					shape.graphics.moveTo(tmp_x, tmp_y - tmp_shape_size_half);
					shape.graphics.lineTo(tmp_x, tmp_y + tmp_shape_size_half);
					shape.graphics.moveTo(tmp_x - tmp_shape_size_half, tmp_y);
					shape.graphics.lineTo(tmp_x + tmp_shape_size_half, tmp_y);
				}
			}
			
			var tmp_max:int = MAX_SP - 1;
			
			for (i = 0; i < tmp_max; i++) {
				for (n = 0; n < tmp_max; n++) {
					shape.graphics.lineStyle(1, 0x66ff66, 0.8, false, "normal", CapsStyle.SQUARE);
					shape.graphics.beginFill(0x66ff66, 0.3);
					shape.graphics.moveTo(sp_list[i].list[n].x, sp_list[i].list[n].y);
					shape.graphics.lineTo(sp_list[i + 1].list[n].x, sp_list[i + 1].list[n].y);
					shape.graphics.lineTo(sp_list[i + 1].list[n + 1].x, sp_list[i + 1].list[n + 1].y);
					shape.graphics.lineTo(sp_list[i].list[n + 1].x, sp_list[i].list[n + 1].y);
					shape.graphics.lineTo(sp_list[i].list[n].x, sp_list[i].list[n].y);
				}
			}

            buffer.colorTransform(buffer.rect, new ColorTransform(0, 0, 0, 0, 0, 0, 0, 0));
			buffer.draw(shape);
        }
    }
}

import flash.display.*;
const T_RAD:Number = Math.PI / 180;
const FL:Number = 100;
const INTERVAL:Number = 100;
const CENTER_X:Number = 232.5;
const CENTER_Y:Number = 232.5;

class Plus
{
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var init_x:Number;
    public var init_y:Number;
    public var scale:Number;
	public var num:int;
	public var line_num:int;
	public var count:int = 0;
    
    public function Plus(count:int, x:Number, line_num:int) 
    {
        this.init_x = x; 
        this.init_y = CENTER_Y * 0.5;
        this.z = count * INTERVAL;
		this.num = count;
		this.line_num = line_num * 30;
    }
    
    public function setPosition(x:Number, y:Number):void
    {
        var scale:Number = FL / (FL + this.z);
    
		this.init_y = Math.sin(T_RAD * ((this.num) * 30 + this.count * 2 + this.line_num)) * 100;
		
		this.x = (this.init_x + (CENTER_X - x) * 30) * scale + CENTER_X;
        this.y = (this.init_y + (CENTER_Y - y) * 30) * scale + CENTER_Y;
        this.scale = scale;
		this.count++;
    }
}

class Line
{
	public var list:Array = [];
	
	public function Line(x:Number, num:int, max:int)
	{
		for (var i:int = 0; i < max ; i++) {
			list.push(new Plus(i, x, num));
			list.sortOn("z", Array.DESCENDING | Array.NUMERIC);
		}
	}
}