/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ubtO
 */

// forked from gaina's soundtest18
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    /**
     * ...
     * @author gaina
     */
    
    [SWF(width=465,height=465,backgroundColor=0)]
    public class Main extends Sprite 
    {
        private var _sound:Sound;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            graphics.beginFill(0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            var _context:SoundLoaderContext  = new SoundLoaderContext(1000, true);
            _sound = new Sound();
            _sound.load(new URLRequest("http://www.takasumi-nagai.com/soundfiles/sound006.mp3"), _context);
            _sound.addEventListener(Event.COMPLETE, SoundComplete);
        }
        
        private function SoundComplete(e:Event):void 
        {
            _sound.play(0, 100, new SoundTransform(0.8));
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private var _array:Array = [];
        
        private function loop(e:Event):void
        {
            var _bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytes, false, 1);
            var _scale:Number = 0;
            for (var i:int = 0; i < 512; i++) {
                var _x:Number = stage.stageWidth / 512 * i;
                var _read:Number = _bytes.readFloat();
                if (_read > 0.5) {
                    var p:Particles = new Particles();
                    p.x = _x;
                    stage.addChild(p);
                    _array.push(p);
                    _scale += _read
                }
            }
            
            _scale = Math.max(1, _scale / 3);
            
            if (_array.length > 0) {
                for (var j:int = 0; j < _array.length; j++) {
                    var _p:Particles = _array[j] as Particles;
                    _p.step();
                    
                    //_p.scaleY = _p.scaleX = _scale;
                    _p.scaleY = _scale;
                    
                    if (_p.y > stage.stageHeight - 10) {
                        _p.eraze();
                        _p = null;
                        stage.removeChild(_array[j] as Particles);
                        _array.splice(j, 1);
                        j--;
                    }
                }
            }
        }
    }   
}

import flash.display.Sprite;
class Particles extends Sprite
{
    public var vx:Number = 1;
    public var vy:Number = 1;
    public function Particles(color:uint=0xFFFFFF)
    {
        //graphics.lineStyle(1, 0, 1);
        graphics.beginFill(color, 1);
        //graphics.drawCircle(0, 0, 2);
        graphics.drawRect( -1, -1, 2, 2);
        graphics.endFill();
    }
    
    public function step():void 
    {
        this.y +=  vy;
        vy += 0.5;
        if (vy % 10 ==0) {
            vy = 1;
        }
    }
    
    public function eraze():void
    {
        graphics.clear();
    }
}