/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ubfY
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.PixelSnapping;
    import flash.display.BlendMode;
    import flash.geom.Matrix;
    import flash.events.Event;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.effects.*;
    
    [SEF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var sw:uint = 465;
        private var sh:uint = 465;
        private var cx:uint = 232;
        private var cy:uint = 232;
        private static var cameraHeight:Number = 300;
        private static var radius:uint = 300;
        private var effect:BitmapEffectLayer;
        private var pixels:Pixels;
        private var bitmapData:BitmapData;
        private var matrix:Matrix;
        private static var bw:uint = 465;
        private static var bh:uint = 465;
        private static var scale:Number = 16;
        private var angle:Number = 90;
        private var map:Map;
        private var loader:PhotoLoader;
        private static var basePath:String = "http://assets/wonderfl.net/images/rlated_images/";
        private static var mapPath:String = "1/1b/1bf4/1bf4e977d87d173178432a1d655a7ff904414400";
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var wonderflcolor:WonderflColor = new WonderflColor(465, 465);
            addChild(wonderflcolor);
            scene = new Scene3D();
            viewport = new Viewport3D(0, 0, true, false);
            camera = new Camera3D();
            renderer = new BasicRenderEngine();
            setup();
            initialize();
            addChild(viewport);
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);            
        }
        private function setup():void {
            viewport.interactive = true;
            camera.x = 0;
            camera.y = cameraHeight;
            camera.z = - radius;
            camera.zoom = 25;
            camera.focus = 20;
            camera.target = DisplayObject3D.ZERO;
        }
        private function initialize():void {
            setEffect();
            map = new Map(pixels);
            loader = new PhotoLoader();
            loader.addEventListener(Event.INIT, complete, false, 0, true);
            loader.load(basePath + mapPath, true);
        }
        private function complete(evt:Event):void {
            var bitmap:Bitmap = Bitmap(loader.content);
            map.setup(bitmap.bitmapData);
        }
        private function setEffect():void {
            effect = new BitmapEffectLayer(viewport, bw, bh);
            effect.addEffect(new BitmapColorEffect(1, 1, 1, 0.6));
            viewport.containerSprite.addLayer(effect);
            pixels = new Pixels(effect);
            scene.addChild(pixels);
            bitmapData = new BitmapData(bw/scale, bh/scale, false, 0xff000000);
            var bitmap:Bitmap = new Bitmap(bitmapData, PixelSnapping.NEVER, true);
            bitmap.scaleX = bitmap.scaleY = scale;
            bitmap.blendMode = BlendMode.ADD;
            addChild(bitmap);
            matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
        }
        private function render(evt:Event):void {
            sparkle();
            angle++;
            camera.x = Math.cos(angle * Math.PI/180)*radius;
            camera.y = cameraHeight;
            camera.z = Math.sin(angle*Math.PI/180)*radius;
            renderer.renderScene(scene, camera, viewport);
        }
        private function sparkle():void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0xff000000);
            bitmapData.draw(viewport, matrix);
            bitmapData.unlock();
        }
    }
}

import flash.display.BitmapData;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.*;
import frocessing.color.ColorHSV;

class Map {
    private var detection:DetectPixels;
    private static var accuracy:uint = 2;
    private var threshold:uint = 0xff808080;
    private var pixels:Pixels;
    private static var sw:uint = 400;
    private static var sh:uint = 200;
    private static var colors:Array;
    private var layers:Array;
    
    public function Map(p:Pixels) {
        pixels = p;
        init();
    }
    
    private function init():void {
        detection = new DetectPixels(accuracy);
    }
    
    public function setup(bitmapData:BitmapData):void {
        detection.search(bitmapData, bitmapData.rect, threshold);
        var map:Array = detection.pixels();
        
        layers = [map, map, map];
        
        var hsv:ColorHSV = new ColorHSV(50, 1);
        for(var n:uint=0; n<layers.length; n++) {
            hsv.h = 180 + 20 / layers.length * (layers.length - n);
            hsv.s = 1 / layers.length * (layers.length - n);
            var color:uint = 0xFF << 24 | hsv.value;
            drawLayer(n, color);
        }
    }
    private function drawLayer(id:uint, color:uint):void {
        var map:Array = layers[id];
        for(var n:uint=0; n<map.length; n++) {
            var dx:Number = sw/2 - map[n].x;
            var dy:Number = 8*id - 8*uint(layers.length/2);
            var dz:Number = map[n].y - sh/2;
            pixels.addPixel3D(new Pixel3D(color, dx, dy, dz));
        }
    }
}

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80ffffff;
    
    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }
    
    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80ffffff):void {
        bd = t;
        rect = r;
        threshold = th;
        var w:uint = rect.width / accuracy;
        var h:uint = rect.height / accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for(var x:uint=0; x < w; x++) {
            for(var y:uint=0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if(color >= threshold) {
                    var px:int = x*accuracy + rect.x;
                    var py:int = y*accuracy + rect.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }
}

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.display.Bitmap;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;
    
    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }
    
    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch(err:Error) {
            trace(err.message);
        }
    }
    
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if(smoothing) content.smoothing = true;
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }
}

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class WonderflColor extends Sprite {
    private var color1:uint = 0x00aae4;
    private var color2:uint = 0x0069a0;
    
    public function WonderflColor(w:uint, h:uint) {
        draw(w, h);
    }
    
    private function draw(w:uint, h:uint):void {
        var colors:Array = [color1, color2];
        var alphas:Array = [1, 1];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*1.5, h*1.5, -w*0.25, -h*0.25);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawRect(0, 0, w, h);
        graphics.endFill();
    }


}


