/**
 * Copyright nhubben ( http://wonderfl.net/user/nhubben )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ubdY
 */

package {
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.*;
    import flash.events.Event;
    
    public class Arrow3D extends Sprite {
        
        private var w:int = 200;
        private var h:int = 300;
        private var d:int = 50;
        private var _arrow:Sprite = new Sprite();
        private var _inner:Sprite = new Sprite();                
        private var _outer:Sprite = new Sprite();               
                        
        public function Arrow3D() {
            
            addChild( _outer );
            _outer.x = stage.stageWidth*.5;
            _outer.y = stage.stageHeight * .8;
            _outer.addChild( _inner );
            
            
            var top:Shape = new Shape();
            arrowShape( top.graphics );
            top.y = -h*.5
             
            var bottom:Shape = new Shape();
            arrowShape( bottom.graphics, 0x222222 );
            bottom.y = -h*.5;
            bottom.z = d * 3; 
            bottom.alpha = .5;
            bottom.filters = [ new BlurFilter(40, 40, 2 )];
            
            var midCap:Shape = new Shape();
            with( midCap.graphics ){
                clear();
                beginFill( 0xaa0000 );
                drawRect( -w, 0, w*2, d );
                endFill();
            }
            midCap.rotationX = 90;
            midCap.y = 0;
            
            var botCap:Shape = new Shape();
            with( botCap.graphics ){
                clear();
                beginFill( 0xaa0000 );
                drawRect( -w*.5, 0, w, d );
                endFill();
            }
            botCap.rotationX = 90;
            botCap.y = h*.5
            
            var rightCap:Shape = new Shape();
            with( rightCap.graphics ){
                clear();
                beginFill( 0xaa0000 );
                drawRect( 0,0,d,h*.5);
                endFill();
            }
            rightCap.x = w*.5;
            rightCap.rotationY = -90;
            
            var leftCap:Shape = new Shape();
            with( leftCap.graphics ){
                clear();
                beginFill( 0xaa0000 );
                drawRect( 0,0,d,h*.5);
                endFill();
            }
            leftCap.x = -w*.5;
            leftCap.rotationY = -90;
            
             
            _arrow.addChild( bottom );
            _arrow.addChild( midCap );
            _arrow.addChild( rightCap );
            _arrow.addChild( leftCap );
            _arrow.addChild( botCap );
            _arrow.addChild( top );
 
            _arrow.y = -stage.stageHeight*1.25;
            _inner.addChild( _arrow );
             
            _outer.rotationX = -50;
        
            root.transform.perspectiveProjection.projectionCenter = 
                new Point( stage.stageWidth*.5, _outer.y );
     
            addEventListener( Event.ENTER_FRAME, render );
        }
        
        private var rotDir:int = 1;
        private var distDir:int = 1;
        private function render( e:Event ):void{
             
            if( Math.abs(_inner.rotation) > 40 ) rotDir *= -1;
            _inner.rotation += rotDir;
            
            //if( _arrow.y < -(stage.stageHeight+200) || _arrow.y > -stage.stageHeight*.2){
                //distDir *= -1;
            //}
            //_arrow.y += distDir;
        } 

        
        
        public function arrowShape(g:Graphics, clr:uint = 0xFF3300 ):void{
            with(g){
                clear();
                beginFill( clr );
                lineTo( w, h*.5);
                lineTo( w*.5, h*.5);
                lineTo( w*.5, h);
                lineTo( -w*.5, h);
                lineTo( -w*.5, h*.5);
                lineTo( -w, h*.5);
                endFill();
            }
        }
            
            
            


    }
}