/**
 * Copyright toastie ( http://wonderfl.net/user/toastie )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ub8g
 */

// forked from scarybug's forked from: flash on 2009-12-3
// forked from toastie's flash on 2009-12-3
// TIGSource collaborative game expriment #1

package {
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    
     [SWF(width=465, height=465, frameRate=60)]
    public class FlashTest extends Sprite {
        
        private var player:Sprite;
        private var enemies:Array;
        private var inputArray:Array;
        
        public function FlashTest() {
             initInput();
             initGame();  
        }
        
        private function initInput() : void {
            
            inputArray = new Array();
            for(var i:uint =0;i < 256; i++) {
                 inputArray.push(false);   
            }
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
            this.addEventListener(Event.ENTER_FRAME, updateGame);
        }
        
        public function onKeyDown(e:KeyboardEvent) : void {
            inputArray[e.keyCode] = true;        
        }

        public  function onKeyUp(e:KeyboardEvent) : void {
            inputArray[e.keyCode] = false;        
        }
        
        public  function updateGame(e:Event) : void {
            
            updateEnemies();
            
            if(inputArray[37]) {
                   player.rotation -= 4;
            }

            if(inputArray[39]) {
                   player.rotation += 4;
            }       
            
           if(inputArray[38]) {
                   player.x -= Math.sin(Math.PI -player.rotation*0.0174532925);
                   player.y -= Math.cos(Math.PI -player.rotation*0.0174532925);                   
            }        
            
            //go backwards
            if(inputArray[40]) {
                   player.x += Math.sin(Math.PI -player.rotation*0.0174532925);
                   player.y += Math.cos(Math.PI -player.rotation*0.0174532925);                   
            }          
                 
        }
        
        private function updateEnemies() : void {
            for(var i:uint=0; i < enemies.length; i++) {
                   enemies[i].x -= Math.sin(Math.PI -enemies[i].rotation*0.0174532925);
                   enemies[i].y -= Math.cos(Math.PI -enemies[i].rotation*0.0174532925);                                   
                   
                   if(enemies[i].y > 470)
                       enemies[i].y = -10;
                       
                   if(enemies[i].y < -10)
                       enemies[i].y = 470;

                   if(enemies[i].x > 470)
                       enemies[i].x = -10;
                       
                   if(enemies[i].x < -10)
                       enemies[i].x = 470;
                       
            }    
        }
        
        private function initGame() : void {
           player = cratePlayerGraphic();
            addChild(player);
            
            player.x = 465/2;
            player.y = 465/2;
            player.rotation = 180;
            
            enemies = new Array();
            for(var i:uint=0; i < 30; i++) {
                var newEnemy:Sprite = createEnemyGraphic();
                enemies.push(newEnemy);
                addChild(newEnemy);
                newEnemy.x = Math.random() * 465;
                newEnemy.y = Math.random() * 465;    
                newEnemy.rotation = Math.random() * 360;            
            }           
        }
        
        private function cratePlayerGraphic() : Sprite {
            var retSprite:Sprite = new Sprite();
            retSprite.graphics.beginFill(0x00ff00);
            retSprite.graphics.drawCircle(0,0,10);           
            retSprite.graphics.endFill();   
              
           retSprite.graphics.beginFill(0x0000ff);
            retSprite.graphics.drawRect(-1,0,2,10);           
            retSprite.graphics.endFill();               
                   
            return retSprite;
        }
        
        private function createEnemyGraphic() : Sprite {
            var retSprite:Sprite = new Sprite();
            retSprite.graphics.beginFill(0xff0000);
            retSprite.graphics.drawCircle(0,0,15);           
            retSprite.graphics.endFill();    
            
              retSprite.graphics.beginFill(0x0000ff);
            retSprite.graphics.drawRect(-1,0,2,10);           
            retSprite.graphics.endFill();              
                    
            return retSprite;
        }        
    }
}