/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uaLj
 */

// forked from yprops's DebugText
package {
    import flash.events.Event;
    import flash.display.*;
    import flash.text.*;
    import flash.utils.getTimer;
    public class DebugText extends Sprite {
        
        private const LOOP :int = 100000;
        private var p :int;
        
        public function DebugText() {
            stage.frameRate = 60;
            addDeb(450, 450);
            addDebLine("Arrayの処理時間計測\n");
            addEventListener(Event.ENTER_FRAME, measure);
        }
        
        private function measure(ev:Event) :void{
            switch(p++){
                case 0 :
                    measureA();
                    break;
                case 1 :
                    measureB();
                    break;
                case 2 :
                    measureC();
                    break;
                case 3 :
                    measureD();
                    break;
                case 4 :
                    measureA();
                    break;
                case 5 :
                    measureB();
                    break;
                case 6 :
                    measureC();
                    break;
                case 7 :
                    measureD();
                    break;
                default :
                    addDebLine("\nfin");
                    removeEventListener(Event.ENTER_FRAME, measure);
                    break;
            }
        }
        //push()で格納
        private function measureA() :void{
            //前半いらないけど環境そろえてみた。
            var pts :Array = [];
            for(var i :int = 0; i < LOOP; i++){
                pts.push(i);
            }
            var t :int = getTimer();
            var ar :Array = [];
            for(var j :int = 0; j < LOOP; j++){
                ar.push(j);
            }
            result("push()で順に格納", t);
        }
        //ar[i]で格納
        private function measureB() :void{
            //前半いらないけど環境そろえてみた。
            var pts :Array = [];
            for(var i :int = 0; i < LOOP; i++){
                pts.push(i);
            }
            var t :int = getTimer();
            var ar :Array = [];
            for(var j :int = 0; j < LOOP; j++){
                ar[j] = j;
            }
            result("ar[j]で順に格納", t);
        }
        //順に格納
        private function measureC() :void{
            var pts :Array = [];
            for(var i :int = 0; i < LOOP; i++){
                pts.push(i);
            }
            var t :int = getTimer();
            var ar :Array = [];
            for(var j :int = 0; j < LOOP; j++){
                ar[pts[i]] = i;
            }
            result("ar[pts[j]]で順に格納", t);
        }
        //ランダムに格納
        private function measureD() :void{
            var pts :Array = [];
            for(var i :int = 0; i < LOOP; i++){
                pts.push(int(Math.random() * LOOP*1000));
            }
            var t :int = getTimer();
            var ar :Array = [];
            for(var j :int = 0; j < LOOP; j++){
                ar[pts[i]] = i;
            }
            result("ar[pts[j]]でランダムに格納", t);
        }
        
        //表示
        private function result(caption :String, pre :int) :void{
            var post :int = getTimer();
            addDebLine("経過", post - pre, "開始時", pre, "終了時", post, "\t", caption);
        }

        
        
        //-------------------------------
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join("\t") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}
